/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ImplementationClassResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lcom/intellij/openapi/extensions/impl/InterfaceExtensionImplementationClassResolver;", "Lcom/intellij/openapi/extensions/impl/ImplementationClassResolver;", "<init>", "()V", "Lcom/intellij/openapi/components/ComponentManager;", "componentManager", "Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "adapter", "Ljava/lang/Class;", "resolveImplementationClass", "(Lcom/intellij/openapi/components/ComponentManager;Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;)Ljava/lang/Class;"})
public final class InterfaceExtensionImplementationClassResolver
implements ImplementationClassResolver {
    @NotNull
    public static final InterfaceExtensionImplementationClassResolver INSTANCE = new InterfaceExtensionImplementationClassResolver();

    private InterfaceExtensionImplementationClassResolver() {
    }

    @Override
    @NotNull
    public Class<?> resolveImplementationClass(@NotNull ComponentManager componentManager, @NotNull ExtensionComponentAdapter adapter) {
        Intrinsics.checkNotNullParameter(componentManager, "componentManager");
        Intrinsics.checkNotNullParameter(adapter, "adapter");
        Object className = adapter.implementationClassOrName;
        if (!(className instanceof String)) {
            Intrinsics.checkNotNull(className, "null cannot be cast to non-null type java.lang.Class<*>");
            return (Class)className;
        }
        PluginDescriptor pluginDescriptor = adapter.pluginDescriptor;
        Class clazz = componentManager.loadClass((String)className, pluginDescriptor);
        Intrinsics.checkNotNullExpressionValue(clazz, "loadClass(...)");
        Class result2 = clazz;
        if (!(result2.getClassLoader() == pluginDescriptor.getPluginClassLoader() || pluginDescriptor.getPluginClassLoader() == null || StringsKt.startsWith$default((String)className, "com.intellij.webcore.resourceRoots.", false, 2, null) || StringsKt.startsWith$default((String)className, "com.intellij.tasks.impl.", false, 2, null) || result2.isAnnotationPresent(InternalIgnoreDependencyViolation.class))) {
            String string = pluginDescriptor.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue(string, "getIdString(...)");
            String idString = string;
            if (!(Intrinsics.areEqual(idString, "com.intellij.java") || Intrinsics.areEqual(idString, "com.intellij.java.ide") || Intrinsics.areEqual(idString, "com.intellij.java.frontend") || Intrinsics.areEqual(idString, "com.intellij.kotlin.frontend") || Intrinsics.areEqual(idString, "org.jetbrains.android") || Intrinsics.areEqual(idString, "com.intellij.kotlinNative.platformDeps") || Intrinsics.areEqual(idString, "com.jetbrains.rider.android"))) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ExtensionPointImpl.class);
                Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
                logger.error(componentManager.createError("Created extension classloader is not equal to plugin's one.\nSee https://youtrack.jetbrains.com/articles/IDEA-A-65/Plugin-Model#internalignoredependencyviolation\n(\n  className=" + className + ",\n  extensionInstanceClassloader=" + result2.getClassLoader() + ",\n  pluginClassloader=" + pluginDescriptor.getPluginClassLoader() + "\n)", pluginDescriptor.getPluginId()));
            }
        }
        adapter.implementationClassOrName = result2;
        return result2;
    }
}

