/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ImplementationClassResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B3\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0011\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\u000e*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH'\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u0016\u0010\u001a\u001a\u00020\r8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0014\u0010\n\u001a\u00020\t8\u0000X\u0081\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u001cR\u0014\u0010 \u001a\u00020\u001d8 X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\b\u001a\u00020\u00078\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\b\u0010!\u001a\u0004\b\"\u0010#R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010$\u001a\u0004\b%\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010&"}, d2={"Lcom/intellij/openapi/extensions/impl/ExtensionComponentAdapter;", "Lcom/intellij/openapi/extensions/LoadingOrder$Orderable;", "", "implementationClassName", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "pluginDescriptor", "orderId", "Lcom/intellij/openapi/extensions/LoadingOrder;", "order", "Lcom/intellij/openapi/extensions/impl/ImplementationClassResolver;", "implementationClassResolver", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/extensions/PluginDescriptor;Ljava/lang/String;Lcom/intellij/openapi/extensions/LoadingOrder;Lcom/intellij/openapi/extensions/impl/ImplementationClassResolver;)V", "", "T", "Lcom/intellij/openapi/components/ComponentManager;", "componentManager", "createInstance", "(Lcom/intellij/openapi/components/ComponentManager;)Ljava/lang/Object;", "Ljava/lang/Class;", "getImplementationClass", "(Lcom/intellij/openapi/components/ComponentManager;)Ljava/lang/Class;", "toString", "()Ljava/lang/String;", "getAssignableToClassName", "assignableToClassName", "implementationClassOrName", "Ljava/lang/Object;", "Lcom/intellij/openapi/extensions/impl/ImplementationClassResolver;", "", "isInstanceCreated$intellij_platform_extensions", "()Z", "isInstanceCreated", "Lcom/intellij/openapi/extensions/LoadingOrder;", "getOrder", "()Lcom/intellij/openapi/extensions/LoadingOrder;", "Ljava/lang/String;", "getOrderId", "Lcom/intellij/openapi/extensions/PluginDescriptor;"})
public abstract class ExtensionComponentAdapter
implements LoadingOrder.Orderable {
    @NotNull
    public final PluginDescriptor pluginDescriptor;
    @Nullable
    private final String orderId;
    @NotNull
    private final LoadingOrder order;
    @NotNull
    public final ImplementationClassResolver implementationClassResolver;
    @NotNull
    public Object implementationClassOrName;

    public ExtensionComponentAdapter(@NotNull String implementationClassName, @NotNull PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order, @NotNull ImplementationClassResolver implementationClassResolver) {
        Intrinsics.checkNotNullParameter(implementationClassName, "implementationClassName");
        Intrinsics.checkNotNullParameter(pluginDescriptor, "pluginDescriptor");
        Intrinsics.checkNotNullParameter(order, "order");
        Intrinsics.checkNotNullParameter(implementationClassResolver, "implementationClassResolver");
        this.pluginDescriptor = pluginDescriptor;
        this.orderId = orderId;
        this.order = order;
        this.implementationClassResolver = implementationClassResolver;
        this.implementationClassOrName = implementationClassName;
    }

    @Override
    @Nullable
    public String getOrderId() {
        return this.orderId;
    }

    @Override
    @NotNull
    public LoadingOrder getOrder() {
        return this.order;
    }

    public abstract boolean isInstanceCreated$intellij_platform_extensions();

    @Nullable
    public abstract <T> T createInstance(@NotNull ComponentManager var1);

    @NotNull
    public final <T> Class<T> getImplementationClass(@NotNull ComponentManager componentManager) throws ClassNotFoundException {
        Intrinsics.checkNotNullParameter(componentManager, "componentManager");
        Class<?> clazz = this.implementationClassResolver.resolveImplementationClass(componentManager, this);
        Intrinsics.checkNotNull(clazz, "null cannot be cast to non-null type java.lang.Class<T of com.intellij.openapi.extensions.impl.ExtensionComponentAdapter.getImplementationClass>");
        return clazz;
    }

    @NotNull
    public final String getAssignableToClassName() {
        String string;
        Object implementationClassOrName = this.implementationClassOrName;
        if (implementationClassOrName instanceof String) {
            string = (String)implementationClassOrName;
        } else {
            Intrinsics.checkNotNull(implementationClassOrName, "null cannot be cast to non-null type java.lang.Class<*>");
            String string2 = ((Class)implementationClassOrName).getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        }
        return string;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(implementation=" + this.getAssignableToClassName() + ", plugin=" + this.pluginDescriptor + ')';
    }
}

