/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.StripedIDGenerator;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class RangeMarkerImpl
extends UserDataHolderBase
implements RangeMarkerEx {
    private static final Logger LOG = Logger.getInstance(RangeMarkerImpl.class);
    @NotNull
    private final Object myDocumentOrFile;
    RangeMarkerTree.RMNode<RangeMarkerEx> myNode;
    private volatile long myId;
    private static final StripedIDGenerator counter = new StripedIDGenerator();

    protected void unregisterInTree() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (!this.isValid()) {
            return;
        }
        IntervalTreeImpl tree = node.getTree();
        tree.checkMax(true);
        DocumentEx document = this.getCachedDocument();
        if (document == null) {
            this.storeOffsetsBeforeDying(node);
            this.myNode = null;
        } else {
            document.removeRangeMarker(this);
        }
        tree.checkMax(true);
    }

    public long getId() {
        long id = this.myId;
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            throw new IllegalStateException("Already disposed");
        }
        return id;
    }

    @Override
    public void dispose() {
        this.unregisterInTree();
    }

    @Override
    public int getStartOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null ? TextRangeScalarUtil.startOffset(this.myId) : node.intervalStart() + node.computeDeltaUpToRoot();
    }

    @Override
    public int getEndOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null ? TextRangeScalarUtil.endOffset(this.myId) : node.intervalEnd() + node.computeDeltaUpToRoot();
    }

    void invalidate() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node != null) {
            node.invalidate();
        }
    }

    @NotNull
    public final DocumentEx getDocument() {
        DocumentEx document;
        Object file = this.myDocumentOrFile;
        DocumentEx documentEx = document = file instanceof VirtualFile ? (DocumentEx)FileDocumentManager.getInstance().getDocument((VirtualFile)file) : (DocumentEx)file;
        if (document == null) {
            LOG.error("document is null; isValid=" + this.isValid() + "; file=" + file);
        }
        DocumentEx documentEx2 = document;
        if (documentEx2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(6);
        }
        return documentEx2;
    }

    DocumentEx getCachedDocument() {
        Object file = this.myDocumentOrFile;
        return file instanceof VirtualFile ? (DocumentEx)FileDocumentManager.getInstance().getCachedDocument((VirtualFile)file) : (DocumentEx)file;
    }

    @Override
    public boolean isGreedyToLeft() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToLeft();
    }

    @Override
    public boolean isGreedyToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToRight();
    }

    public boolean isStickingToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isStickingToRight();
    }

    final void onDocumentChanged(@NotNull DocumentEvent e2) {
        int newEnd;
        int newStart;
        if (e2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(8);
        }
        int oldStart = this.intervalStart();
        int oldEnd = this.intervalEnd();
        int docLength = e2.getDocument().getTextLength();
        if (!this.isValid()) {
            LOG.error("Invalid range marker " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + ". Event = " + e2 + ". Doc length=" + docLength + "; " + this.getClass());
            return;
        }
        if (oldStart > oldEnd || oldStart < 0 || oldEnd > docLength - e2.getNewLength() + e2.getOldLength()) {
            LOG.error("RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " is invalid before update. Event = " + e2 + ". Doc length=" + docLength + "; " + this.getClass());
            this.invalidate();
            return;
        }
        this.changedUpdateImpl(e2);
        if (this.isValid() && ((newStart = this.intervalStart()) > (newEnd = this.intervalEnd()) || newStart < 0 || newEnd > docLength)) {
            LOG.error("Update failed. Event = " + e2 + ". Doc length=" + docLength + "; " + this.getClass() + ". Before update: " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " After update: '" + this + "'");
            this.invalidate();
        }
    }

    protected void changedUpdateImpl(@NotNull DocumentEvent e2) {
        if (e2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(9);
        }
        this.doChangeUpdate(e2);
    }

    private void doChangeUpdate(@NotNull DocumentEvent e2) {
        long newRange;
        if (e2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(10);
        }
        if (!this.isValid()) {
            return;
        }
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        long l2 = newRange = node == null ? -1L : RangeMarkerImpl.applyChange(e2, node.toScalarRange(), this.isGreedyToLeft(), this.isGreedyToRight(), this.isStickingToRight());
        if (newRange == -1L) {
            this.invalidate();
        } else {
            node.setRange(newRange);
        }
    }

    protected void onReTarget(@NotNull DocumentEvent e2) {
        if (e2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(13);
        }
    }

    /*
     * WARNING - void declaration
     */
    static long applyChange(@NotNull DocumentEvent e2, long range, boolean isGreedyToLeft, boolean isGreedyToRight, boolean bl) {
        int intervalEnd;
        int intervalStart;
        if (e2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(14);
        }
        if ((intervalStart = TextRangeScalarUtil.startOffset(range)) == (intervalEnd = TextRangeScalarUtil.endOffset(range))) {
            void isStickingToRight;
            return RangeMarkerImpl.processIfOnePoint(e2, intervalStart, isGreedyToRight, (boolean)isStickingToRight);
        }
        int offset = e2.getOffset();
        int oldLength = e2.getOldLength();
        int newLength = e2.getNewLength();
        if (offset > intervalEnd) {
            return TextRangeScalarUtil.toScalarRange(intervalStart, intervalEnd);
        }
        if (!isGreedyToRight && intervalEnd == offset) {
            if (e2 instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e2).getInitialStartOffset() < offset) {
                return TextRangeScalarUtil.toScalarRange(intervalStart, intervalEnd + newLength);
            }
            return TextRangeScalarUtil.toScalarRange(intervalStart, intervalEnd);
        }
        if (intervalStart > offset + oldLength) {
            return TextRangeScalarUtil.toScalarRange(intervalStart + newLength - oldLength, intervalEnd + newLength - oldLength);
        }
        if (!isGreedyToLeft && intervalStart == offset + oldLength) {
            if (e2 instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e2).getInitialStartOffset() + ((DocumentEventImpl)e2).getInitialOldLength() > offset) {
                return TextRangeScalarUtil.toScalarRange(intervalStart, intervalEnd + newLength);
            }
            return TextRangeScalarUtil.toScalarRange(intervalStart + newLength - oldLength, intervalEnd + newLength - oldLength);
        }
        if (intervalStart <= offset && intervalEnd >= offset + oldLength) {
            return TextRangeScalarUtil.toScalarRange(intervalStart, intervalEnd + newLength - oldLength);
        }
        if (intervalStart >= offset && intervalStart <= offset + oldLength && intervalEnd > offset + oldLength) {
            return TextRangeScalarUtil.toScalarRange(offset + newLength, intervalEnd + newLength - oldLength);
        }
        if (intervalEnd <= offset + oldLength && intervalStart < offset) {
            return TextRangeScalarUtil.toScalarRange(intervalStart, offset);
        }
        return -1L;
    }

    private static long processIfOnePoint(@NotNull DocumentEvent e2, int intervalStart, boolean greedyRight, boolean stickyRight) {
        if (e2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(15);
        }
        int offset = e2.getOffset();
        int oldLength = e2.getOldLength();
        int oldEnd = offset + oldLength;
        if (offset < intervalStart && intervalStart < oldEnd) {
            return -1L;
        }
        if (offset == intervalStart && oldLength == 0) {
            if (greedyRight) {
                return TextRangeScalarUtil.toScalarRange(intervalStart, intervalStart + e2.getNewLength());
            }
            if (stickyRight) {
                int off = intervalStart + e2.getNewLength();
                return TextRangeScalarUtil.toScalarRange(off, off);
            }
        }
        if (intervalStart > oldEnd || intervalStart == oldEnd && oldLength > 0) {
            int off = intervalStart + e2.getNewLength() - oldLength;
            return TextRangeScalarUtil.toScalarRange(off, off);
        }
        return TextRangeScalarUtil.toScalarRange(intervalStart, intervalStart);
    }

    @Override
    public String toString() {
        return "RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "" : "invalid:") + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")") + " " + (this.isValid() ? Long.valueOf(this.getId()) : "");
    }

    void setRange(long scalarRange) {
        this.myNode.setRange(scalarRange);
    }

    @Override
    public boolean isValid() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null || !node.isValid()) {
            return false;
        }
        Object file = this.myDocumentOrFile;
        return file instanceof Document || RangeMarkerImpl.canHaveDocument((VirtualFile)file);
    }

    private static boolean canHaveDocument(@NotNull VirtualFile file) {
        Document document;
        if (file == null) {
            RangeMarkerImpl.$$$reportNull$$$0(16);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file)) != null) {
            return true;
        }
        if (!file.isValid() || file.isDirectory() || RangeMarkerImpl.isBinaryWithoutDecompiler(file)) {
            return false;
        }
        return !file.getFileType().isBinary() || !FileUtilRt.isTooLarge(file.getLength());
    }

    private static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file) {
        FileType fileType;
        if (file == null) {
            RangeMarkerImpl.$$$reportNull$$$0(17);
        }
        return (fileType = file.getFileType()).isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(fileType) == null;
    }

    public int intervalStart() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalStart();
    }

    public int intervalEnd() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalEnd();
    }

    long toScalarRange() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1L;
        }
        return node.toScalarRange();
    }

    void storeOffsetsBeforeDying(@NotNull IntervalTreeImpl.IntervalNode<?> node) {
        if (node == null) {
            RangeMarkerImpl.$$$reportNull$$$0(20);
        }
        int delta = node.computeDeltaUpToRoot();
        long range = TextRangeScalarUtil.shift(node.toScalarRange(), delta, delta);
        int startOffset = Math.max(0, TextRangeScalarUtil.startOffset(range));
        int endOffset = Math.max(startOffset, TextRangeScalarUtil.endOffset(range));
        this.myId = TextRangeScalarUtil.toScalarRange(startOffset, endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentOrFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/RangeMarkerImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/RangeMarkerImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "reCalcTextRangeAfterReload";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "estimateDocumentLength";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onDocumentChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdateImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doChangeUpdate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "persistentHighlighterUpdate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "translatedViaDiff";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onReTarget";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyChange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processIfOnePoint";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canHaveDocument";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithoutDecompiler";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reCalcTextRangeAfterReload";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "storeOffsetsBeforeDying";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

