/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.AbstractBundle;
import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.lang.java.parser.BasicDeclarationParser;
import com.intellij.lang.java.parser.BasicJavaParser;
import com.intellij.lang.java.parser.BasicJavaParserUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicFileParser {
    protected final TokenSet IMPORT_LIST_STOPPER_SET;
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final TokenSet IMPLICIT_CLASS_INDICATORS;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public BasicFileParser(@NotNull BasicJavaParser javaParser) {
        if (javaParser == null) {
            BasicFileParser.$$$reportNull$$$0(0);
        }
        this.myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
        this.IMPORT_LIST_STOPPER_SET = TokenSet.orSet(BasicElementTypes.BASIC_MODIFIER_BIT_SET, TokenSet.create(JavaTokenType.CLASS_KEYWORD, JavaTokenType.INTERFACE_KEYWORD, JavaTokenType.ENUM_KEYWORD, JavaTokenType.AT));
        this.IMPLICIT_CLASS_INDICATORS = TokenSet.create(this.myJavaElementTypeContainer.METHOD, this.myJavaElementTypeContainer.FIELD, this.myJavaElementTypeContainer.CLASS_INITIALIZER);
    }

    public void parse(@NotNull PsiBuilder builder2) {
        if (builder2 == null) {
            BasicFileParser.$$$reportNull$$$0(1);
        }
        this.parseFile(builder2, this::stopImportListParsing, JavaPsiBundle.INSTANCE, "expected.class.or.interface");
    }

    public void parseFile(@NotNull PsiBuilder builder2, @NotNull Predicate<? super PsiBuilder> importListStopper, @NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (builder2 == null) {
            BasicFileParser.$$$reportNull$$$0(2);
        }
        if (importListStopper == null) {
            BasicFileParser.$$$reportNull$$$0(3);
        }
        if (bundle == null) {
            BasicFileParser.$$$reportNull$$$0(4);
        }
        if (errorMessageKey == null) {
            BasicFileParser.$$$reportNull$$$0(5);
        }
        this.parsePackageStatement(builder2);
        Pair<PsiBuilder.Marker, Boolean> impListInfo = this.parseImportList(builder2, importListStopper);
        Boolean firstDeclarationOk = null;
        PsiBuilder.Marker firstDeclaration = null;
        SyntaxTreeBuilder.Marker invalidElements = null;
        boolean isImplicitClass = false;
        while (!builder2.eof()) {
            if (builder2.getTokenType() == JavaTokenType.SEMICOLON) {
                builder2.advanceLexer();
                continue;
            }
            PsiBuilder.Marker declaration = this.myParser.getModuleParser().parse(builder2);
            if (declaration == null) {
                declaration = this.parseInitial(builder2);
            }
            if (declaration != null) {
                if (invalidElements != null) {
                    invalidElements.errorBefore(BasicFileParser.error(bundle, errorMessageKey), declaration);
                    invalidElements = null;
                }
                if (firstDeclarationOk == null) {
                    firstDeclarationOk = BasicJavaParserUtil.exprType(declaration) != this.myJavaElementTypeContainer.MODIFIER_LIST;
                }
                if (firstDeclaration == null) {
                    firstDeclaration = declaration;
                }
                if (isImplicitClass || !this.IMPLICIT_CLASS_INDICATORS.contains(BasicJavaParserUtil.exprType(declaration))) continue;
                isImplicitClass = true;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder2.mark();
            }
            builder2.advanceLexer();
            if (firstDeclarationOk != null) continue;
            firstDeclarationOk = false;
        }
        if (invalidElements != null) {
            invalidElements.error(BasicFileParser.error(bundle, errorMessageKey));
        }
        if (((Boolean)impListInfo.second).booleanValue() && firstDeclarationOk == Boolean.TRUE) {
            ((PsiBuilder.Marker)impListInfo.first).setCustomEdgeTokenBinders(this.myWhiteSpaceAndCommentSetHolder.getPrecedingCommentBinder(), null);
            firstDeclaration.setCustomEdgeTokenBinders(this.myWhiteSpaceAndCommentSetHolder.getSpecialPrecedingCommentBinder(), null);
        }
        if (isImplicitClass) {
            PsiBuilder.Marker beforeFirst = firstDeclaration.precede();
            BasicJavaParserUtil.done(beforeFirst, this.myJavaElementTypeContainer.IMPLICIT_CLASS, this.myWhiteSpaceAndCommentSetHolder);
        }
    }

    private boolean stopImportListParsing(PsiBuilder b2) {
        String text;
        IElementType type2 = b2.getTokenType();
        if (this.IMPORT_LIST_STOPPER_SET.contains(type2) || BasicDeclarationParser.isRecordToken(b2, type2)) {
            return true;
        }
        return type2 == JavaTokenType.IDENTIFIER && ("open".equals(text = b2.getTokenText()) || "module".equals(text));
    }

    @Nullable
    protected PsiBuilder.Marker parseInitial(PsiBuilder builder2) {
        return this.myParser.getDeclarationParser().parse(builder2, BasicDeclarationParser.BaseContext.FILE);
    }

    private void parsePackageStatement(PsiBuilder builder2) {
        PsiBuilder.Marker ref;
        PsiBuilder.Marker statement = builder2.mark();
        if (!PsiBuilderUtil.expect(builder2, JavaTokenType.PACKAGE_KEYWORD)) {
            PsiBuilder.Marker modList = builder2.mark();
            this.myParser.getDeclarationParser().parseAnnotations(builder2);
            BasicJavaParserUtil.done(modList, this.myJavaElementTypeContainer.MODIFIER_LIST, this.myWhiteSpaceAndCommentSetHolder);
            if (!PsiBuilderUtil.expect(builder2, JavaTokenType.PACKAGE_KEYWORD)) {
                statement.rollbackTo();
                return;
            }
        }
        if ((ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder2, true, false, false, false)) == null) {
            statement.error(JavaPsiBundle.message("expected.class.or.interface", new Object[0]));
            return;
        }
        BasicJavaParserUtil.semicolon(builder2);
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.PACKAGE_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
    }

    @NotNull
    protected Pair<PsiBuilder.Marker, Boolean> parseImportList(PsiBuilder builder2, Predicate<? super PsiBuilder> stopper) {
        PsiBuilder.Marker list = builder2.mark();
        boolean isEmpty = true;
        SyntaxTreeBuilder.Marker invalidElements = null;
        while (!builder2.eof() && !stopper.test(builder2)) {
            if (builder2.getTokenType() == JavaTokenType.SEMICOLON) {
                builder2.advanceLexer();
                continue;
            }
            PsiBuilder.Marker statement = this.parseImportStatement(builder2);
            if (statement != null) {
                isEmpty = false;
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaPsiBundle.message("unexpected.token", new Object[0]), statement);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder2.mark();
            }
            builder2.advanceLexer();
        }
        if (invalidElements != null) {
            invalidElements.rollbackTo();
        }
        if (isEmpty) {
            PsiBuilder.Marker precede = list.precede();
            list.rollbackTo();
            list = precede;
        }
        BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.IMPORT_LIST, this.myWhiteSpaceAndCommentSetHolder);
        Pair<PsiBuilder.Marker, Boolean> pair = Pair.create(list, isEmpty);
        if (pair == null) {
            BasicFileParser.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @Nullable
    protected PsiBuilder.Marker parseImportStatement(PsiBuilder builder2) {
        if (builder2.getTokenType() != JavaTokenType.IMPORT_KEYWORD) {
            return null;
        }
        PsiBuilder.Marker statement = builder2.mark();
        builder2.advanceLexer();
        boolean isStatic = PsiBuilderUtil.expect(builder2, JavaTokenType.STATIC_KEYWORD);
        IElementType type2 = isStatic ? this.myJavaElementTypeContainer.IMPORT_STATIC_STATEMENT : this.myJavaElementTypeContainer.IMPORT_STATEMENT;
        boolean isOk = this.myParser.getReferenceParser().parseImportCodeReference(builder2, isStatic);
        if (isOk) {
            BasicJavaParserUtil.semicolon(builder2);
        }
        BasicJavaParserUtil.done(statement, type2, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private static String error(@NotNull AbstractBundle bundle, @NotNull String errorMessageKey) {
        if (bundle == null) {
            BasicFileParser.$$$reportNull$$$0(7);
        }
        if (errorMessageKey == null) {
            BasicFileParser.$$$reportNull$$$0(8);
        }
        String string = bundle.getMessage(errorMessageKey, new Object[0]);
        if (string == null) {
            BasicFileParser.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importListStopper";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessageKey";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/BasicFileParser";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/BasicFileParser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseImportList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "error";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseFile";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

