/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DataLoader;
import com.intellij.util.lang.ZipFilePool;
import java.io.InputStream;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\fH\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0015"}, d2={"Lcom/intellij/ide/plugins/ImmutableZipFileDataLoader;", "Lcom/intellij/ide/plugins/DataLoader;", "Lcom/intellij/util/lang/ZipFilePool$EntryResolver;", "resolver", "Ljava/nio/file/Path;", "zipPath", "<init>", "(Lcom/intellij/util/lang/ZipFilePool$EntryResolver;Ljava/nio/file/Path;)V", "jarFile", "", "isExcludedFromSubSearch", "(Ljava/nio/file/Path;)Z", "", "path", "pluginDescriptorSourceOnly", "Ljava/io/InputStream;", "load", "(Ljava/lang/String;Z)Ljava/io/InputStream;", "toString", "()Ljava/lang/String;", "Lcom/intellij/util/lang/ZipFilePool$EntryResolver;", "Ljava/nio/file/Path;"})
public final class ImmutableZipFileDataLoader
implements DataLoader {
    @NotNull
    private final ZipFilePool.EntryResolver resolver;
    @NotNull
    private final Path zipPath;

    public ImmutableZipFileDataLoader(@NotNull ZipFilePool.EntryResolver resolver, @NotNull Path zipPath) {
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Intrinsics.checkNotNullParameter(zipPath, "zipPath");
        this.resolver = resolver;
        this.zipPath = zipPath;
    }

    @Override
    @Nullable
    public InputStream load(@NotNull String path, boolean pluginDescriptorSourceOnly) {
        String string;
        Intrinsics.checkNotNullParameter(path, "path");
        if (path.charAt(0) == '/') {
            String string2 = path.substring(1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        } else {
            string = path;
        }
        return this.resolver.loadZipEntry(string);
    }

    @Override
    public boolean isExcludedFromSubSearch(@NotNull Path jarFile) {
        Intrinsics.checkNotNullParameter(jarFile, "jarFile");
        return jarFile == this.zipPath;
    }

    @Override
    @NotNull
    public String toString() {
        return this.resolver.toString();
    }
}

