/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptorImplKt;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.io.File;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u001a\u0010\u0012\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e*\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018*\b\u0012\u0004\u0012\u00020\u00190\u0013\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "extensionPointNameComparator", "Ljava/util/Comparator;", "", "registryEpName", "checkCycle", "", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "configFile", "visitedFiles", "", "pluginPathToUserString", "file", "Ljava/nio/file/Path;", "joinedPluginIds", "", "Lcom/intellij/openapi/extensions/PluginId;", "operation", "toPluginDescriptors", "toPluginIdSet", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "intellij.platform.core.impl"})
public final class IdeaPluginDescriptorImplKt {
    @NotNull
    private static final Comparator<String> extensionPointNameComparator = IdeaPluginDescriptorImplKt::extensionPointNameComparator$lambda$2;

    private static final Logger getLOG() {
        return PluginManagerCore.getLogger();
    }

    @NotNull
    public static final String joinedPluginIds(@NotNull Iterable<PluginId> $this$joinedPluginIds, @NotNull String operation) {
        Intrinsics.checkNotNullParameter($this$joinedPluginIds, "<this>");
        Intrinsics.checkNotNullParameter(operation, "operation");
        return CollectionsKt.joinToString$default($this$joinedPluginIds, null, "Plugins to " + operation + ": [", "]", 0, null, joinedPluginIds.1.INSTANCE, 25, null);
    }

    @NotNull
    public static final String pluginPathToUserString(@NotNull Path file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return StringsKt.replace$default(((Object)file).toString(), System.getProperty("user.home") + File.separatorChar, "" + '~' + File.separatorChar, false, 4, null);
    }

    private static final void checkCycle(IdeaPluginDescriptorImpl descriptor2, String configFile2, List<String> visitedFiles) {
        int n2 = visitedFiles.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Intrinsics.areEqual(configFile2, visitedFiles.get(i2))) continue;
            List<String> cycle = visitedFiles.subList(i2, visitedFiles.size());
            throw new RuntimeException("Plugin " + descriptor2 + " optional descriptors form a cycle: " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)cycle));
        }
    }

    private static final int extensionPointNameComparator$lambda$2(String o1, String o2) {
        if (Intrinsics.areEqual(o1, "com.intellij.registryKey")) {
            return Intrinsics.areEqual(o2, "com.intellij.registryKey") ? 0 : -1;
        }
        if (Intrinsics.areEqual(o2, "com.intellij.registryKey")) {
            return 1;
        }
        Intrinsics.checkNotNull(o2);
        return o1.compareTo(o2);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return IdeaPluginDescriptorImplKt.getLOG();
    }

    public static final /* synthetic */ void access$checkCycle(IdeaPluginDescriptorImpl descriptor2, String configFile2, List visitedFiles) {
        IdeaPluginDescriptorImplKt.checkCycle(descriptor2, configFile2, visitedFiles);
    }

    public static final /* synthetic */ Comparator access$getExtensionPointNameComparator$p() {
        return extensionPointNameComparator;
    }
}

