/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.InstanceHolder;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.SystemProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EventWatcher {
    public static final boolean isEnabledAggregated = SystemProperties.getBooleanProperty("idea.event.queue.dispatch.report-aggregated-stats-to-otel", true);
    public static final boolean isEnabledDetailed = SystemProperties.getBooleanProperty("idea.event.queue.dispatch.listen", false);

    public static boolean isDetailedWatcherEnabled() {
        return isEnabledDetailed;
    }

    public static boolean isAggregatedWatcherEnabled() {
        return isEnabledAggregated;
    }

    @Nullable
    public static EventWatcher getInstanceOrNull() {
        Application app;
        if (!EventWatcher.isDetailedWatcherEnabled() && !EventWatcher.isAggregatedWatcherEnabled()) {
            return null;
        }
        EventWatcher result2 = InstanceHolder.instance;
        if (result2 == null && LoadingState.COMPONENTS_LOADED.isOccurred() && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            InstanceHolder.instance = result2 = app.getService(EventWatcher.class);
        }
        return result2;
    }

    public void runnableTaskFinished(@NotNull Runnable var1, long var2, int var4, long var5, boolean var7);
}

