/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.Comment;
import com.google.gwt.dev.js.rhino.Context;
import com.google.gwt.dev.js.rhino.LineBuffer;
import com.google.gwt.dev.js.rhino.ScriptRuntime;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class TokenStream {
    private static final Map<String, Integer> KEYWORDS = new HashMap<String, Integer>();
    private LineBuffer in;
    int flags;
    String regExpFlags;
    private String sourceName;
    private int pushbackToken;
    private int tokenno;
    CodePosition secondToLastPosition;
    CodePosition lastPosition;
    CodePosition tokenPosition;
    CodePosition lastTokenPosition;
    private Comment headComment;
    private Comment lastComment;
    private int op;
    public boolean treatKeywordAsIdentifier;
    private String string = "";
    private double number;
    private char[] stringBuffer = new char[128];
    private int stringBufferTop;

    public static String tokenToName(int token) {
        switch (token) {
            case -1: {
                return "error";
            }
            case 0: {
                return "eof";
            }
            case 1: {
                return "eol";
            }
            case 2: {
                return "popv";
            }
            case 3: {
                return "enterwith";
            }
            case 4: {
                return "leavewith";
            }
            case 5: {
                return "return";
            }
            case 6: {
                return "goto";
            }
            case 7: {
                return "ifeq";
            }
            case 8: {
                return "ifne";
            }
            case 9: {
                return "dup";
            }
            case 10: {
                return "setname";
            }
            case 11: {
                return "bitor";
            }
            case 12: {
                return "bitxor";
            }
            case 13: {
                return "bitand";
            }
            case 14: {
                return "eq";
            }
            case 15: {
                return "ne";
            }
            case 16: {
                return "lt";
            }
            case 17: {
                return "le";
            }
            case 18: {
                return "gt";
            }
            case 19: {
                return "ge";
            }
            case 20: {
                return "lsh";
            }
            case 21: {
                return "rsh";
            }
            case 22: {
                return "ursh";
            }
            case 23: {
                return "add";
            }
            case 24: {
                return "sub";
            }
            case 25: {
                return "mul";
            }
            case 26: {
                return "div";
            }
            case 27: {
                return "mod";
            }
            case 28: {
                return "bitnot";
            }
            case 29: {
                return "neg";
            }
            case 30: {
                return "new";
            }
            case 31: {
                return "delprop";
            }
            case 32: {
                return "typeof";
            }
            case 33: {
                return "nameinc";
            }
            case 34: {
                return "propinc";
            }
            case 35: {
                return "eleminc";
            }
            case 36: {
                return "namedec";
            }
            case 37: {
                return "propdec";
            }
            case 38: {
                return "elemdec";
            }
            case 39: {
                return "getprop";
            }
            case 40: {
                return "setprop";
            }
            case 41: {
                return "getelem";
            }
            case 42: {
                return "setelem";
            }
            case 43: {
                return "call";
            }
            case 44: {
                return "name";
            }
            case 148: {
                return "integer";
            }
            case 45: {
                return "double";
            }
            case 46: {
                return "string";
            }
            case 47: {
                return "zero";
            }
            case 48: {
                return "one";
            }
            case 49: {
                return "null";
            }
            case 50: {
                return "this";
            }
            case 51: {
                return "false";
            }
            case 52: {
                return "true";
            }
            case 53: {
                return "sheq";
            }
            case 54: {
                return "shne";
            }
            case 55: {
                return "closure";
            }
            case 56: {
                return "object";
            }
            case 57: {
                return "pop";
            }
            case 58: {
                return "pos";
            }
            case 59: {
                return "varinc";
            }
            case 60: {
                return "vardec";
            }
            case 61: {
                return "bindname";
            }
            case 62: {
                return "throw";
            }
            case 63: {
                return "in";
            }
            case 64: {
                return "instanceof";
            }
            case 65: {
                return "gosub";
            }
            case 66: {
                return "retsub";
            }
            case 67: {
                return "callspecial";
            }
            case 68: {
                return "getthis";
            }
            case 69: {
                return "newtemp";
            }
            case 70: {
                return "usetemp";
            }
            case 71: {
                return "getbase";
            }
            case 72: {
                return "getvar";
            }
            case 73: {
                return "setvar";
            }
            case 74: {
                return "undefined";
            }
            case 75: {
                return "try";
            }
            case 76: {
                return "endtry";
            }
            case 77: {
                return "newscope";
            }
            case 78: {
                return "typeofname";
            }
            case 79: {
                return "enuminit";
            }
            case 80: {
                return "enumnext";
            }
            case 81: {
                return "getproto";
            }
            case 82: {
                return "getparent";
            }
            case 83: {
                return "setproto";
            }
            case 84: {
                return "setparent";
            }
            case 85: {
                return "scope";
            }
            case 86: {
                return "getscopeparent";
            }
            case 87: {
                return "thisfn";
            }
            case 88: {
                return "jthrow";
            }
            case 89: {
                return "semi";
            }
            case 90: {
                return "lb";
            }
            case 91: {
                return "rb";
            }
            case 92: {
                return "lc";
            }
            case 93: {
                return "rc";
            }
            case 94: {
                return "lp";
            }
            case 95: {
                return "gwt";
            }
            case 96: {
                return "comma";
            }
            case 97: {
                return "assign";
            }
            case 98: {
                return "hook";
            }
            case 99: {
                return "colon";
            }
            case 100: {
                return "or";
            }
            case 101: {
                return "and";
            }
            case 102: {
                return "eqop";
            }
            case 103: {
                return "relop";
            }
            case 104: {
                return "shop";
            }
            case 105: {
                return "unaryop";
            }
            case 106: {
                return "inc";
            }
            case 107: {
                return "dec";
            }
            case 108: {
                return "dot";
            }
            case 109: {
                return "primary";
            }
            case 110: {
                return "function";
            }
            case 111: {
                return "export";
            }
            case 112: {
                return "import";
            }
            case 113: {
                return "if";
            }
            case 114: {
                return "else";
            }
            case 115: {
                return "switch";
            }
            case 116: {
                return "case";
            }
            case 117: {
                return "default";
            }
            case 118: {
                return "while";
            }
            case 119: {
                return "do";
            }
            case 120: {
                return "for";
            }
            case 121: {
                return "break";
            }
            case 122: {
                return "continue";
            }
            case 150: {
                return "yield";
            }
            case 123: {
                return "var";
            }
            case 124: {
                return "with";
            }
            case 125: {
                return "catch";
            }
            case 126: {
                return "finally";
            }
            case 128: {
                return "nop";
            }
            case 129: {
                return "not";
            }
            case 130: {
                return "pre";
            }
            case 131: {
                return "post";
            }
            case 132: {
                return "void";
            }
            case 133: {
                return "block";
            }
            case 134: {
                return "arraylit";
            }
            case 135: {
                return "objlit";
            }
            case 136: {
                return "label";
            }
            case 137: {
                return "target";
            }
            case 138: {
                return "loop";
            }
            case 139: {
                return "enumdone";
            }
            case 140: {
                return "exprstmt";
            }
            case 141: {
                return "parent";
            }
            case 142: {
                return "convert";
            }
            case 143: {
                return "jsr";
            }
            case 144: {
                return "newlocal";
            }
            case 145: {
                return "uselocal";
            }
            case 147: {
                return "script";
            }
        }
        return "<unknown=" + token + ">";
    }

    public String tokenToString(int token) {
        String name = TokenStream.tokenToName(token);
        switch (token) {
            case 97: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 109: {
                return name + " " + TokenStream.tokenToName(this.op);
            }
            case 44: 
            case 46: 
            case 56: {
                return name + " `" + this.string + "'";
            }
            case 148: {
                return "NUMBER_INT " + (int)this.number;
            }
            case 45: {
                return "NUMBER " + this.number;
            }
        }
        return name;
    }

    private int stringToKeyword(String name) {
        Integer id = KEYWORDS.get(name);
        if (id == null) {
            return 0;
        }
        this.op = id >> 8;
        return id & 0xFF;
    }

    public TokenStream(Reader in, String sourceName, CodePosition position) {
        this.in = new LineBuffer(in, position);
        this.pushbackToken = 0;
        this.sourceName = sourceName;
        this.flags = 0;
        this.secondToLastPosition = position;
        this.lastPosition = position;
        this.tokenPosition = position;
        this.lastTokenPosition = position;
    }

    public boolean matchToken(int toMatch) throws IOException {
        int token = this.getToken();
        if (token == toMatch) {
            return true;
        }
        this.ungetToken(token);
        return false;
    }

    public void ungetToken(int tt) {
        if (this.pushbackToken != 0 && tt != -1) {
            String message = Context.getMessage2("msg.token.replaces.pushback", this.tokenToString(tt), this.tokenToString(this.pushbackToken));
            throw new RuntimeException(message);
        }
        this.pushbackToken = tt;
        this.lastPosition = this.secondToLastPosition;
        this.lastTokenPosition = this.tokenPosition;
        --this.tokenno;
    }

    public int peekToken() throws IOException {
        return this.peekTokenHelper(this.getToken());
    }

    private int peekTokenHelper(int token) throws IOException {
        this.pushbackToken = token;
        this.lastPosition = this.secondToLastPosition;
        this.lastTokenPosition = this.tokenPosition;
        --this.tokenno;
        return token;
    }

    public int peekTokenSameLine() throws IOException {
        this.flags |= 1;
        int result2 = this.peekToken();
        this.flags &= 0xFFFFFFFE;
        if (this.pushbackToken == 1) {
            this.pushbackToken = 0;
        }
        return result2;
    }

    private static boolean isAlpha(int c2) {
        return c2 >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90;
    }

    static boolean isDigit(int c2) {
        return c2 >= 48 && c2 <= 57;
    }

    static int xDigitToInt(int c2) {
        if (48 <= c2 && c2 <= 57) {
            return c2 - 48;
        }
        if (97 <= c2 && c2 <= 102) {
            return c2 - 87;
        }
        if (65 <= c2 && c2 <= 70) {
            return c2 - 55;
        }
        return -1;
    }

    public static boolean isJSSpace(int c2) {
        return c2 == 32 || c2 == 9 || c2 == 12 || c2 == 11 || c2 == 160 || Character.getType((char)c2) == 12;
    }

    private void skipLine() throws IOException {
        int c2;
        while ((c2 = this.in.read()) != -1 && c2 != 10) {
        }
        this.in.unread();
    }

    public void collectCommentsAfter() throws IOException {
        this.ungetToken(this.getToken());
    }

    public int getToken() throws IOException {
        int c2;
        this.lastTokenPosition = this.tokenPosition;
        while ((c2 = this.getTokenHelper()) == 65535) {
        }
        this.updatePosition();
        return c2;
    }

    private int getTokenHelper() throws IOException {
        boolean identifierStart;
        int c2;
        ++this.tokenno;
        if (this.pushbackToken != 0) {
            int result2 = this.pushbackToken;
            this.pushbackToken = 0;
            return result2;
        }
        do {
            if ((c2 = this.in.read()) != 10) continue;
            this.flags &= 0xFFFFFFDF;
            if ((this.flags & 1) != 0) break;
        } while (TokenStream.isJSSpace(c2) || c2 == 10);
        this.tokenPosition = new CodePosition(this.in.getLineno(), this.in.getColumnno() - 1);
        if (c2 == -1) {
            return 0;
        }
        if (c2 != 45 && c2 != 10) {
            this.flags |= 0x20;
        }
        boolean isUnicodeEscapeStart = false;
        if (c2 == 92) {
            c2 = this.in.read();
            if (c2 == 117) {
                identifierStart = true;
                isUnicodeEscapeStart = true;
                this.stringBufferTop = 0;
            } else {
                identifierStart = false;
                c2 = 92;
                this.in.unread();
            }
        } else {
            identifierStart = Character.isJavaIdentifierStart((char)c2);
            if (identifierStart) {
                this.stringBufferTop = 0;
                this.addToString(c2);
            }
            if (c2 == 64) {
                this.stringBufferTop = 0;
                this.addToString(c2);
                return this.jsniMatchReference();
            }
        }
        if (identifierStart) {
            int result3;
            boolean containsEscape = isUnicodeEscapeStart;
            while (true) {
                if (isUnicodeEscapeStart) {
                    int escapeVal = 0;
                    for (int i2 = 0; i2 != 4 && (escapeVal = escapeVal << 4 | TokenStream.xDigitToInt(c2 = this.in.read())) >= 0; ++i2) {
                    }
                    if (escapeVal < 0) {
                        this.reportTokenError("msg.invalid.escape", null);
                        return -1;
                    }
                    this.addToString(escapeVal);
                    isUnicodeEscapeStart = false;
                    continue;
                }
                c2 = this.in.read();
                if (c2 == 92) {
                    c2 = this.in.read();
                    if (c2 == 117) {
                        isUnicodeEscapeStart = true;
                        containsEscape = true;
                        continue;
                    }
                    this.reportTokenError("msg.illegal.character", null);
                    return -1;
                }
                if (!Character.isJavaIdentifierPart((char)c2)) break;
                this.addToString(c2);
            }
            this.in.unread();
            String str = this.getStringFromBuffer();
            if (!containsEscape && !this.treatKeywordAsIdentifier && (result3 = this.stringToKeyword(str)) != 0) {
                return result3;
            }
            this.string = str;
            return 44;
        }
        if (TokenStream.isDigit(c2) || c2 == 46 && TokenStream.isDigit(this.in.peek())) {
            double dval;
            this.stringBufferTop = 0;
            int base = 10;
            if (c2 == 48) {
                c2 = this.in.read();
                if (c2 == 120 || c2 == 88) {
                    base = 16;
                    c2 = this.in.read();
                } else if (TokenStream.isDigit(c2)) {
                    base = 8;
                } else {
                    this.addToString(48);
                }
            }
            if (base == 16) {
                while (0 <= TokenStream.xDigitToInt(c2)) {
                    this.addToString(c2);
                    c2 = this.in.read();
                }
            } else {
                while (48 <= c2 && c2 <= 57) {
                    if (base == 8 && c2 >= 56) {
                        Object[] errArgs = new Object[]{c2 == 56 ? "8" : "9"};
                        this.reportTokenWarning("msg.bad.octal.literal", errArgs);
                        base = 10;
                    }
                    this.addToString(c2);
                    c2 = this.in.read();
                }
            }
            boolean isInteger = true;
            if (base == 10 && (c2 == 46 || c2 == 101 || c2 == 69)) {
                isInteger = false;
                if (c2 == 46) {
                    do {
                        this.addToString(c2);
                    } while (TokenStream.isDigit(c2 = this.in.read()));
                }
                if (c2 == 101 || c2 == 69) {
                    this.addToString(c2);
                    c2 = this.in.read();
                    if (c2 == 43 || c2 == 45) {
                        this.addToString(c2);
                        c2 = this.in.read();
                    }
                    if (!TokenStream.isDigit(c2)) {
                        this.reportTokenError("msg.missing.exponent", null);
                        return -1;
                    }
                    do {
                        this.addToString(c2);
                    } while (TokenStream.isDigit(c2 = this.in.read()));
                }
            }
            this.in.unread();
            String numString = this.getStringFromBuffer();
            if (base == 10 && !isInteger) {
                try {
                    dval = Double.valueOf(numString);
                }
                catch (NumberFormatException ex) {
                    Object[] errArgs = new Object[]{ex.getMessage()};
                    this.reportTokenError("msg.caught.nfe", errArgs);
                    return -1;
                }
            } else {
                dval = ScriptRuntime.stringToNumber(numString, 0, base);
            }
            this.number = dval;
            if (isInteger) {
                return 148;
            }
            return 45;
        }
        if (c2 == 34 || c2 == 39) {
            int quoteChar = c2;
            int val = 0;
            this.stringBufferTop = 0;
            c2 = this.in.read();
            block47: while (c2 != quoteChar) {
                if (c2 == 10 || c2 == -1) {
                    this.in.unread();
                    this.reportTokenError("msg.unterminated.string.lit", null);
                    return -1;
                }
                if (c2 == 92) {
                    c2 = this.in.read();
                    switch (c2) {
                        case 98: {
                            c2 = 8;
                            break;
                        }
                        case 102: {
                            c2 = 12;
                            break;
                        }
                        case 110: {
                            c2 = 10;
                            break;
                        }
                        case 114: {
                            c2 = 13;
                            break;
                        }
                        case 116: {
                            c2 = 9;
                            break;
                        }
                        case 118: {
                            c2 = 11;
                            break;
                        }
                        case 117: {
                            int escapeStart = this.stringBufferTop;
                            this.addToString(117);
                            int escapeVal = 0;
                            for (int i3 = 0; i3 != 4; ++i3) {
                                c2 = this.in.read();
                                if ((escapeVal = escapeVal << 4 | TokenStream.xDigitToInt(c2)) < 0) continue block47;
                                this.addToString(c2);
                            }
                            this.stringBufferTop = escapeStart;
                            c2 = escapeVal;
                            break;
                        }
                        case 120: {
                            c2 = this.in.read();
                            int escapeVal = TokenStream.xDigitToInt(c2);
                            if (escapeVal < 0) {
                                this.addToString(120);
                                continue block47;
                            }
                            int c1 = c2;
                            c2 = this.in.read();
                            if ((escapeVal = escapeVal << 4 | TokenStream.xDigitToInt(c2)) < 0) {
                                this.addToString(120);
                                this.addToString(c1);
                                continue block47;
                            }
                            c2 = escapeVal;
                            break;
                        }
                        case 10: {
                            c2 = this.in.read();
                            continue block47;
                        }
                        default: {
                            if (48 > c2 || c2 >= 56) break;
                            val = c2 - 48;
                            c2 = this.in.read();
                            if (48 <= c2 && c2 < 56) {
                                val = 8 * val + c2 - 48;
                                c2 = this.in.read();
                                if (48 <= c2 && c2 < 56 && val <= 31) {
                                    val = 8 * val + c2 - 48;
                                    c2 = this.in.read();
                                }
                            }
                            this.in.unread();
                            c2 = val;
                        }
                    }
                }
                this.addToString(c2);
                c2 = this.in.read();
            }
            this.string = this.getStringFromBuffer();
            return 46;
        }
        switch (c2) {
            case 10: {
                return 1;
            }
            case 59: {
                return 89;
            }
            case 91: {
                return 90;
            }
            case 93: {
                return 91;
            }
            case 123: {
                return 92;
            }
            case 125: {
                return 93;
            }
            case 40: {
                return 94;
            }
            case 41: {
                return 95;
            }
            case 44: {
                return 96;
            }
            case 63: {
                return 98;
            }
            case 58: {
                return 99;
            }
            case 46: {
                return 108;
            }
            case 124: {
                if (this.in.match(124)) {
                    return 100;
                }
                if (this.in.match(61)) {
                    this.op = 11;
                    return 97;
                }
                return 11;
            }
            case 94: {
                if (this.in.match(61)) {
                    this.op = 12;
                    return 97;
                }
                return 12;
            }
            case 38: {
                if (this.in.match(38)) {
                    return 101;
                }
                if (this.in.match(61)) {
                    this.op = 13;
                    return 97;
                }
                return 13;
            }
            case 61: {
                if (this.in.match(61)) {
                    this.op = this.in.match(61) ? 53 : 14;
                    return 102;
                }
                this.op = 128;
                return 97;
            }
            case 33: {
                if (this.in.match(61)) {
                    this.op = this.in.match(61) ? 54 : 15;
                    return 102;
                }
                this.op = 129;
                return 105;
            }
            case 60: {
                if (this.in.match(33)) {
                    if (this.in.match(45)) {
                        if (this.in.match(45)) {
                            this.skipLine();
                            return 65535;
                        }
                        this.in.unread();
                    }
                    this.in.unread();
                }
                if (this.in.match(60)) {
                    if (this.in.match(61)) {
                        this.op = 20;
                        return 97;
                    }
                    this.op = 20;
                    return 104;
                }
                if (this.in.match(61)) {
                    this.op = 17;
                    return 103;
                }
                this.op = 16;
                return 103;
            }
            case 62: {
                if (this.in.match(62)) {
                    if (this.in.match(62)) {
                        if (this.in.match(61)) {
                            this.op = 22;
                            return 97;
                        }
                        this.op = 22;
                        return 104;
                    }
                    if (this.in.match(61)) {
                        this.op = 21;
                        return 97;
                    }
                    this.op = 21;
                    return 104;
                }
                if (this.in.match(61)) {
                    this.op = 19;
                    return 103;
                }
                this.op = 18;
                return 103;
            }
            case 42: {
                if (this.in.match(61)) {
                    this.op = 25;
                    return 97;
                }
                return 25;
            }
            case 47: {
                if (this.in.match(47)) {
                    this.stringBufferTop = 0;
                    while ((c2 = this.in.read()) != -1 && c2 != 10) {
                        this.addToString(c2);
                    }
                    this.addCommentToQueue(new Comment(this.getStringFromBuffer(), false));
                    return 65535;
                }
                if (this.in.match(42)) {
                    this.stringBufferTop = 0;
                    while (!((c2 = this.in.read()) == -1 || c2 == 42 && this.in.match(47))) {
                        this.addToString(c2);
                    }
                    if (c2 == -1) {
                        this.reportTokenError("msg.unterminated.comment", null);
                        return -1;
                    }
                    this.addCommentToQueue(new Comment(this.getStringFromBuffer(), true));
                    return 65535;
                }
                if ((this.flags & 0x10) != 0) {
                    this.stringBufferTop = 0;
                    while ((c2 = this.in.read()) != 47) {
                        if (c2 == 10 || c2 == -1) {
                            this.in.unread();
                            this.reportTokenError("msg.unterminated.re.lit", null);
                            return -1;
                        }
                        if (c2 == 92) {
                            this.addToString(c2);
                            c2 = this.in.read();
                        }
                        this.addToString(c2);
                    }
                    int reEnd = this.stringBufferTop;
                    while (true) {
                        if (this.in.match(103)) {
                            this.addToString(103);
                            continue;
                        }
                        if (this.in.match(105)) {
                            this.addToString(105);
                            continue;
                        }
                        if (!this.in.match(109)) break;
                        this.addToString(109);
                    }
                    if (TokenStream.isAlpha(this.in.peek())) {
                        this.reportTokenError("msg.invalid.re.flag", null);
                        return -1;
                    }
                    this.string = new String(this.stringBuffer, 0, reEnd);
                    this.regExpFlags = new String(this.stringBuffer, reEnd, this.stringBufferTop - reEnd);
                    return 56;
                }
                if (this.in.match(61)) {
                    this.op = 26;
                    return 97;
                }
                return 26;
            }
            case 37: {
                this.op = 27;
                if (this.in.match(61)) {
                    return 97;
                }
                return 27;
            }
            case 126: {
                this.op = 28;
                return 105;
            }
            case 43: {
                if (this.in.match(61)) {
                    this.op = 23;
                    return 97;
                }
                if (this.in.match(43)) {
                    return 106;
                }
                return 23;
            }
            case 45: {
                if (this.in.match(61)) {
                    this.op = 24;
                    c2 = 97;
                } else if (this.in.match(45)) {
                    if (0 == (this.flags & 0x20) && this.in.match(62)) {
                        this.skipLine();
                        return 65535;
                    }
                    c2 = 107;
                } else {
                    c2 = 24;
                }
                this.flags |= 0x20;
                return c2;
            }
        }
        this.reportTokenError("msg.illegal.character", null);
        return -1;
    }

    private void skipWhitespace() throws IOException {
        int tmp;
        while (TokenStream.isJSSpace(tmp = this.in.read()) || tmp == 10) {
        }
        this.in.unread();
    }

    private int jsniMatchReference() throws IOException {
        if (!this.jsniMatchQualifiedTypeName('.', ':')) {
            return -1;
        }
        int c2 = this.in.read();
        if (c2 != 58) {
            this.in.unread();
            this.reportTokenError("msg.jsni.expected.char", new String[]{":"});
            return -1;
        }
        this.addToString(c2);
        this.skipWhitespace();
        if (!this.jsniMatchMethodSignatureOrFieldName()) {
            return -1;
        }
        this.string = new String(this.stringBuffer, 0, this.stringBufferTop);
        return 44;
    }

    private boolean jsniMatchParamListSignature() throws IOException {
        this.skipWhitespace();
        if (this.in.peek() == 42) {
            this.addToString(this.in.read());
            if (this.in.peek() != 41) {
                this.reportTokenError("msg.jsni.expected.char", new String[]{")"});
            }
            this.addToString(this.in.read());
            return true;
        }
        do {
            this.skipWhitespace();
            int c2 = this.in.read();
            if (c2 == 41) {
                this.addToString(c2);
                return true;
            }
            this.in.unread();
        } while (this.jsniMatchParamTypeSignature());
        return false;
    }

    private boolean jsniMatchParamTypeSignature() throws IOException {
        int c2 = this.in.read();
        switch (c2) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                this.addToString(c2);
                return true;
            }
            case 76: {
                this.addToString(c2);
                return this.jsniMatchQualifiedTypeName('/', ';');
            }
            case 91: {
                this.addToString(c2);
                return this.jsniMatchParamArrayTypeSignature();
            }
        }
        this.in.unread();
        this.reportTokenError("msg.jsni.expected.param.type", null);
        return false;
    }

    private boolean jsniMatchParamArrayTypeSignature() throws IOException {
        return this.jsniMatchParamTypeSignature();
    }

    private boolean jsniMatchMethodSignatureOrFieldName() throws IOException {
        int c2 = this.in.read();
        if (!Character.isJavaIdentifierStart((char)c2)) {
            this.in.unread();
            this.reportTokenError("msg.jsni.expected.identifier", null);
            return false;
        }
        this.addToString(c2);
        while (Character.isJavaIdentifierPart((char)(c2 = this.in.read()))) {
            this.addToString(c2);
        }
        if (c2 == 40) {
            this.addToString(c2);
            return this.jsniMatchParamListSignature();
        }
        this.in.unread();
        return true;
    }

    private boolean jsniMatchQualifiedTypeName(char sepChar, char endChar) throws IOException {
        int c2 = this.in.read();
        if (!Character.isJavaIdentifierStart((char)c2)) {
            this.in.unread();
            this.reportTokenError("msg.jsni.expected.identifier", null);
            return false;
        }
        this.addToString(c2);
        while (Character.isJavaIdentifierPart((char)(c2 = this.in.read()))) {
            this.addToString(c2);
        }
        while (c2 == 91 && 93 == this.in.peek()) {
            this.addToString(91);
            this.addToString(this.in.read());
            c2 = this.in.read();
        }
        if (c2 == sepChar) {
            this.addToString(c2);
            return this.jsniMatchQualifiedTypeName(sepChar, endChar);
        }
        if (c2 == endChar) {
            this.addToString(c2);
            return true;
        }
        this.in.unread();
        return true;
    }

    private String getStringFromBuffer() {
        return new String(this.stringBuffer, 0, this.stringBufferTop);
    }

    private void addToString(int c2) {
        if (this.stringBufferTop == this.stringBuffer.length) {
            char[] tmp = new char[this.stringBuffer.length * 2];
            System.arraycopy(this.stringBuffer, 0, tmp, 0, this.stringBufferTop);
            this.stringBuffer = tmp;
        }
        this.stringBuffer[this.stringBufferTop++] = (char)c2;
    }

    public void reportSyntaxError(String messageProperty, Object[] args) {
        String message = Context.getMessage(messageProperty, args);
        Context.reportError(message, this.secondToLastPosition, this.lastPosition);
    }

    private void reportTokenError(String messageProperty, Object[] args) {
        String message = Context.getMessage(messageProperty, args);
        Context.reportError(message, this.lastPosition, new CodePosition(this.getLineno(), this.getOffset()));
    }

    private void reportTokenWarning(String messageProperty, Object[] args) {
        String message = Context.getMessage(messageProperty, args);
        Context.reportWarning(message, this.lastPosition, new CodePosition(this.getLineno(), this.getOffset()));
    }

    private void updatePosition() {
        CodePosition currentPosition = new CodePosition(this.getLineno(), this.getOffset());
        if (currentPosition.compareTo(this.lastPosition) > 0) {
            this.secondToLastPosition = this.lastPosition;
            this.lastPosition = currentPosition;
        }
    }

    private void addCommentToQueue(Comment comment) {
        if (this.headComment == null) {
            this.headComment = comment;
            this.lastComment = comment;
        } else {
            this.lastComment.setNext(comment);
            this.lastComment = comment;
        }
    }

    public int getLineno() {
        return this.in.getLineno();
    }

    public int getOp() {
        return this.op;
    }

    public String getString() {
        return this.string;
    }

    public double getNumber() {
        return this.number;
    }

    public int getOffset() {
        return this.in.getOffset();
    }

    public int getTokenno() {
        return this.tokenno;
    }

    public Comment getHeadComment() {
        return this.headComment;
    }

    public void releaseComments() {
        this.headComment = null;
        this.lastComment = null;
    }

    static {
        KEYWORDS.put("break", 121);
        KEYWORDS.put("case", 116);
        KEYWORDS.put("continue", 122);
        KEYWORDS.put("yield", 150);
        KEYWORDS.put("default", 117);
        KEYWORDS.put("delete", 31);
        KEYWORDS.put("do", 119);
        KEYWORDS.put("else", 114);
        KEYWORDS.put("export", 111);
        KEYWORDS.put("false", 13165);
        KEYWORDS.put("for", 120);
        KEYWORDS.put("function", 110);
        KEYWORDS.put("if", 113);
        KEYWORDS.put("in", 16231);
        KEYWORDS.put("new", 30);
        KEYWORDS.put("null", 12653);
        KEYWORDS.put("return", 5);
        KEYWORDS.put("switch", 115);
        KEYWORDS.put("this", 12909);
        KEYWORDS.put("true", 13421);
        KEYWORDS.put("typeof", 8297);
        KEYWORDS.put("var", 123);
        KEYWORDS.put("void", 33897);
        KEYWORDS.put("while", 118);
        KEYWORDS.put("with", 124);
        KEYWORDS.put("catch", 125);
        KEYWORDS.put("debugger", 146);
        KEYWORDS.put("finally", 126);
        KEYWORDS.put("import", 112);
        KEYWORDS.put("instanceof", 16487);
        KEYWORDS.put("throw", 62);
        KEYWORDS.put("try", 75);
    }
}

