/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ForwardingSortedMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public abstract class ForwardingSortedSet<E>
extends ForwardingSet<E>
implements SortedSet<E> {
    protected ForwardingSortedSet() {
    }

    @Override
    protected abstract SortedSet<E> delegate();

    @Override
    public Comparator<? super E> comparator() {
        return this.delegate().comparator();
    }

    @Override
    public E first() {
        return this.delegate().first();
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.delegate().headSet(toElement);
    }

    @Override
    public E last() {
        return this.delegate().last();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.delegate().subSet(fromElement, toElement);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.delegate().tailSet(fromElement);
    }

    @Override
    protected boolean standardContains(Object object) {
        try {
            ForwardingSortedSet self = this;
            Object ceiling = self.tailSet(object).first();
            return ForwardingSortedMap.unsafeCompare(this.comparator(), ceiling, object) == 0;
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException e2) {
            return false;
        }
    }

    @Override
    protected boolean standardRemove(Object object) {
        try {
            ForwardingSortedSet self = this;
            Iterator iterator2 = self.tailSet(object).iterator();
            if (iterator2.hasNext()) {
                Object ceiling = iterator2.next();
                if (ForwardingSortedMap.unsafeCompare(this.comparator(), ceiling, object) == 0) {
                    iterator2.remove();
                    return true;
                }
            }
        }
        catch (ClassCastException | NullPointerException e2) {
            return false;
        }
        return false;
    }

    protected SortedSet<E> standardSubSet(E fromElement, E toElement) {
        return this.tailSet(fromElement).headSet(toElement);
    }
}

