/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;

public interface Policy<K, V> {
    public boolean isRecordingStats();

    default public V getIfPresentQuietly(Object key) {
        throw new UnsupportedOperationException();
    }

    public Optional<Eviction<K, V>> eviction();

    public Optional<Expiration<K, V>> expireAfterAccess();

    public Optional<Expiration<K, V>> expireAfterWrite();

    default public Optional<VarExpiration<K, V>> expireVariably() {
        return Optional.empty();
    }

    public Optional<Expiration<K, V>> refreshAfterWrite();

    public static interface VarExpiration<K, V> {
        public OptionalLong getExpiresAfter(K var1, TimeUnit var2);

        default public Optional<Duration> getExpiresAfter(K key) {
            OptionalLong duration = this.getExpiresAfter(key, TimeUnit.NANOSECONDS);
            return duration.isPresent() ? Optional.of(Duration.ofNanos(duration.getAsLong())) : Optional.empty();
        }

        public void setExpiresAfter(K var1, long var2, TimeUnit var4);

        default public void setExpiresAfter(K key, Duration duration) {
            this.setExpiresAfter(key, duration.toNanos(), TimeUnit.NANOSECONDS);
        }

        default public boolean putIfAbsent(K key, V value2, long duration, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        default public boolean putIfAbsent(K key, V value2, Duration duration) {
            return this.putIfAbsent(key, value2, duration.toNanos(), TimeUnit.NANOSECONDS);
        }

        default public void put(K key, V value2, long duration, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        default public void put(K key, V value2, Duration duration) {
            this.put(key, value2, duration.toNanos(), TimeUnit.NANOSECONDS);
        }

        public Map<K, V> oldest(int var1);

        public Map<K, V> youngest(int var1);
    }

    public static interface Expiration<K, V> {
        public OptionalLong ageOf(K var1, TimeUnit var2);

        default public Optional<Duration> ageOf(K key) {
            OptionalLong duration = this.ageOf(key, TimeUnit.NANOSECONDS);
            return duration.isPresent() ? Optional.of(Duration.ofNanos(duration.getAsLong())) : Optional.empty();
        }

        public long getExpiresAfter(TimeUnit var1);

        default public Duration getExpiresAfter() {
            return Duration.ofNanos(this.getExpiresAfter(TimeUnit.NANOSECONDS));
        }

        public void setExpiresAfter(long var1, TimeUnit var3);

        default public void setExpiresAfter(Duration duration) {
            this.setExpiresAfter(duration.toNanos(), TimeUnit.NANOSECONDS);
        }

        public Map<K, V> oldest(int var1);

        public Map<K, V> youngest(int var1);
    }

    public static interface Eviction<K, V> {
        public boolean isWeighted();

        default public OptionalInt weightOf(K key) {
            return OptionalInt.empty();
        }

        public OptionalLong weightedSize();

        public long getMaximum();

        public void setMaximum(long var1);

        public Map<K, V> coldest(int var1);

        public Map<K, V> hottest(int var1);
    }
}

