/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;

@FunctionalInterface
public interface CacheLoader<K, V>
extends AsyncCacheLoader<K, V> {
    public V load(K var1) throws Exception;

    default public Map<K, V> loadAll(Iterable<? extends K> keys2) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    default public CompletableFuture<V> asyncLoad(K key, Executor executor) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(executor);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.load(key);
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new CompletionException(e3);
            }
        }, executor);
    }

    @Override
    default public CompletableFuture<Map<K, V>> asyncLoadAll(Iterable<? extends K> keys2, Executor executor) {
        Objects.requireNonNull(keys2);
        Objects.requireNonNull(executor);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.loadAll(keys2);
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new CompletionException(e3);
            }
        }, executor);
    }

    default public V reload(K key, V oldValue) throws Exception {
        return this.load(key);
    }

    @Override
    default public CompletableFuture<V> asyncReload(K key, V oldValue, Executor executor) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(executor);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.reload(key, oldValue);
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new CompletionException(e3);
            }
        }, executor);
    }
}

