/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine;

import com.github.benmanes.caffeine.SCQHeader;
import com.github.benmanes.caffeine.base.UnsafeAccess;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

@Deprecated
public final class SingleConsumerQueue<E>
extends SCQHeader.HeadAndTailRef<E>
implements Serializable,
Queue<E> {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final int ARENA_LENGTH = SingleConsumerQueue.ceilingPowerOfTwo((NCPU + 1) / 2);
    static final int ARENA_MASK = ARENA_LENGTH - 1;
    static final Function<?, ?> OPTIMISIC = Node::new;
    static final int SPINS = NCPU == 1 ? 0 : 2000;
    static final long PROBE = UnsafeAccess.objectFieldOffset(Thread.class, "threadLocalRandomProbe");
    final AtomicReference<Node<E>>[] arena = new AtomicReference[ARENA_LENGTH];
    final Function<E, Node<E>> factory;
    static final long serialVersionUID = 1L;

    static int ceilingPowerOfTwo(int x2) {
        return 1 << -Integer.numberOfLeadingZeros(x2 - 1);
    }

    private SingleConsumerQueue(Function<E, Node<E>> factory2) {
        for (int i2 = 0; i2 < ARENA_LENGTH; ++i2) {
            this.arena[i2] = new AtomicReference();
        }
        Node<Object> node = new Node<Object>(null);
        this.factory = factory2;
        this.lazySetTail(node);
        this.head = node;
    }

    public static <E> SingleConsumerQueue<E> optimistic() {
        Function<?, ?> factory2 = OPTIMISIC;
        return new SingleConsumerQueue(factory2);
    }

    public static <E> SingleConsumerQueue<E> linearizable() {
        return new SingleConsumerQueue<Object>(LinearizableNode::new);
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public int size() {
        int size;
        Node cursor = this.head;
        Node t2 = this.tail;
        for (size = 0; cursor != t2 && size != Integer.MAX_VALUE; ++size) {
            Node next = cursor.getNextRelaxed();
            if (next == null) {
                while ((next = cursor.next) == null) {
                }
            }
            cursor = next;
        }
        return size;
    }

    @Override
    public boolean contains(Object o2) {
        if (o2 == null) {
            return false;
        }
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!o2.equals(it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public E peek() {
        Node h2 = this.head;
        Node t2 = this.tail;
        if (h2 == t2) {
            return null;
        }
        Node next = h2.getNextRelaxed();
        if (next == null) {
            while ((next = h2.next) == null) {
            }
        }
        return next.value;
    }

    @Override
    public boolean offer(E e2) {
        Objects.requireNonNull(e2);
        Node<E> node = this.factory.apply(e2);
        this.append(node, node);
        return true;
    }

    @Override
    public E poll() {
        Node h2 = this.head;
        Node next = h2.getNextRelaxed();
        if (next == null) {
            if (h2 == this.tail) {
                return null;
            }
            while ((next = h2.next) == null) {
            }
        }
        Object e2 = next.value;
        next.value = null;
        this.head = next;
        if (this.factory == OPTIMISIC) {
            h2.next = null;
        }
        return e2;
    }

    @Override
    public boolean add(E e2) {
        return this.offer(e2);
    }

    @Override
    public boolean addAll(Collection<? extends E> c2) {
        Objects.requireNonNull(c2);
        Node<E> first2 = null;
        Node<E> last2 = null;
        for (E e2 : c2) {
            Objects.requireNonNull(e2);
            if (first2 == null) {
                last2 = first2 = this.factory.apply(e2);
                continue;
            }
            Node<E> newLast = new Node<E>(e2);
            last2.lazySetNext(newLast);
            last2 = newLast;
        }
        if (first2 == null) {
            return false;
        }
        this.append(first2, last2);
        return true;
    }

    void append(Node<E> first2, Node<E> last2) {
        while (true) {
            Node t2;
            if (this.casTail(t2 = this.tail, last2)) {
                t2.lazySetNext(first2);
                if (this.factory == OPTIMISIC) {
                    return;
                }
                while (true) {
                    first2.complete();
                    if (first2 == last2) {
                        return;
                    }
                    Node<E> next = first2.getNextRelaxed();
                    if (next == null) {
                        return;
                    }
                    if (next.value == null) {
                        first2.next = null;
                    }
                    first2 = next;
                }
            }
            Node<E> node = this.transferOrCombine(first2, last2);
            if (node == null) {
                first2.await();
                return;
            }
            if (node == first2) continue;
            last2 = node;
        }
    }

    Node<E> transferOrCombine(Node<E> first2, Node<E> last2) {
        Node<E> found;
        int index2 = SingleConsumerQueue.index();
        AtomicReference<Node<E>> slot = this.arena[index2];
        while (true) {
            if ((found = slot.get()) == null) {
                if (!slot.compareAndSet(null, first2)) continue;
                for (int spin = 0; spin < SPINS; ++spin) {
                    if (slot.get() == first2) continue;
                    return null;
                }
                return slot.compareAndSet(first2, null) ? first2 : null;
            }
            if (slot.compareAndSet(found, null)) break;
        }
        last2.lazySetNext(found);
        last2 = SingleConsumerQueue.findLast(found);
        for (int i2 = 1; i2 < ARENA_LENGTH; ++i2) {
            slot = this.arena[i2 + index2 & ARENA_MASK];
            found = slot.get();
            if (found == null || !slot.compareAndSet(found, null)) continue;
            last2.lazySetNext(found);
            last2 = SingleConsumerQueue.findLast(found);
        }
        return last2;
    }

    static int index() {
        int probe = UnsafeAccess.UNSAFE.getInt(Thread.currentThread(), PROBE);
        if (probe == 0) {
            ThreadLocalRandom.current();
            probe = UnsafeAccess.UNSAFE.getInt(Thread.currentThread(), PROBE);
        }
        return probe & ARENA_MASK;
    }

    static <E> Node<E> findLast(Node<E> node) {
        Node<E> next;
        while ((next = node.getNextRelaxed()) != null) {
            node = next;
        }
        return node;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Node<E> prev;
            Node<E> t;
            Node<E> cursor;
            boolean failOnRemoval;
            {
                this.t = SingleConsumerQueue.this.tail;
                this.cursor = SingleConsumerQueue.this.head;
                this.failOnRemoval = true;
            }

            @Override
            public boolean hasNext() {
                return this.cursor != this.t;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.advance();
                this.failOnRemoval = false;
                return this.cursor.value;
            }

            private void advance() {
                if (this.prev == null || !this.failOnRemoval) {
                    this.prev = this.cursor;
                }
                this.cursor = this.awaitNext();
            }

            @Override
            public void remove() {
                if (this.failOnRemoval) {
                    throw new IllegalStateException();
                }
                this.failOnRemoval = true;
                this.cursor.value = null;
                if (this.t == this.cursor) {
                    this.prev.lazySetNext(null);
                    if (SingleConsumerQueue.this.casTail(this.t, this.prev)) {
                        return;
                    }
                }
                this.prev.lazySetNext(this.awaitNext());
            }

            Node<E> awaitNext() {
                if (this.cursor.getNextRelaxed() == null) {
                    while (this.cursor.next == null) {
                    }
                }
                return this.cursor.getNextRelaxed();
            }
        };
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    static final class LinearizableNode<E>
    extends Node<E> {
        volatile boolean done;

        LinearizableNode(E value2) {
            super(value2);
        }

        @Override
        void complete() {
            this.done = true;
        }

        @Override
        void await() {
            while (!this.done) {
            }
        }

        @Override
        boolean isDone() {
            return this.done;
        }
    }

    static class Node<E> {
        static final long NEXT_OFFSET = UnsafeAccess.objectFieldOffset(Node.class, "next");
        E value;
        volatile Node<E> next;

        Node(E value2) {
            this.value = value2;
        }

        Node<E> getNextRelaxed() {
            return (Node)UnsafeAccess.UNSAFE.getObject(this, NEXT_OFFSET);
        }

        void lazySetNext(Node<E> newNext) {
            UnsafeAccess.UNSAFE.putOrderedObject(this, NEXT_OFFSET, newNext);
        }

        void complete() {
        }

        void await() {
        }

        boolean isDone() {
            return true;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.value + "]";
        }
    }

    static final class SerializationProxy<E>
    implements Serializable {
        final boolean linearizable;
        final List<E> elements;
        static final long serialVersionUID = 1L;

        SerializationProxy(SingleConsumerQueue<E> queue) {
            this.linearizable = queue.factory.apply(null) instanceof LinearizableNode;
            this.elements = new ArrayList<E>(queue);
        }

        Object readResolve() {
            SingleConsumerQueue<E> queue = this.linearizable ? SingleConsumerQueue.linearizable() : SingleConsumerQueue.optimistic();
            queue.addAll(this.elements);
            return queue;
        }
    }
}

