/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.impl.LocationImpl;
import com.fasterxml.aalto.in.CharBasedPNameTable;
import com.fasterxml.aalto.in.ElementScope;
import com.fasterxml.aalto.in.InputCharTypes;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.PNameC;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.util.DataUtil;
import com.fasterxml.aalto.util.XmlCharTypes;
import com.fasterxml.aalto.util.XmlChars;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamLocation2;

public final class ReaderScanner
extends XmlScanner {
    private static final XmlCharTypes sCharTypes = InputCharTypes.getLatin1CharTypes();
    protected Reader _in;
    protected char[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;
    protected int mTmpChar = 0;
    protected final CharBasedPNameTable _symbols;

    public ReaderScanner(ReaderConfig cfg, Reader r2) {
        super(cfg);
        this._in = r2;
        this._inputBuffer = cfg.allocFullCBuffer(4000);
        this._inputEnd = 0;
        this._inputPtr = 0;
        this._pastBytesOrChars = 0L;
        this._rowStartOffset = 0;
        this._symbols = cfg.getCBSymbols();
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        if (this._symbols.maybeDirty()) {
            this._config.updateCBSymbols(this._symbols);
        }
        if (this._in != null && this._inputBuffer != null) {
            this._config.freeFullCBuffer(this._inputBuffer);
            this._inputBuffer = null;
        }
    }

    @Override
    protected void _closeSource() throws IOException {
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
    }

    @Override
    protected final void finishToken() throws XMLStreamException {
        this._tokenIncomplete = false;
        switch (this._currToken) {
            case 3: {
                this.finishPI();
                break;
            }
            case 4: {
                this.finishCharacters();
                break;
            }
            case 5: {
                this.finishComment();
                break;
            }
            case 6: {
                this.finishSpace();
                break;
            }
            case 11: {
                this.finishDTD(true);
                break;
            }
            case 12: {
                this.finishCData();
                break;
            }
            default: {
                ErrorConsts.throwInternalError();
            }
        }
    }

    @Override
    public final int nextFromProlog(boolean isProlog) throws XMLStreamException {
        char c2;
        if (this._tokenIncomplete) {
            this.skipToken();
        }
        this.setStartLocation();
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.setStartLocation();
                return -1;
            }
            if ((c2 = this._inputBuffer[this._inputPtr++] & 0xFF) == '<') break;
            if (c2 == ' ') continue;
            if (c2 == '\n') {
                this.markLF();
                continue;
            }
            if (c2 == '\r') {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this.markLF();
                    this.setStartLocation();
                    return -1;
                }
                if (this._inputBuffer[this._inputPtr] == '\n') {
                    ++this._inputPtr;
                }
                this.markLF();
                continue;
            }
            if (c2 == '\t') continue;
            this.reportPrologUnexpChar(isProlog, c2, null);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed(5);
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) == '!') {
            return this.handlePrologDeclStart(isProlog);
        }
        if (c2 == '?') {
            return this.handlePIStart();
        }
        if (c2 == '/' || !isProlog) {
            this.reportPrologUnexpElement(isProlog, c2);
        }
        return this.handleStartElement(c2);
    }

    @Override
    public final int nextFromTree() throws XMLStreamException {
        if (this._tokenIncomplete) {
            if (this.skipToken()) {
                return this._nextEntity();
            }
        } else if (this._currToken == 1) {
            if (this._isEmptyTag) {
                --this._depth;
                this._currToken = 2;
                return 2;
            }
        } else if (this._currToken == 2) {
            this._currElem = this._currElem.getParent();
            while (this._lastNsDecl != null && this._lastNsDecl.getLevel() >= this._depth) {
                this._lastNsDecl = this._lastNsDecl.unbind();
            }
        } else if (this._entityPending) {
            this._entityPending = false;
            return this._nextEntity();
        }
        this.setStartLocation();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.setStartLocation();
            return -1;
        }
        char c2 = this._inputBuffer[this._inputPtr];
        if (c2 == '<') {
            ++this._inputPtr;
            c2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne(5);
            if (c2 == '!') {
                return this.handleCommentOrCdataStart();
            }
            if (c2 == '?') {
                return this.handlePIStart();
            }
            if (c2 == '/') {
                return this.handleEndElement();
            }
            return this.handleStartElement(c2);
        }
        if (c2 == '&') {
            ++this._inputPtr;
            int i2 = this.handleEntityInText(false);
            if (i2 == 0) {
                this._currToken = 9;
                return 9;
            }
            this.mTmpChar = -i2;
        } else {
            this.mTmpChar = c2;
        }
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
        } else {
            this.finishCharacters();
        }
        this._currToken = 4;
        return 4;
    }

    protected int _nextEntity() {
        this._textBuilder.resetWithEmpty();
        this._currToken = 9;
        return 9;
    }

    protected final int handlePrologDeclStart(boolean isProlog) throws XMLStreamException {
        char c2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) == '-') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) == '-') {
                if (this._cfgLazyParsing) {
                    this._tokenIncomplete = true;
                } else {
                    this.finishComment();
                }
                this._currToken = 5;
                return 5;
            }
        } else if (c2 == 'D' && isProlog) {
            this.handleDtdStart();
            if (!this._cfgLazyParsing && this._tokenIncomplete) {
                this.finishDTD(true);
                this._tokenIncomplete = false;
            }
            return 11;
        }
        this._tokenIncomplete = true;
        this._currToken = 4;
        this.reportPrologUnexpChar(isProlog, c2, " (expected '-' for COMMENT)");
        return this._currToken;
    }

    private final int handleDtdStart() throws XMLStreamException {
        this.matchAsciiKeyword("DOCTYPE");
        char c2 = this.skipInternalWs(true, "after DOCTYPE keyword, before root name");
        this._tokenName = this.parsePName(c2);
        c2 = this.skipInternalWs(false, null);
        if (c2 == 'P') {
            this.matchAsciiKeyword("PUBLIC");
            c2 = this.skipInternalWs(true, null);
            this._publicId = this.parsePublicId(c2);
            c2 = this.skipInternalWs(true, null);
            this._systemId = this.parseSystemId(c2);
            c2 = this.skipInternalWs(false, null);
        } else if (c2 == 'S') {
            this.matchAsciiKeyword("SYSTEM");
            c2 = this.skipInternalWs(true, null);
            this._publicId = null;
            this._systemId = this.parseSystemId(c2);
            c2 = this.skipInternalWs(false, null);
        } else {
            this._systemId = null;
            this._publicId = null;
        }
        if (c2 == '>') {
            this._tokenIncomplete = false;
            this._currToken = 11;
            return 11;
        }
        if (c2 != '[') {
            String msg = this._systemId != null ? " (expected '[' for the internal subset, or '>' to end DOCTYPE declaration)" : " (expected a 'PUBLIC' or 'SYSTEM' keyword, '[' for the internal subset, or '>' to end DOCTYPE declaration)";
            this.reportTreeUnexpChar(c2, msg);
        }
        this._tokenIncomplete = true;
        this._currToken = 11;
        return 11;
    }

    protected final int handleCommentOrCdataStart() throws XMLStreamException {
        char c2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) == '-') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) != '-') {
                this.reportTreeUnexpChar(c2, " (expected '-' for COMMENT)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishComment();
            }
            this._currToken = 5;
            return 5;
        }
        if (c2 == '[') {
            this._currToken = 12;
            for (int i2 = 0; i2 < 6; ++i2) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) == "CDATA[".charAt(i2)) continue;
                this.reportTreeUnexpChar(c2, " (expected '" + "CDATA[".charAt(i2) + "' for CDATA section)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishCData();
            }
            return 12;
        }
        this.reportTreeUnexpChar(c2, " (expected either '-' for COMMENT or '[CDATA[' for CDATA section)");
        return -1;
    }

    protected final int handlePIStart() throws XMLStreamException {
        this._currToken = 3;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        char c2 = this._inputBuffer[this._inputPtr++];
        this._tokenName = this.parsePName(c2);
        String ln = this._tokenName.getLocalName();
        if (ln.length() == 3 && ln.equalsIgnoreCase("xml") && this._tokenName.getPrefix() == null) {
            this.reportInputProblem(ErrorConsts.ERR_WF_PI_XML_TARGET);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) <= ' ') {
            while (true) {
                if (c2 == '\n') {
                    this.markLF();
                } else if (c2 == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                } else if (c2 != ' ' && c2 != '\t') {
                    this.throwInvalidSpace(c2);
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = this._inputBuffer[this._inputPtr]) > ' ') break;
                ++this._inputPtr;
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishPI();
            }
        } else {
            if (c2 != '?') {
                this.reportMissingPISpace(c2);
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) != '>') {
                this.reportMissingPISpace(c2);
            }
            this._textBuilder.resetWithEmpty();
            this._tokenIncomplete = false;
        }
        return 3;
    }

    protected final int handleCharEntity() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        char c2 = this._inputBuffer[this._inputPtr++];
        int value2 = 0;
        if (c2 == 'x') {
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) != ';') {
                    value2 <<= 4;
                    if (c2 <= '9' && c2 >= '0') {
                        value2 += c2 - 48;
                    } else if (c2 >= 'a' && c2 <= 'f') {
                        value2 += 10 + (c2 - 97);
                    } else if (c2 >= 'A' && c2 <= 'F') {
                        value2 += 10 + (c2 - 65);
                    } else {
                        this.throwUnexpectedChar(c2, "; expected a hex digit (0-9a-fA-F)");
                    }
                    if (value2 <= 0x10FFFF) continue;
                    this.reportEntityOverflow();
                    continue;
                }
                break;
            }
        } else {
            while (c2 != ';') {
                if (c2 <= '9' && c2 >= '0') {
                    if ((value2 = value2 * 10 + (c2 - 48)) > 0x10FFFF) {
                        this.reportEntityOverflow();
                    }
                } else {
                    this.throwUnexpectedChar(c2, "; expected a decimal number");
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                c2 = this._inputBuffer[this._inputPtr++];
            }
        }
        if (value2 >= 55296) {
            if (value2 < 57344) {
                this.reportInvalidXmlChar(value2);
            }
            if (value2 == 65534 || value2 == 65535) {
                this.reportInvalidXmlChar(value2);
            }
        } else if (!(value2 >= 32 || value2 == 10 || value2 == 13 || value2 == 9 || this._xml11 && value2 != 0)) {
            this.reportInvalidXmlChar(value2);
        }
        return value2;
    }

    protected final int handleStartElement(char c2) throws XMLStreamException {
        boolean allBound;
        this._currToken = 1;
        this._currNsCount = 0;
        PName elemName = this.parsePName(c2);
        String prefix = elemName.getPrefix();
        if (prefix == null) {
            allBound = true;
        } else {
            elemName = this.bindName(elemName, prefix);
            allBound = elemName.isBound();
        }
        this._tokenName = elemName;
        this._currElem = new ElementScope(elemName, this._currElem);
        int attrPtr = 0;
        while (true) {
            boolean isNsDecl;
            PName attrName;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) <= ' ') {
                do {
                    if (c2 == '\n') {
                        this.markLF();
                    } else if (c2 == '\r') {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                    } else if (c2 != ' ' && c2 != '\t') {
                        this.throwInvalidSpace(c2);
                    }
                    if (this._inputPtr < this._inputEnd) continue;
                    this.loadMoreGuaranteed();
                } while ((c2 = this._inputBuffer[this._inputPtr++]) <= ' ');
            } else if (c2 != '/' && c2 != '>') {
                this.throwUnexpectedChar(c2, " expected space, or '>' or \"/>\"");
            }
            if (c2 == '/') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) != '>') {
                    this.throwUnexpectedChar(c2, " expected '>'");
                }
                this._isEmptyTag = true;
                break;
            }
            if (c2 == '>') {
                this._isEmptyTag = false;
                break;
            }
            if (c2 == '<') {
                this.reportInputProblem("Unexpected '<' character in element (missing closing '>'?)");
            }
            if ((prefix = (attrName = this.parsePName(c2)).getPrefix()) == null) {
                isNsDecl = attrName.getLocalName() == "xmlns";
            } else if (prefix == "xmlns") {
                isNsDecl = true;
            } else {
                attrName = this.bindName(attrName, prefix);
                if (allBound) {
                    allBound = attrName.isBound();
                }
                isNsDecl = false;
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') break;
                if (c2 == '\n') {
                    this.markLF();
                    continue;
                }
                if (c2 == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c2 == ' ' || c2 == '\t') continue;
                this.throwInvalidSpace(c2);
            }
            if (c2 != '=') {
                this.throwUnexpectedChar(c2, " expected '='");
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') break;
                if (c2 == '\n') {
                    this.markLF();
                    continue;
                }
                if (c2 == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c2 == ' ' || c2 == '\t') continue;
                this.throwInvalidSpace(c2);
            }
            if (c2 != '\"' && c2 != '\'') {
                this.throwUnexpectedChar(c2, " Expected a quote");
            }
            if (isNsDecl) {
                this.handleNsDeclaration(attrName, c2);
                ++this._currNsCount;
                continue;
            }
            attrPtr = this.collectValue(attrPtr, c2, attrName);
        }
        int act = this._attrCollector.finishLastValue(attrPtr);
        if (act < 0) {
            act = this._attrCollector.getCount();
            this.reportInputProblem(this._attrCollector.getErrorMsg());
        }
        this._attrCount = act;
        ++this._depth;
        if (!allBound) {
            if (!elemName.isBound()) {
                this.reportUnboundPrefix(this._tokenName, false);
            }
            int len = this._attrCount;
            for (int i2 = 0; i2 < len; ++i2) {
                PName attrName = this._attrCollector.getName(i2);
                if (attrName.isBound()) continue;
                this.reportUnboundPrefix(attrName, true);
            }
        }
        return 1;
    }

    private int collectValue(int attrPtr, char quoteChar, PName attrName) throws XMLStreamException {
        char[] attrBuffer = this._attrCollector.startNewValue(attrName, attrPtr);
        int[] TYPES = ReaderScanner.sCharTypes.ATTR_CHARS;
        block9: while (true) {
            int c2;
            block31: {
                int d2;
                block30: {
                    block29: {
                        int max;
                        int max2;
                        int ptr;
                        if ((ptr = this._inputPtr) >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        if (attrPtr >= attrBuffer.length) {
                            attrBuffer = this._attrCollector.valueBufferFull();
                        }
                        if ((max2 = ptr + (attrBuffer.length - attrPtr)) < (max = this._inputEnd)) {
                            max = max2;
                        }
                        while (ptr < max) {
                            if ((c2 = this._inputBuffer[ptr++]) <= 255) {
                                if (TYPES[c2] != 0) {
                                    this._inputPtr = ptr;
                                    break block29;
                                }
                            } else if (c2 >= 55296) {
                                this._inputPtr = ptr;
                                break block29;
                            }
                            attrBuffer[attrPtr++] = c2;
                        }
                        this._inputPtr = ptr;
                        continue;
                    }
                    if (c2 > 255) break block30;
                    switch (TYPES[c2]) {
                        case 1: {
                            c2 = this.handleInvalidXmlChar(c2);
                        }
                        case 2: {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if (this._inputBuffer[this._inputPtr] == '\n') {
                                ++this._inputPtr;
                            }
                        }
                        case 3: {
                            this.markLF();
                        }
                        case 8: {
                            c2 = 32;
                            break;
                        }
                        case 9: {
                            this.throwUnexpectedChar(c2, "'<' not allowed in attribute value");
                        }
                        case 10: {
                            if (!this._config.willRetainAttributeGeneralEntities()) {
                                d2 = this.handleEntityInText(false);
                                if (d2 == 0) {
                                    this.reportUnexpandedEntityInAttr(attrName, false);
                                }
                                if (d2 >> 16 != 0) {
                                    attrBuffer[attrPtr++] = (char)(0xD800 | (d2 -= 65536) >> 10);
                                    d2 = 0xDC00 | d2 & 0x3FF;
                                    if (attrPtr >= attrBuffer.length) {
                                        attrBuffer = this._attrCollector.valueBufferFull();
                                    }
                                }
                                c2 = (char)d2;
                                break;
                            }
                            break block31;
                        }
                        case 14: {
                            if (c2 == quoteChar) break block9;
                        }
                    }
                    break block31;
                }
                if (c2 >= 55296) {
                    if (c2 < 57344) {
                        d2 = this.checkSurrogate((char)c2);
                        attrBuffer[attrPtr++] = c2;
                        if (attrPtr >= attrBuffer.length) {
                            attrBuffer = this._attrCollector.valueBufferFull();
                        }
                        c2 = d2;
                    } else if (c2 >= 65534) {
                        c2 = this.handleInvalidXmlChar(c2);
                    }
                }
            }
            attrBuffer[attrPtr++] = c2;
        }
        return attrPtr;
    }

    private void handleNsDeclaration(PName name, char quoteChar) throws XMLStreamException {
        int attrPtr = 0;
        char[] attrBuffer = this._nameBuffer;
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) == quoteChar) break;
            if (c2 == '&') {
                int d2 = this.handleEntityInText(false);
                if (d2 == 0) {
                    this.reportUnexpandedEntityInAttr(name, true);
                }
                if (d2 >> 16 != 0) {
                    if (attrPtr >= attrBuffer.length) {
                        this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
                    }
                    attrBuffer[attrPtr++] = (char)(0xD800 | (d2 -= 65536) >> 10);
                    d2 = 0xDC00 | d2 & 0x3FF;
                }
                c2 = (char)d2;
            } else if (c2 == '<') {
                this.throwUnexpectedChar(c2, "'<' not allowed in attribute value");
            } else if (c2 < ' ') {
                if (c2 == '\n') {
                    this.markLF();
                } else if (c2 == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c2 = '\n';
                } else if (c2 != '\t') {
                    this.throwInvalidSpace(c2);
                }
            }
            if (attrPtr >= attrBuffer.length) {
                this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
            }
            attrBuffer[attrPtr++] = c2;
        }
        if (attrPtr == 0) {
            this.bindNs(name, "");
        } else {
            String uri = this._config.canonicalizeURI(attrBuffer, attrPtr);
            this.bindNs(name, uri);
        }
    }

    protected final int handleEndElement() throws XMLStreamException {
        char c2;
        --this._depth;
        this._currToken = 2;
        this._tokenName = this._currElem.getName();
        String pname = this._tokenName.getPrefixedName();
        int i2 = 0;
        int len = pname.length();
        do {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) == pname.charAt(i2)) continue;
            this.reportUnexpectedEndTag(pname);
        } while (++i2 < len);
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) <= ' ') {
            c2 = this.skipInternalWs(false, null);
        } else if (c2 != '>' && (c2 == ':' || XmlChars.is10NameChar(c2))) {
            this.reportUnexpectedEndTag(pname);
        }
        if (c2 != '>') {
            this.throwUnexpectedChar(c2, " expected space or closing '>'");
        }
        return 2;
    }

    protected final int handleEntityInText(boolean inAttr) throws XMLStreamException {
        int cix;
        String start;
        char c2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) == '#') {
            return this.handleCharEntity();
        }
        if (c2 == 'a') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) == 'm') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) == 'p') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c2 = this._inputBuffer[this._inputPtr++]) == ';') {
                        return 38;
                    }
                    start = "amp";
                } else {
                    start = "am";
                }
            } else if (c2 == 'p') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) == 'o') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c2 = this._inputBuffer[this._inputPtr++]) == 's') {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((c2 = this._inputBuffer[this._inputPtr++]) == ';') {
                            return 39;
                        }
                        start = "apos";
                    } else {
                        start = "apo";
                    }
                } else {
                    start = "ap";
                }
            } else {
                start = "a";
            }
        } else if (c2 == 'l') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) == 't') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) == ';') {
                    return 60;
                }
                start = "lt";
            } else {
                start = "l";
            }
        } else if (c2 == 'g') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) == 't') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) == ';') {
                    return 62;
                }
                start = "gt";
            } else {
                start = "g";
            }
        } else if (c2 == 'q') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) == 'u') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) == 'o') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c2 = this._inputBuffer[this._inputPtr++]) == 't') {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((c2 = this._inputBuffer[this._inputPtr++]) == ';') {
                            return 34;
                        }
                        start = "quot";
                    } else {
                        start = "quo";
                    }
                } else {
                    start = "qu";
                }
            } else {
                start = "q";
            }
        } else {
            start = "";
        }
        int[] TYPES = ReaderScanner.sCharTypes.NAME_CHARS;
        char[] cbuf = this._nameBuffer;
        int len = start.length();
        for (cix = 0; cix < len; ++cix) {
            cbuf[cix] = start.charAt(cix);
        }
        while (c2 != ';') {
            boolean ok;
            if (c2 <= '\u00ff') {
                switch (TYPES[c2]) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ok = cix > 0;
                        break;
                    }
                    case 3: {
                        ok = true;
                        break;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
            } else if (c2 < '\ue000') {
                int value2 = this.decodeSurrogate(c2);
                if (cix >= cbuf.length) {
                    this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
                }
                cbuf[cix++] = c2;
                c2 = this._inputBuffer[this._inputPtr - 1];
                ok = XmlChars.is10NameChar(value2);
            } else if (c2 >= '\ufffe') {
                c2 = this.handleInvalidXmlChar(c2);
                ok = false;
            } else {
                ok = true;
            }
            if (!ok) {
                this.reportInvalidNameChar(c2, cix);
            }
            if (cix >= cbuf.length) {
                this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
            }
            cbuf[cix++] = c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            c2 = this._inputBuffer[this._inputPtr++];
        }
        String pname = new String(cbuf, 0, cix);
        this._tokenName = new PNameC(pname, null, pname, 0);
        if (this._config.willExpandEntities()) {
            this.reportInputProblem("General entity reference (&" + pname + ";) encountered in entity expanding mode: operation not (yet) implemented");
        }
        if (inAttr) {
            this.reportInputProblem("General entity reference (&" + pname + ";) encountered in attribute value, in non-entity-expanding mode: no way to handle it");
        }
        return 0;
    }

    @Override
    protected final void finishComment() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.resetWithEmpty();
        int outPtr = 0;
        block6: while (true) {
            int c2;
            block27: {
                int max;
                int max2;
                int ptr;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c2 = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c2] != 0) {
                            this._inputPtr = ptr;
                            break block27;
                        }
                    } else if (c2 >= 55296) {
                        this._inputPtr = ptr;
                        break block27;
                    }
                    outputBuffer[outPtr++] = c2;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c2 <= 255) {
                switch (TYPES[c2]) {
                    case 1: {
                        c2 = this.handleInvalidXmlChar(c2);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 13: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '-') {
                            ++this._inputPtr;
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if (this._inputBuffer[this._inputPtr++] == '>') break block6;
                            this.reportDoubleHyphenInComments();
                            break block6;
                        } else {
                            break;
                        }
                    }
                }
            } else if (c2 >= 55296) {
                if (c2 < 57344) {
                    char d2 = this.checkSurrogate((char)c2);
                    outputBuffer[outPtr++] = c2;
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c2 = d2;
                } else if (c2 >= 65534) {
                    c2 = this.handleInvalidXmlChar(c2);
                }
            }
            outputBuffer[outPtr++] = c2;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected final void finishPI() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.resetWithEmpty();
        int outPtr = 0;
        block5: while (true) {
            int c2;
            block25: {
                int max;
                int max2;
                int ptr;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c2 = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c2] != 0) {
                            this._inputPtr = ptr;
                            break block25;
                        }
                    } else if (c2 >= 55296) {
                        this._inputPtr = ptr;
                        break block25;
                    }
                    outputBuffer[outPtr++] = c2;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c2 <= 255) {
                switch (TYPES[c2]) {
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 12: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '>') {
                            ++this._inputPtr;
                            break block5;
                        } else {
                            break;
                        }
                    }
                }
            } else if (c2 >= 55296) {
                if (c2 < 57344) {
                    char d2 = this.checkSurrogate((char)c2);
                    outputBuffer[outPtr++] = c2;
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c2 = d2;
                } else if (c2 >= 65534) {
                    c2 = this.handleInvalidXmlChar(c2);
                }
            }
            outputBuffer[outPtr++] = c2;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected final void finishDTD(boolean copyContents) throws XMLStreamException {
        int c2;
        char[] outputBuffer = copyContents ? this._textBuilder.resetWithEmpty() : null;
        int outPtr = 0;
        int[] TYPES = ReaderScanner.sCharTypes.DTD_CHARS;
        boolean inDecl = false;
        int quoteChar = 0;
        block9: while (true) {
            block35: {
                block34: {
                    block33: {
                        int ptr;
                        if ((ptr = this._inputPtr) >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        int max = this._inputEnd;
                        if (outputBuffer != null) {
                            int max2;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            if ((max2 = ptr + (outputBuffer.length - outPtr)) < max) {
                                max = max2;
                            }
                        }
                        while (ptr < max) {
                            if ((c2 = this._inputBuffer[ptr++]) <= 255) {
                                if (TYPES[c2] != 0) {
                                    this._inputPtr = ptr;
                                    break block33;
                                }
                            } else if (c2 >= 55296) {
                                this._inputPtr = ptr;
                                break block33;
                            }
                            if (outputBuffer == null) continue;
                            outputBuffer[outPtr++] = c2;
                        }
                        this._inputPtr = ptr;
                        continue;
                    }
                    if (c2 > 255) break block34;
                    switch (TYPES[c2]) {
                        case 1: {
                            c2 = this.handleInvalidXmlChar(c2);
                        }
                        case 2: {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if (this._inputBuffer[this._inputPtr] == '\n') {
                                ++this._inputPtr;
                            }
                            this.markLF();
                            c2 = 10;
                            break;
                        }
                        case 3: {
                            this.markLF();
                            break;
                        }
                        case 8: {
                            if (quoteChar == 0) {
                                quoteChar = c2;
                                break;
                            }
                            if (quoteChar == c2) {
                                quoteChar = 0;
                                break;
                            }
                            break block35;
                        }
                        case 9: {
                            if (!inDecl) {
                                inDecl = true;
                                break;
                            }
                            break block35;
                        }
                        case 10: {
                            if (quoteChar == 0) {
                                inDecl = false;
                                break;
                            }
                            break block35;
                        }
                        case 11: {
                            if (!inDecl && quoteChar == 0) break block9;
                        }
                    }
                    break block35;
                }
                if (c2 >= 55296) {
                    if (c2 < 57344) {
                        int d2 = this.checkSurrogate((char)c2);
                        if (outputBuffer != null) {
                            outputBuffer[outPtr++] = c2;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                        }
                        c2 = d2;
                    } else if (c2 >= 65534) {
                        c2 = this.handleInvalidXmlChar(c2);
                    }
                }
            }
            if (outputBuffer == null) continue;
            outputBuffer[outPtr++] = c2;
        }
        if (outputBuffer != null) {
            this._textBuilder.setCurrentLength(outPtr);
        }
        if ((c2 = this.skipInternalWs(false, null)) != 62) {
            this.throwUnexpectedChar(c2, " expected '>' after the internal subset");
        }
    }

    @Override
    protected final void finishCData() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.resetWithEmpty();
        int outPtr = 0;
        block6: while (true) {
            int c2;
            block31: {
                int max;
                int max2;
                int ptr;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c2 = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c2] != 0) {
                            this._inputPtr = ptr;
                            break block31;
                        }
                    } else if (c2 >= 55296) {
                        this._inputPtr = ptr;
                        break block31;
                    }
                    outputBuffer[outPtr++] = c2;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c2 <= 255) {
                switch (TYPES[c2]) {
                    case 1: {
                        c2 = this.handleInvalidXmlChar(c2);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 11: {
                        boolean ok;
                        char d2;
                        int count2 = 0;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((d2 = this._inputBuffer[this._inputPtr]) != ']') break;
                            ++this._inputPtr;
                            ++count2;
                        }
                        boolean bl = ok = d2 == '>' && count2 >= 1;
                        if (ok) {
                            --count2;
                        }
                        while (count2 > 0) {
                            outputBuffer[outPtr++] = 93;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            --count2;
                        }
                        if (ok) {
                            ++this._inputPtr;
                            break block6;
                        } else {
                            break;
                        }
                    }
                }
            } else if (c2 >= 55296) {
                if (c2 < 57344) {
                    char d3 = this.checkSurrogate((char)c2);
                    outputBuffer[outPtr++] = c2;
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c2 = d3;
                } else if (c2 >= 65534) {
                    c2 = this.handleInvalidXmlChar(c2);
                }
            }
            outputBuffer[outPtr++] = c2;
        }
        this._textBuilder.setCurrentLength(outPtr);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    @Override
    protected final void finishCharacters() throws XMLStreamException {
        int outPtr;
        char[] outputBuffer;
        int c2 = this.mTmpChar;
        if (c2 < 0) {
            c2 = -c2;
            outputBuffer = this._textBuilder.resetWithEmpty();
            outPtr = 0;
            if (c2 >> 16 != 0) {
                outputBuffer[outPtr++] = (char)(0xD800 | (c2 -= 65536) >> 10);
                c2 = 0xDC00 | c2 & 0x3FF;
            }
            outputBuffer[outPtr++] = (char)c2;
        } else if (c2 == 13 || c2 == 10) {
            ++this._inputPtr;
            outPtr = this.checkInTreeIndentation((char)c2);
            if (outPtr < 0) {
                return;
            }
            outputBuffer = this._textBuilder.getBufferWithoutReset();
        } else {
            outputBuffer = this._textBuilder.resetWithEmpty();
            outPtr = 0;
        }
        int[] TYPES = ReaderScanner.sCharTypes.TEXT_CHARS;
        char[] inputBuffer = this._inputBuffer;
        block8: while (true) {
            int d2;
            int c3;
            int ptr;
            block41: {
                int max;
                int max2;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c3 = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c3] != 0) {
                            this._inputPtr = ptr;
                            break block41;
                        }
                    } else if (c3 >= 55296) {
                        this._inputPtr = ptr;
                        break block41;
                    }
                    outputBuffer[outPtr++] = c3;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c3 <= 255) {
                switch (TYPES[c3]) {
                    case 1: {
                        c3 = this.handleInvalidXmlChar(c3);
                    }
                    case 2: {
                        ptr = this._inputPtr;
                        if (ptr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        if (inputBuffer[ptr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c3 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 9: {
                        --this._inputPtr;
                        break block8;
                    }
                    case 10: {
                        d2 = this.handleEntityInText(false);
                        if (d2 == 0) {
                            this._entityPending = true;
                            break block8;
                        }
                        if (d2 >> 16 != 0) {
                            outputBuffer[outPtr++] = (char)(0xD800 | (d2 -= 65536) >> 10);
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            d2 = 0xDC00 | d2 & 0x3FF;
                        }
                        c3 = (char)d2;
                        break;
                    }
                    case 11: {
                        int count2 = 1;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((c3 = inputBuffer[this._inputPtr]) != 93) break;
                            ++this._inputPtr;
                            ++count2;
                        }
                        if (c3 == 62 && count2 > 1) {
                            this.reportIllegalCDataEnd();
                        }
                        while (count2 > 1) {
                            outputBuffer[outPtr++] = 93;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            --count2;
                        }
                        c3 = 93;
                    }
                }
            } else if (c3 >= 55296) {
                if (c3 < 57344) {
                    d2 = this.checkSurrogate((char)c3);
                    outputBuffer[outPtr++] = c3;
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c3 = d2;
                } else if (c3 >= 65534) {
                    c3 = this.handleInvalidXmlChar(c3);
                }
            }
            outputBuffer[outPtr++] = c3;
        }
        this._textBuilder.setCurrentLength(outPtr);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    @Override
    protected final void finishSpace() throws XMLStreamException {
        char[] outputBuffer;
        int outPtr;
        char tmp = (char)this.mTmpChar;
        if (tmp == '\r' || tmp == '\n') {
            outPtr = this.checkPrologIndentation(tmp);
            if (outPtr < 0) {
                return;
            }
            outputBuffer = this._textBuilder.getBufferWithoutReset();
        } else {
            outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = tmp;
            outPtr = 1;
        }
        int ptr = this._inputPtr;
        while (true) {
            int c2;
            if (ptr >= this._inputEnd) {
                if (!this.loadMore()) break;
                ptr = this._inputPtr;
            }
            if ((c2 = this._inputBuffer[ptr]) > 32) break;
            ++ptr;
            if (c2 == 10) {
                this.markLF(ptr);
            } else if (c2 == 13) {
                if (ptr >= this._inputEnd) {
                    if (!this.loadMore()) {
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        outputBuffer[outPtr++] = 10;
                        break;
                    }
                    ptr = this._inputPtr;
                }
                if (this._inputBuffer[ptr] == '\n') {
                    ++ptr;
                }
                this.markLF(ptr);
                c2 = 10;
            } else if (c2 != 32 && c2 != 9) {
                this._inputPtr = ptr;
                this.throwInvalidSpace(c2);
            }
            if (outPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outPtr = 0;
            }
            outputBuffer[outPtr++] = c2;
        }
        this._inputPtr = ptr;
        this._textBuilder.setCurrentLength(outPtr);
    }

    protected final void finishCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return;
            }
            if (this._inputBuffer[this._inputPtr] == '<') {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain(3)) {
                    return;
                }
                if (this._inputBuffer[this._inputPtr + 1] != '!' || this._inputBuffer[this._inputPtr + 2] != '[') {
                    return;
                }
                this._inputPtr += 3;
                for (int i2 = 0; i2 < 6; ++i2) {
                    char c2;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c2 = this._inputBuffer[this._inputPtr++]) == "CDATA[".charAt(i2)) continue;
                    this.reportTreeUnexpChar(c2, " (expected '" + "CDATA[".charAt(i2) + "' for CDATA section)");
                }
                this.finishCoalescedCData();
                continue;
            }
            this.finishCoalescedCharacters();
            if (this._entityPending) break;
        }
    }

    protected final void finishCoalescedCData() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.getBufferWithoutReset();
        int outPtr = this._textBuilder.getCurrentLength();
        block6: while (true) {
            int c2;
            block30: {
                int max;
                int max2;
                int ptr;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c2 = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c2] != 0) {
                            this._inputPtr = ptr;
                            break block30;
                        }
                    } else if (c2 >= 55296) {
                        this._inputPtr = ptr;
                        break block30;
                    }
                    outputBuffer[outPtr++] = c2;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c2 <= 255) {
                switch (TYPES[c2]) {
                    case 1: {
                        c2 = this.handleInvalidXmlChar(c2);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 11: {
                        boolean ok;
                        char d2;
                        int count2 = 0;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((d2 = this._inputBuffer[this._inputPtr]) != ']') break;
                            ++this._inputPtr;
                            ++count2;
                        }
                        boolean bl = ok = d2 == '>' && count2 >= 1;
                        if (ok) {
                            --count2;
                        }
                        while (count2 > 0) {
                            outputBuffer[outPtr++] = 93;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            --count2;
                        }
                        if (ok) {
                            ++this._inputPtr;
                            break block6;
                        } else {
                            break;
                        }
                    }
                }
            } else if (c2 >= 55296) {
                if (c2 < 57344) {
                    char d3 = this.checkSurrogate((char)c2);
                    outputBuffer[outPtr++] = c2;
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c2 = d3;
                } else if (c2 >= 65534) {
                    c2 = this.handleInvalidXmlChar(c2);
                }
            }
            outputBuffer[outPtr++] = c2;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    protected final void finishCoalescedCharacters() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.TEXT_CHARS;
        char[] inputBuffer = this._inputBuffer;
        char[] outputBuffer = this._textBuilder.getBufferWithoutReset();
        int outPtr = this._textBuilder.getCurrentLength();
        block8: while (true) {
            int d2;
            int c2;
            int ptr;
            block34: {
                int max;
                int max2;
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if ((c2 = inputBuffer[ptr++]) <= 255) {
                        if (TYPES[c2] != 0) {
                            this._inputPtr = ptr;
                            break block34;
                        }
                    } else if (c2 >= 55296) {
                        this._inputPtr = ptr;
                        break block34;
                    }
                    outputBuffer[outPtr++] = c2;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c2 <= 255) {
                switch (TYPES[c2]) {
                    case 1: {
                        c2 = this.handleInvalidXmlChar(c2);
                    }
                    case 2: {
                        ptr = this._inputPtr;
                        if (ptr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        if (inputBuffer[ptr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 9: {
                        --this._inputPtr;
                        break block8;
                    }
                    case 10: {
                        d2 = this.handleEntityInText(false);
                        if (d2 == 0) {
                            this._entityPending = true;
                            break block8;
                        }
                        if (d2 >> 16 != 0) {
                            outputBuffer[outPtr++] = (char)(0xD800 | (d2 -= 65536) >> 10);
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            d2 = 0xDC00 | d2 & 0x3FF;
                        }
                        c2 = (char)d2;
                        break;
                    }
                    case 11: {
                        int count2 = 1;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((c2 = inputBuffer[this._inputPtr]) != 93) break;
                            ++this._inputPtr;
                            ++count2;
                        }
                        if (c2 == 62 && count2 > 1) {
                            this.reportIllegalCDataEnd();
                        }
                        while (count2 > 1) {
                            outputBuffer[outPtr++] = 93;
                            if (outPtr >= outputBuffer.length) {
                                outputBuffer = this._textBuilder.finishCurrentSegment();
                                outPtr = 0;
                            }
                            --count2;
                        }
                        c2 = 93;
                    }
                }
            } else if (c2 >= 55296) {
                if (c2 < 57344) {
                    d2 = this.checkSurrogate((char)c2);
                    outputBuffer[outPtr++] = c2;
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c2 = d2;
                } else if (c2 >= 65534) {
                    c2 = this.handleInvalidXmlChar(c2);
                }
            }
            outputBuffer[outPtr++] = c2;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected final boolean skipCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return false;
            }
            if (this._inputBuffer[this._inputPtr] == '<') {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain(3)) {
                    return false;
                }
                if (this._inputBuffer[this._inputPtr + 1] != '!' || this._inputBuffer[this._inputPtr + 2] != '[') {
                    return false;
                }
                this._inputPtr += 3;
                for (int i2 = 0; i2 < 6; ++i2) {
                    char c2;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c2 = this._inputBuffer[this._inputPtr++]) == "CDATA[".charAt(i2)) continue;
                    this.reportTreeUnexpChar(c2, " (expected '" + "CDATA[".charAt(i2) + "' for CDATA section)");
                }
                this.skipCData();
                continue;
            }
            if (this.skipCharacters()) break;
        }
        return true;
    }

    @Override
    protected final void skipComment() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        while (true) {
            char c2;
            block16: {
                int max;
                int ptr;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if ((c2 = inputBuffer[ptr++]) <= '\u00ff') {
                        if (TYPES[c2] == 0) continue;
                        this._inputPtr = ptr;
                    } else {
                        if (c2 < '\ud800') continue;
                        this._inputPtr = ptr;
                    }
                    break block16;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c2 > '\u00ff') continue;
            switch (TYPES[c2]) {
                case 1: {
                    c2 = this.handleInvalidXmlChar(c2);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 13: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] != '-') break;
                    ++this._inputPtr;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr++] != '>') {
                        this.reportDoubleHyphenInComments();
                    }
                    return;
                }
            }
        }
    }

    @Override
    protected final void skipPI() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        while (true) {
            char c2;
            block15: {
                int max;
                int ptr;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if ((c2 = inputBuffer[ptr++]) <= '\u00ff') {
                        if (TYPES[c2] == 0) continue;
                        this._inputPtr = ptr;
                    } else {
                        if (c2 < '\ud800') continue;
                        this._inputPtr = ptr;
                    }
                    break block15;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c2 <= '\u00ff') {
                switch (TYPES[c2]) {
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 12: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] != '>') break;
                        ++this._inputPtr;
                        return;
                    }
                }
                continue;
            }
            if (c2 < '\ud800') continue;
            if (c2 < '\ue000') {
                this.checkSurrogate(c2);
                continue;
            }
            if (c2 < '\ufffe') continue;
            char c3 = this.handleInvalidXmlChar(c2);
        }
    }

    @Override
    protected final boolean skipCharacters() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.TEXT_CHARS;
        char[] inputBuffer = this._inputBuffer;
        block8: while (true) {
            char c2;
            block19: {
                int max;
                int ptr;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if ((c2 = inputBuffer[ptr++]) <= '\u00ff') {
                        if (TYPES[c2] == 0) continue;
                        this._inputPtr = ptr;
                    } else {
                        if (c2 < '\ud800') continue;
                        this._inputPtr = ptr;
                    }
                    break block19;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c2 <= '\u00ff') {
                switch (TYPES[c2]) {
                    case 1: {
                        c2 = this.handleInvalidXmlChar(c2);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 9: {
                        --this._inputPtr;
                        return false;
                    }
                    case 10: {
                        int d2 = this.handleEntityInText(false);
                        if (d2 != 0) continue block8;
                        return true;
                    }
                    case 11: {
                        int count2 = 1;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((c2 = inputBuffer[this._inputPtr]) != ']') break;
                            ++this._inputPtr;
                            ++count2;
                        }
                        if (c2 != '>' || count2 <= true) break;
                        this.reportIllegalCDataEnd();
                    }
                }
                continue;
            }
            if (c2 < '\ud800') continue;
            if (c2 < '\ue000') {
                this.checkSurrogate(c2);
                continue;
            }
            if (c2 < '\ufffe') continue;
            char c3 = this.handleInvalidXmlChar(c2);
        }
    }

    @Override
    protected final void skipCData() throws XMLStreamException {
        int[] TYPES = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] inputBuffer = this._inputBuffer;
        while (true) {
            char c2;
            int ptr;
            block18: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if ((c2 = inputBuffer[ptr++]) <= '\u00ff') {
                        if (TYPES[c2] == 0) continue;
                        this._inputPtr = ptr;
                    } else {
                        if (c2 < '\ud800') continue;
                        this._inputPtr = ptr;
                    }
                    break block18;
                }
                this._inputPtr = ptr;
                continue;
            }
            if (c2 <= '\u00ff') {
                switch (TYPES[c2]) {
                    case 1: {
                        c2 = this.handleInvalidXmlChar(c2);
                    }
                    case 2: {
                        ptr = this._inputPtr;
                        if (ptr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            ptr = this._inputPtr;
                        }
                        if (inputBuffer[ptr] == '\n') {
                            ++ptr;
                            ++this._inputPtr;
                        }
                        this.markLF(ptr);
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 11: {
                        int count2 = 0;
                        do {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            ++count2;
                        } while ((c2 = this._inputBuffer[this._inputPtr++]) == ']');
                        if (c2 == '>') {
                            if (count2 <= 1) break;
                            return;
                        }
                        --this._inputPtr;
                    }
                }
                continue;
            }
            if (c2 < '\ud800') continue;
            if (c2 < '\ue000') {
                this.checkSurrogate(c2);
                continue;
            }
            if (c2 < '\ufffe') continue;
            char c3 = this.handleInvalidXmlChar(c2);
        }
    }

    @Override
    protected final void skipSpace() throws XMLStreamException {
        int ptr = this._inputPtr;
        while (true) {
            char c2;
            if (ptr >= this._inputEnd) {
                if (!this.loadMore()) break;
                ptr = this._inputPtr;
            }
            if ((c2 = this._inputBuffer[ptr]) > ' ') break;
            ++ptr;
            if (c2 == '\n') {
                this.markLF(ptr);
                continue;
            }
            if (c2 == '\r') {
                if (ptr >= this._inputEnd) {
                    if (!this.loadMore()) break;
                    ptr = this._inputPtr;
                }
                if (this._inputBuffer[ptr] == '\n') {
                    ++ptr;
                }
                this.markLF(ptr);
                continue;
            }
            if (c2 == ' ' || c2 == '\t') continue;
            this._inputPtr = ptr;
            this.throwInvalidSpace(c2);
        }
        this._inputPtr = ptr;
    }

    protected char skipInternalWs(boolean reqd, String msg) throws XMLStreamException {
        char c2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
            if (!reqd) {
                return c2;
            }
            this.reportTreeUnexpChar(c2, " (expected white space " + msg + ")");
        }
        do {
            if (c2 == '\n') {
                this.markLF();
            } else if (c2 == '\r') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if (this._inputBuffer[this._inputPtr] == '\n') {
                    ++this._inputPtr;
                }
                this.markLF();
            } else if (c2 != ' ' && c2 != '\t') {
                this.throwInvalidSpace(c2);
            }
            if (this._inputPtr < this._inputEnd) continue;
            this.loadMoreGuaranteed();
        } while ((c2 = this._inputBuffer[this._inputPtr++]) <= ' ');
        return c2;
    }

    private final void matchAsciiKeyword(String keyw) throws XMLStreamException {
        int len = keyw.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) == keyw.charAt(i2)) continue;
            this.reportTreeUnexpChar(c2, " (expected '" + keyw.charAt(i2) + "' for " + keyw + " keyword)");
        }
    }

    protected final int checkInTreeIndentation(char c2) throws XMLStreamException {
        int count2;
        int max;
        if (c2 == '\r') {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == '\n') {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c2 = this._inputBuffer[this._inputPtr]) != ' ' && c2 != '\t') {
            if (c2 == '<' && this._inputPtr + 1 < this._inputEnd && this._inputBuffer[this._inputPtr + 1] != '!') {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int n2 = max = c2 == ' ' ? 32 : 8;
        for (count2 = 1; count2 <= max; ++count2) {
            char c22;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c22 = this._inputBuffer[this._inputPtr]) != c2) {
                if (c22 != '<' || this._inputPtr + 1 >= this._inputEnd || this._inputBuffer[this._inputPtr + 1] == '!') break;
                this._textBuilder.resetWithIndentation(count2, c2);
                return -1;
            }
            ++this._inputPtr;
        }
        char[] outputBuffer = this._textBuilder.resetWithEmpty();
        outputBuffer[0] = 10;
        for (int i2 = 1; i2 <= count2; ++i2) {
            outputBuffer[i2] = c2;
        }
        this._textBuilder.setCurrentLength(++count2);
        return count2;
    }

    protected final int checkPrologIndentation(char c2) throws XMLStreamException {
        int max;
        if (c2 == '\r') {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == '\n') {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._textBuilder.resetWithIndentation(0, ' ');
            return -1;
        }
        c2 = this._inputBuffer[this._inputPtr];
        if (c2 != ' ' && c2 != '\t') {
            if (c2 == '<') {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int count2 = 1;
        int n2 = max = c2 == ' ' ? 32 : 8;
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == c2) {
            ++this._inputPtr;
            if (++count2 < max) continue;
            char[] outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = 10;
            for (int i2 = 1; i2 <= count2; ++i2) {
                outputBuffer[i2] = c2;
            }
            this._textBuilder.setCurrentLength(++count2);
            return count2;
        }
        this._textBuilder.resetWithIndentation(count2, c2);
        return -1;
    }

    protected PName parsePName(char c2) throws XMLStreamException {
        char[] nameBuffer = this._nameBuffer;
        if (c2 < 65) {
            this.throwUnexpectedChar(c2, "; expected a name start character");
        }
        nameBuffer[0] = c2;
        int hash = c2;
        int ptr = 1;
        while (true) {
            int d2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((d2 = (c2 = this._inputBuffer[this._inputPtr])) < 65 && (d2 < 45 || d2 > 58 || d2 == 47)) {
                PName n2 = this._symbols.findSymbol(nameBuffer, 0, ptr, hash);
                if (n2 == null) {
                    n2 = this.addPName(nameBuffer, ptr, hash);
                }
                return n2;
            }
            ++this._inputPtr;
            if (ptr >= nameBuffer.length) {
                this._nameBuffer = nameBuffer = DataUtil.growArrayBy(nameBuffer, nameBuffer.length);
            }
            nameBuffer[ptr++] = c2;
            hash = hash * 31 + d2;
        }
    }

    protected final PName addPName(char[] nameBuffer, int nameLen, int hash) throws XMLStreamException {
        char c2 = nameBuffer[0];
        int namePtr = 1;
        int last_colon = -1;
        if (c2 < '\ud800' || c2 >= '\ue000') {
            if (!XmlChars.is10NameStartChar(c2)) {
                this.reportInvalidNameChar(c2, 0);
            }
        } else {
            if (nameLen == 1) {
                this.reportInvalidFirstSurrogate(c2);
            }
            this.checkSurrogateNameChar(c2, nameBuffer[1], 0);
            ++namePtr;
        }
        while (namePtr < nameLen) {
            c2 = nameBuffer[namePtr];
            if (c2 < '\ud800' || c2 >= '\ue000') {
                if (c2 == ':') {
                    if (last_colon >= 0) {
                        this.reportMultipleColonsInName();
                    }
                    last_colon = namePtr;
                } else if (!XmlChars.is10NameChar(c2)) {
                    this.reportInvalidNameChar(c2, namePtr);
                }
            } else {
                if (namePtr + 1 >= nameLen) {
                    this.reportInvalidFirstSurrogate(c2);
                }
                this.checkSurrogateNameChar(c2, nameBuffer[namePtr + 1], namePtr);
            }
            ++namePtr;
        }
        return this._symbols.addSymbol(nameBuffer, 0, nameLen, hash);
    }

    protected String parsePublicId(char quoteChar) throws XMLStreamException {
        char[] outputBuffer = this._nameBuffer;
        int outPtr = 0;
        int[] TYPES = XmlCharTypes.PUBID_CHARS;
        boolean addSpace = false;
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) == quoteChar) break;
            if (c2 > '\u00ff' || TYPES[c2] != 1) {
                this.throwUnexpectedChar(c2, " in public identifier");
            }
            if (c2 <= ' ') {
                addSpace = true;
                continue;
            }
            if (addSpace) {
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                outputBuffer[outPtr++] = 32;
                addSpace = false;
            }
            if (outPtr >= outputBuffer.length) {
                this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                outPtr = 0;
            }
            outputBuffer[outPtr++] = c2;
        }
        return new String(outputBuffer, 0, outPtr);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String parseSystemId(char quoteChar) throws XMLStreamException {
        char[] outputBuffer = this._nameBuffer;
        int outPtr = 0;
        int[] TYPES = ReaderScanner.sCharTypes.ATTR_CHARS;
        while (true) {
            int c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (TYPES[c2 = this._inputBuffer[this._inputPtr++]] != 0) {
                switch (TYPES[c2]) {
                    case 1: {
                        c2 = this.handleInvalidXmlChar(c2);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 14: {
                        if (c2 != quoteChar) break;
                        return new String(outputBuffer, 0, outPtr);
                    }
                }
            }
            if (outPtr >= outputBuffer.length) {
                this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                outPtr = 0;
            }
            outputBuffer[outPtr++] = c2;
        }
    }

    private char checkSurrogate(char firstChar) throws XMLStreamException {
        int val;
        char sec;
        if (firstChar >= '\udc00') {
            this.reportInvalidFirstSurrogate(firstChar);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((sec = this._inputBuffer[this._inputPtr++]) < '\udc00' || sec >= '\ue000') {
            this.reportInvalidSecondSurrogate(sec);
        }
        if ((val = (firstChar - 55296 << 10) + 65536) > 0x10FFFF) {
            this.reportInvalidXmlChar(val);
        }
        return sec;
    }

    private int checkSurrogateNameChar(char firstChar, char sec, int index2) throws XMLStreamException {
        int val;
        if (firstChar >= '\udc00') {
            this.reportInvalidFirstSurrogate(firstChar);
        }
        if (sec < '\udc00' || sec >= '\ue000') {
            this.reportInvalidSecondSurrogate(sec);
        }
        if ((val = (firstChar - 55296 << 10) + 65536) > 0x10FFFF) {
            this.reportInvalidXmlChar(val);
        }
        this.reportInvalidNameChar(val, index2);
        return val;
    }

    private int decodeSurrogate(char firstChar) throws XMLStreamException {
        int val;
        char sec;
        if (firstChar >= '\udc00') {
            this.reportInvalidFirstSurrogate(firstChar);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((sec = this._inputBuffer[this._inputPtr++]) < '\udc00' || sec >= '\ue000') {
            this.reportInvalidSecondSurrogate(sec);
        }
        if ((val = (firstChar - 55296 << 10) + 65536) > 0x10FFFF) {
            this.reportInvalidXmlChar(val);
        }
        return val;
    }

    private void reportInvalidFirstSurrogate(char ch) throws XMLStreamException {
        this.reportInputProblem("Invalid surrogate character (code 0x" + Integer.toHexString(ch) + "): can not start a surrogate pair");
    }

    private void reportInvalidSecondSurrogate(char ch) throws XMLStreamException {
        this.reportInputProblem("Invalid surrogate character (code " + Integer.toHexString(ch) + "): is not legal as the second part of a surrogate pair");
    }

    @Override
    public XMLStreamLocation2 getCurrentLocation() {
        return LocationImpl.fromZeroBased(this._config.getPublicId(), this._config.getSystemId(), this._pastBytesOrChars + (long)this._inputPtr, this._currRow, this._inputPtr - this._rowStartOffset);
    }

    protected final void markLF(int offset) {
        this._rowStartOffset = offset;
        ++this._currRow;
    }

    protected final void markLF() {
        this._rowStartOffset = this._inputPtr;
        ++this._currRow;
    }

    protected final void setStartLocation() {
        this._startRawOffset = this._pastBytesOrChars + (long)this._inputPtr;
        this._startRow = this._currRow;
        this._startColumn = this._inputPtr - this._rowStartOffset;
    }

    @Override
    protected final boolean loadMore() throws XMLStreamException {
        if (this._in == null) {
            this._inputEnd = 0;
            return false;
        }
        this._pastBytesOrChars += (long)this._inputEnd;
        this._rowStartOffset -= this._inputEnd;
        this._inputPtr = 0;
        try {
            int count2 = this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (count2 < 1) {
                this._inputEnd = 0;
                if (count2 == 0) {
                    this.reportInputProblem("Reader returned 0 bytes, even when asked to read up to " + this._inputBuffer.length);
                }
                return false;
            }
            this._inputEnd = count2;
            return true;
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    protected final char loadOne(int type2) throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(type2));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final boolean loadAndRetain(int nrOfChars) throws XMLStreamException {
        if (this._in == null) {
            return false;
        }
        this._pastBytesOrChars += (long)this._inputPtr;
        this._rowStartOffset -= this._inputPtr;
        int remaining = this._inputEnd - this._inputPtr;
        System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, remaining);
        this._inputPtr = 0;
        this._inputEnd = remaining;
        try {
            do {
                int max;
                int count2;
                if ((count2 = this._in.read(this._inputBuffer, this._inputEnd, max = this._inputBuffer.length - this._inputEnd)) < 1) {
                    if (count2 == 0) {
                        this.reportInputProblem("Reader returned 0 bytes, even when asked to read up to " + max);
                    }
                    return false;
                }
                this._inputEnd += count2;
            } while (this._inputEnd < nrOfChars);
            return true;
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }
}

