/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

public class SymbolTable {
    protected static final int DEFAULT_TABLE_SIZE = 128;
    protected static final float DEFAULT_FILL_FACTOR = 0.75f;
    protected static final String EMPTY_STRING = "";
    protected boolean mInternStrings;
    protected String[] mSymbols;
    protected Bucket[] mBuckets;
    protected int mSize;
    protected int mSizeThreshold;
    protected int mIndexMask;
    protected int mThisVersion;
    protected boolean mDirty;

    public SymbolTable() {
        this(true);
    }

    public SymbolTable(boolean internStrings) {
        this(internStrings, 128);
    }

    public SymbolTable(boolean internStrings, int initialSize) {
        this(internStrings, initialSize, 0.75f);
    }

    public SymbolTable(boolean internStrings, int initialSize, float fillFactor) {
        int currSize;
        this.mInternStrings = internStrings;
        this.mThisVersion = 1;
        this.mDirty = true;
        if (initialSize < 1) {
            throw new IllegalArgumentException("Can not use negative/zero initial size: " + initialSize);
        }
        for (currSize = 4; currSize < initialSize; currSize += currSize) {
        }
        initialSize = currSize;
        this.mSymbols = new String[initialSize];
        this.mBuckets = new Bucket[initialSize >> 1];
        this.mIndexMask = initialSize - 1;
        this.mSize = 0;
        if (fillFactor < 0.01f) {
            throw new IllegalArgumentException("Fill factor can not be lower than 0.01.");
        }
        if (fillFactor > 10.0f) {
            throw new IllegalArgumentException("Fill factor can not be higher than 10.0.");
        }
        this.mSizeThreshold = (int)((double)((float)initialSize * fillFactor) + 0.5);
    }

    private SymbolTable(boolean internStrings, String[] symbols, Bucket[] buckets, int size, int sizeThreshold, int indexMask, int version) {
        this.mInternStrings = internStrings;
        this.mSymbols = symbols;
        this.mBuckets = buckets;
        this.mSize = size;
        this.mSizeThreshold = sizeThreshold;
        this.mIndexMask = indexMask;
        this.mThisVersion = version;
        this.mDirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymbolTable makeChild() {
        int version;
        int indexMask;
        int sizeThreshold;
        int size;
        Bucket[] buckets;
        String[] symbols;
        boolean internStrings;
        SymbolTable symbolTable = this;
        synchronized (symbolTable) {
            internStrings = this.mInternStrings;
            symbols = this.mSymbols;
            buckets = this.mBuckets;
            size = this.mSize;
            sizeThreshold = this.mSizeThreshold;
            indexMask = this.mIndexMask;
            version = this.mThisVersion + 1;
        }
        return new SymbolTable(internStrings, symbols, buckets, size, sizeThreshold, indexMask, version);
    }

    public synchronized void mergeChild(SymbolTable child) {
        if (child.size() <= this.size()) {
            return;
        }
        this.mSymbols = child.mSymbols;
        this.mBuckets = child.mBuckets;
        this.mSize = child.mSize;
        this.mSizeThreshold = child.mSizeThreshold;
        this.mIndexMask = child.mIndexMask;
        ++this.mThisVersion;
        this.mDirty = false;
        child.mDirty = false;
    }

    public void setInternStrings(boolean state) {
        this.mInternStrings = state;
    }

    public int size() {
        return this.mSize;
    }

    public int version() {
        return this.mThisVersion;
    }

    public boolean isDirty() {
        return this.mDirty;
    }

    public boolean isDirectChildOf(SymbolTable t2) {
        return this.mThisVersion == t2.mThisVersion + 1;
    }

    public String findSymbol(char[] buffer, int start, int len, int hash) {
        if (len < 1) {
            return EMPTY_STRING;
        }
        String sym = this.mSymbols[hash &= this.mIndexMask];
        if (sym != null) {
            Bucket b2;
            if (sym.length() == len) {
                int i2 = 0;
                while (sym.charAt(i2) == buffer[start + i2] && ++i2 < len) {
                }
                if (i2 == len) {
                    return sym;
                }
            }
            if ((b2 = this.mBuckets[hash >> 1]) != null && (sym = b2.find(buffer, start, len)) != null) {
                return sym;
            }
        }
        if (this.mSize >= this.mSizeThreshold) {
            this.rehash();
            hash = SymbolTable.calcHash(buffer, start, len) & this.mIndexMask;
        } else if (!this.mDirty) {
            this.copyArrays();
            this.mDirty = true;
        }
        ++this.mSize;
        String newSymbol = new String(buffer, start, len);
        if (this.mInternStrings) {
            newSymbol = newSymbol.intern();
        }
        if (this.mSymbols[hash] == null) {
            this.mSymbols[hash] = newSymbol;
        } else {
            int bix = hash >> 1;
            this.mBuckets[bix] = new Bucket(newSymbol, this.mBuckets[bix]);
        }
        return newSymbol;
    }

    public String findSymbolIfExists(char[] buffer, int start, int len, int hash) {
        if (len < 1) {
            return EMPTY_STRING;
        }
        String sym = this.mSymbols[hash &= this.mIndexMask];
        if (sym != null) {
            Bucket b2;
            if (sym.length() == len) {
                int i2 = 0;
                while (sym.charAt(i2) == buffer[start + i2] && ++i2 < len) {
                }
                if (i2 == len) {
                    return sym;
                }
            }
            if ((b2 = this.mBuckets[hash >> 1]) != null && (sym = b2.find(buffer, start, len)) != null) {
                return sym;
            }
        }
        return null;
    }

    public String findSymbol(String str) {
        int len = str.length();
        if (len < 1) {
            return EMPTY_STRING;
        }
        int index2 = SymbolTable.calcHash(str) & this.mIndexMask;
        String sym = this.mSymbols[index2];
        if (sym != null) {
            Bucket b2;
            if (sym.length() == len) {
                int i2;
                for (i2 = 0; i2 < len && sym.charAt(i2) == str.charAt(i2); ++i2) {
                }
                if (i2 == len) {
                    return sym;
                }
            }
            if ((b2 = this.mBuckets[index2 >> 1]) != null && (sym = b2.find(str)) != null) {
                return sym;
            }
        }
        if (this.mSize >= this.mSizeThreshold) {
            this.rehash();
            index2 = SymbolTable.calcHash(str) & this.mIndexMask;
        } else if (!this.mDirty) {
            this.copyArrays();
            this.mDirty = true;
        }
        ++this.mSize;
        if (this.mInternStrings) {
            str = str.intern();
        }
        if (this.mSymbols[index2] == null) {
            this.mSymbols[index2] = str;
        } else {
            int bix = index2 >> 1;
            this.mBuckets[bix] = new Bucket(str, this.mBuckets[bix]);
        }
        return str;
    }

    public static int calcHash(char[] buffer, int start, int len) {
        int hash = buffer[start];
        for (int i2 = 1; i2 < len; ++i2) {
            hash = hash * 31 + buffer[start + i2];
        }
        return hash;
    }

    public static int calcHash(String key) {
        int hash = key.charAt(0);
        int len = key.length();
        for (int i2 = 1; i2 < len; ++i2) {
            hash = hash * 31 + key.charAt(i2);
        }
        return hash;
    }

    private void copyArrays() {
        String[] oldSyms = this.mSymbols;
        int size = oldSyms.length;
        this.mSymbols = new String[size];
        System.arraycopy(oldSyms, 0, this.mSymbols, 0, size);
        Bucket[] oldBuckets = this.mBuckets;
        size = oldBuckets.length;
        this.mBuckets = new Bucket[size];
        System.arraycopy(oldBuckets, 0, this.mBuckets, 0, size);
    }

    private void rehash() {
        int i2;
        int size = this.mSymbols.length;
        int newSize = size + size;
        String[] oldSyms = this.mSymbols;
        Bucket[] oldBuckets = this.mBuckets;
        this.mSymbols = new String[newSize];
        this.mBuckets = new Bucket[newSize >> 1];
        this.mIndexMask = newSize - 1;
        this.mSizeThreshold += this.mSizeThreshold;
        int count2 = 0;
        for (i2 = 0; i2 < size; ++i2) {
            String symbol = oldSyms[i2];
            if (symbol == null) continue;
            ++count2;
            int index2 = SymbolTable.calcHash(symbol) & this.mIndexMask;
            if (this.mSymbols[index2] == null) {
                this.mSymbols[index2] = symbol;
                continue;
            }
            int bix = index2 >> 1;
            this.mBuckets[bix] = new Bucket(symbol, this.mBuckets[bix]);
        }
        size >>= 1;
        for (i2 = 0; i2 < size; ++i2) {
            for (Bucket b2 = oldBuckets[i2]; b2 != null; b2 = b2.getNext()) {
                ++count2;
                String symbol = b2.getSymbol();
                int index3 = SymbolTable.calcHash(symbol) & this.mIndexMask;
                if (this.mSymbols[index3] == null) {
                    this.mSymbols[index3] = symbol;
                    continue;
                }
                int bix = index3 >> 1;
                this.mBuckets[bix] = new Bucket(symbol, this.mBuckets[bix]);
            }
        }
        if (count2 != this.mSize) {
            throw new IllegalStateException("Internal error on SymbolTable.rehash(): had " + this.mSize + " entries; now have " + count2 + ".");
        }
    }

    public double calcAvgSeek() {
        int i2;
        int count2 = 0;
        int len = this.mSymbols.length;
        for (i2 = 0; i2 < len; ++i2) {
            if (this.mSymbols[i2] == null) continue;
            ++count2;
        }
        len = this.mBuckets.length;
        for (i2 = 0; i2 < len; ++i2) {
            int cost = 2;
            for (Bucket b2 = this.mBuckets[i2]; b2 != null; b2 = b2.getNext()) {
                count2 += cost;
                ++cost;
            }
        }
        return (double)count2 / (double)this.mSize;
    }

    static final class Bucket {
        private final String mSymbol;
        private final Bucket mNext;

        public Bucket(String symbol, Bucket next) {
            this.mSymbol = symbol;
            this.mNext = next;
        }

        public String getSymbol() {
            return this.mSymbol;
        }

        public Bucket getNext() {
            return this.mNext;
        }

        public String find(char[] buf, int start, int len) {
            String sym = this.mSymbol;
            Bucket b2 = this.mNext;
            while (true) {
                if (sym.length() == len) {
                    int i2 = 0;
                    while (sym.charAt(i2) == buf[start + i2] && ++i2 < len) {
                    }
                    if (i2 == len) {
                        return sym;
                    }
                }
                if (b2 == null) break;
                sym = b2.getSymbol();
                b2 = b2.getNext();
            }
            return null;
        }

        public String find(String str) {
            String sym = this.mSymbol;
            Bucket b2 = this.mNext;
            while (true) {
                if (sym.equals(str)) {
                    return sym;
                }
                if (b2 == null) break;
                sym = b2.getSymbol();
                b2 = b2.getNext();
            }
            return null;
        }
    }
}

