/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

public final class ArgUtil {
    private ArgUtil() {
    }

    public static boolean convertToBoolean(String prop, Object value2) {
        if (value2 == null) {
            return false;
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.equalsIgnoreCase("false")) {
                return false;
            }
            if (str.equalsIgnoreCase("true")) {
                return true;
            }
            throw new IllegalArgumentException("Invalid String value for property '" + prop + "': expected Boolean value.");
        }
        throw new IllegalArgumentException("Invalid value type (" + value2.getClass() + ") for property '" + prop + "': expected Boolean value.");
    }

    public static int convertToInt(String prop, Object value2, int minValue) {
        int i2;
        if (value2 == null) {
            i2 = 0;
        } else if (value2 instanceof Number) {
            i2 = ((Number)value2).intValue();
        } else if (value2 instanceof String) {
            try {
                i2 = Integer.parseInt((String)value2);
            }
            catch (NumberFormatException nex) {
                throw new IllegalArgumentException("Invalid String value for property '" + prop + "': expected a number (Integer).");
            }
        } else {
            throw new IllegalArgumentException("Invalid value type (" + value2.getClass() + ") for property '" + prop + "': expected Integer value.");
        }
        if (i2 < minValue) {
            throw new IllegalArgumentException("Invalid numeric value (" + i2 + ") for property '" + prop + "': minimum is " + minValue + ".");
        }
        return i2;
    }

    public static long convertToLong(String prop, Object value2, long minValue) {
        long i2;
        if (value2 == null) {
            i2 = 0L;
        } else if (value2 instanceof Number) {
            i2 = ((Number)value2).longValue();
        } else if (value2 instanceof String) {
            try {
                i2 = Long.parseLong((String)value2);
            }
            catch (NumberFormatException nex) {
                throw new IllegalArgumentException("Invalid String value for property '" + prop + "': expected a number (Long).");
            }
        } else {
            throw new IllegalArgumentException("Invalid value type (" + value2.getClass() + ") for property '" + prop + "': expected Long value.");
        }
        if (i2 < minValue) {
            throw new IllegalArgumentException("Invalid numeric value (" + i2 + ") for property '" + prop + "': minimum is " + minValue + ".");
        }
        return i2;
    }
}

