/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import com.ctc.wstx.util.BaseNsContext;
import com.ctc.wstx.util.DataUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Namespace;
import org.codehaus.stax2.ri.evt.NamespaceEventImpl;

public final class CompactNsContext
extends BaseNsContext {
    final Location mLocation;
    final String[] mNamespaces;
    final int mNsLength;
    final int mFirstLocalNs;
    transient ArrayList<Namespace> mNsList;

    public CompactNsContext(Location loc, String[] namespaces, int nsLen, int firstLocal) {
        this.mLocation = loc;
        this.mNamespaces = namespaces;
        this.mNsLength = nsLen;
        this.mFirstLocalNs = firstLocal;
    }

    @Override
    public String doGetNamespaceURI(String prefix) {
        String[] ns = this.mNamespaces;
        if (prefix.length() == 0) {
            for (int i2 = this.mNsLength - 2; i2 >= 0; i2 -= 2) {
                if (ns[i2] != null) continue;
                return ns[i2 + 1];
            }
            return null;
        }
        for (int i3 = this.mNsLength - 2; i3 >= 0; i3 -= 2) {
            if (!prefix.equals(ns[i3])) continue;
            return ns[i3 + 1];
        }
        return null;
    }

    @Override
    public String doGetPrefix(String nsURI) {
        String[] ns = this.mNamespaces;
        int len = this.mNsLength;
        block0: for (int i2 = len - 1; i2 > 0; i2 -= 2) {
            if (!nsURI.equals(ns[i2])) continue;
            String prefix = ns[i2 - 1];
            for (int j2 = i2 + 1; j2 < len; j2 += 2) {
                if (ns[j2] == prefix) continue block0;
            }
            String uri = ns[i2 - 1];
            return uri == null ? "" : uri;
        }
        return null;
    }

    @Override
    public Iterator<String> doGetPrefixes(String nsURI) {
        String[] ns = this.mNamespaces;
        int len = this.mNsLength;
        String first2 = null;
        ArrayList<String> all = null;
        block0: for (int i2 = len - 1; i2 > 0; i2 -= 2) {
            String currNS = ns[i2];
            if (currNS != nsURI && !currNS.equals(nsURI)) continue;
            String prefix = ns[i2 - 1];
            for (int j2 = i2 + 1; j2 < len; j2 += 2) {
                if (ns[j2] == prefix) continue block0;
            }
            if (prefix == null) {
                prefix = "";
            }
            if (first2 == null) {
                first2 = prefix;
                continue;
            }
            if (all == null) {
                all = new ArrayList<String>();
                all.add(first2);
            }
            all.add(prefix);
        }
        if (all != null) {
            return all.iterator();
        }
        if (first2 != null) {
            return DataUtil.singletonIterator(first2);
        }
        return DataUtil.emptyIterator();
    }

    @Override
    public Iterator<Namespace> getNamespaces() {
        if (this.mNsList == null) {
            int firstLocal = this.mFirstLocalNs;
            int len = this.mNsLength - firstLocal;
            if (len == 0) {
                return DataUtil.emptyIterator();
            }
            if (len == 2) {
                return DataUtil.singletonIterator(NamespaceEventImpl.constructNamespace(this.mLocation, this.mNamespaces[firstLocal], this.mNamespaces[firstLocal + 1]));
            }
            ArrayList<NamespaceEventImpl> l2 = new ArrayList<NamespaceEventImpl>(len >> 1);
            String[] ns = this.mNamespaces;
            len = this.mNsLength;
            while (firstLocal < len) {
                l2.add(NamespaceEventImpl.constructNamespace(this.mLocation, ns[firstLocal], ns[firstLocal + 1]));
                firstLocal += 2;
            }
            this.mNsList = l2;
        }
        return this.mNsList.iterator();
    }

    @Override
    public void outputNamespaceDeclarations(Writer w2) throws IOException {
        String[] ns = this.mNamespaces;
        int len = this.mNsLength;
        for (int i2 = this.mFirstLocalNs; i2 < len; i2 += 2) {
            w2.write(32);
            w2.write("xmlns");
            String prefix = ns[i2];
            if (prefix != null && prefix.length() > 0) {
                w2.write(58);
                w2.write(prefix);
            }
            w2.write("=\"");
            w2.write(ns[i2 + 1]);
            w2.write(34);
        }
    }

    @Override
    public void outputNamespaceDeclarations(XMLStreamWriter w2) throws XMLStreamException {
        String[] ns = this.mNamespaces;
        int len = this.mNsLength;
        for (int i2 = this.mFirstLocalNs; i2 < len; i2 += 2) {
            String nsURI = ns[i2 + 1];
            String prefix = ns[i2];
            if (prefix != null && prefix.length() > 0) {
                w2.writeNamespace(prefix, nsURI);
                continue;
            }
            w2.writeDefaultNamespace(nsURI);
        }
    }
}

