/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.api.ReaderConfig;
import java.io.IOException;
import java.io.Reader;

public final class MergedReader
extends Reader {
    final ReaderConfig mConfig;
    final Reader mIn;
    char[] mData;
    int mPtr;
    final int mEnd;

    public MergedReader(ReaderConfig cfg, Reader in, char[] buf, int start, int end) {
        this.mConfig = cfg;
        this.mIn = in;
        this.mData = buf;
        this.mPtr = start;
        this.mEnd = end;
        if (buf != null && start >= end) {
            throw new IllegalArgumentException("Trying to construct MergedReader with empty contents (start " + start + ", end " + end + ")");
        }
    }

    @Override
    public void close() throws IOException {
        this.freeMergedBuffer();
        this.mIn.close();
    }

    @Override
    public void mark(int readlimit) throws IOException {
        if (this.mData == null) {
            this.mIn.mark(readlimit);
        }
    }

    @Override
    public boolean markSupported() {
        return this.mData == null && this.mIn.markSupported();
    }

    @Override
    public int read() throws IOException {
        if (this.mData != null) {
            int c2 = this.mData[this.mPtr++] & 0xFF;
            if (this.mPtr >= this.mEnd) {
                this.freeMergedBuffer();
            }
            return c2;
        }
        return this.mIn.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.mData != null) {
            int avail = this.mEnd - this.mPtr;
            if (len > avail) {
                len = avail;
            }
            System.arraycopy(this.mData, this.mPtr, cbuf, off, len);
            this.mPtr += len;
            if (this.mPtr >= this.mEnd) {
                this.freeMergedBuffer();
            }
            return len;
        }
        return this.mIn.read(cbuf, off, len);
    }

    @Override
    public boolean ready() throws IOException {
        return this.mData != null || this.mIn.ready();
    }

    @Override
    public void reset() throws IOException {
        if (this.mData == null) {
            this.mIn.reset();
        }
    }

    @Override
    public long skip(long n2) throws IOException {
        long count2 = 0L;
        if (this.mData != null) {
            int amount = this.mEnd - this.mPtr;
            if ((long)amount > n2) {
                this.mPtr += (int)n2;
                return amount;
            }
            this.freeMergedBuffer();
            count2 += (long)amount;
            n2 -= (long)amount;
        }
        if (n2 > 0L) {
            count2 += this.mIn.skip(n2);
        }
        return count2;
    }

    private void freeMergedBuffer() {
        if (this.mData != null) {
            char[] data2 = this.mData;
            this.mData = null;
            if (this.mConfig != null) {
                this.mConfig.freeSmallCBuffer(data2);
            }
        }
    }
}

