/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.io.BranchingReaderSource;
import com.ctc.wstx.io.CharArraySource;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.ReaderSource;
import com.ctc.wstx.io.SystemId;
import com.ctc.wstx.io.WstxInputSource;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.Location;

public final class InputSourceFactory {
    public static ReaderSource constructEntitySource(ReaderConfig cfg, WstxInputSource parent2, String entityName, InputBootstrapper bs, String pubId, SystemId sysId, int xmlVersion, Reader r2) {
        ReaderSource rs = new ReaderSource(cfg, parent2, entityName, pubId, sysId, r2, true);
        if (bs != null) {
            rs.setInputOffsets(bs.getInputTotal(), bs.getInputRow(), -bs.getInputColumn());
        }
        return rs;
    }

    public static BranchingReaderSource constructDocumentSource(ReaderConfig cfg, InputBootstrapper bs, String pubId, SystemId sysId, Reader r2, boolean realClose) {
        URL url = cfg.getBaseURL();
        if (url != null) {
            sysId = SystemId.construct(url);
        }
        BranchingReaderSource rs = new BranchingReaderSource(cfg, pubId, sysId, r2, realClose);
        if (bs != null) {
            rs.setInputOffsets(bs.getInputTotal(), bs.getInputRow(), -bs.getInputColumn());
        }
        return rs;
    }

    public static WstxInputSource constructCharArraySource(WstxInputSource parent2, String fromEntity, char[] text, int offset, int len, Location loc, URL src) {
        SystemId sysId = SystemId.construct(loc.getSystemId(), src);
        return new CharArraySource(parent2, fromEntity, text, offset, len, loc, sysId);
    }
}

