/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.ent.EntityDecl;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.io.WstxInputSource;
import com.ctc.wstx.sr.StreamScanner;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public class MinimalDTDReader
extends StreamScanner {
    final boolean mIsExternal;

    private MinimalDTDReader(WstxInputSource input, ReaderConfig cfg) {
        this(input, cfg, false);
    }

    protected MinimalDTDReader(WstxInputSource input, ReaderConfig cfg, boolean isExt) {
        super(input, cfg, cfg.getDtdResolver());
        this.mIsExternal = isExt;
        this.mCfgReplaceEntities = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void skipInternalSubset(WstxInputData srcData, WstxInputSource input, ReaderConfig cfg) throws XMLStreamException {
        MinimalDTDReader r2 = new MinimalDTDReader(input, cfg);
        r2.copyBufferStateFrom(srcData);
        try {
            r2.skipInternalSubset();
        }
        finally {
            srcData.copyBufferStateFrom(r2);
        }
    }

    @Override
    public final Location getLocation() {
        return this.getStartLocation();
    }

    @Override
    protected EntityDecl findEntity(String id, Object arg) {
        this.throwIllegalCall();
        return null;
    }

    @Override
    protected void handleUndeclaredEntity(String id) throws XMLStreamException {
    }

    @Override
    protected void handleIncompleteEntityProblem(WstxInputSource closing) throws XMLStreamException {
    }

    protected char handleExpandedSurrogate(char first2, char second2) {
        return first2;
    }

    public EntityDecl findEntity(String entName) {
        return null;
    }

    protected void skipInternalSubset() throws XMLStreamException {
        while (true) {
            int i2;
            if ((i2 = this.getNextAfterWS()) < 0) {
                this.throwUnexpectedEOF(" in internal DTD subset");
            }
            if (i2 == 37) {
                this.skipPE();
                continue;
            }
            if (i2 == 60) {
                char c2 = this.getNextSkippingPEs();
                if (c2 == '?') {
                    this.skipPI();
                    continue;
                }
                if (c2 == '!') {
                    c2 = this.getNextSkippingPEs();
                    if (c2 == '[') continue;
                    if (c2 == '-') {
                        this.skipComment();
                        continue;
                    }
                    if (c2 >= 'A' && c2 <= 'Z') {
                        this.skipDeclaration(c2);
                        continue;
                    }
                    this.skipDeclaration(c2);
                    continue;
                }
                --this.mInputPtr;
                continue;
            }
            if (i2 == 93) {
                if (this.mInput == this.mRootInput) break;
                this.throwParseError("Encountered int. subset end marker ']]>' in an expanded entity; has to be at main level.");
                break;
            }
            this.throwUnexpectedChar(i2, " in internal DTD subset; expected a '<' to start a directive, or \"]>\" to end internal subset.");
        }
    }

    protected char dtdNextFromCurr() throws XMLStreamException {
        return this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.getNextCharFromCurrent(this.getErrorMsg());
    }

    protected char dtdNextChar() throws XMLStreamException {
        return this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
    }

    protected char getNextSkippingPEs() throws XMLStreamException {
        while (true) {
            char c2;
            char c3 = c2 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c2 != '%') {
                return c2;
            }
            this.skipPE();
        }
    }

    private void skipPE() throws XMLStreamException {
        char c2;
        this.skipDTDName();
        char c3 = c2 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.dtdNextFromCurr();
        if (c2 != ';') {
            --this.mInputPtr;
        }
    }

    protected void skipComment() throws XMLStreamException {
        char c2;
        this.skipCommentContent();
        char c3 = c2 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.dtdNextFromCurr();
        if (c2 != '>') {
            this.throwParseError("String '--' not allowed in comment (missing '>'?)");
        }
    }

    protected void skipCommentContent() throws XMLStreamException {
        while (true) {
            char c2;
            char c3 = c2 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.dtdNextFromCurr();
            if (c2 == '-') {
                c2 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.dtdNextFromCurr();
                if (c2 != '-') continue;
                return;
            }
            if (c2 != '\n' && c2 != '\r') continue;
            this.skipCRLF(c2);
        }
    }

    protected void skipPI() throws XMLStreamException {
        while (true) {
            char c2;
            char c3 = c2 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.dtdNextFromCurr();
            if (c2 == '?') {
                while ((c2 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.dtdNextFromCurr()) == '?') {
                }
                if (c2 == '>') break;
            }
            if (c2 != '\n' && c2 != '\r') continue;
            this.skipCRLF(c2);
        }
    }

    private void skipDeclaration(char c2) throws XMLStreamException {
        while (c2 != '>') {
            char c3 = c2 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.dtdNextFromCurr();
            if (c2 == '\n' || c2 == '\r') {
                this.skipCRLF(c2);
                continue;
            }
            if (c2 != '\'' && c2 != '\"') continue;
            this.skipLiteral(c2);
        }
    }

    private void skipLiteral(char quoteChar) throws XMLStreamException {
        while (true) {
            char c2;
            char c3 = c2 = this.mInputPtr < this.mInputEnd ? this.mInputBuffer[this.mInputPtr++] : this.dtdNextFromCurr();
            if (c2 == '\n' || c2 == '\r') {
                this.skipCRLF(c2);
                continue;
            }
            if (c2 == quoteChar) break;
        }
    }

    private void skipDTDName() throws XMLStreamException {
        this.skipFullName(this.getNextChar(this.getErrorMsg()));
    }

    protected String getErrorMsg() {
        return this.mIsExternal ? " in external DTD subset" : " in internal DTD subset";
    }

    protected void throwIllegalCall() throws Error {
        throw new IllegalStateException("Internal error: this method should never be called");
    }
}

