/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheAction;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheRequest;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheResponse;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.support.StringMatcher;
import org.elasticsearch.xpack.security.support.CacheInvalidatorRegistry;
import org.elasticsearch.xpack.security.support.LockingAtomicCounter;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class NativePrivilegeStore {
    public static final Setting<Integer> CACHE_MAX_APPLICATIONS_SETTING = Setting.intSetting((String)"xpack.security.authz.store.privileges.cache.max_size", (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting((String)"xpack.security.authz.store.privileges.cache.ttl", (TimeValue)TimeValue.timeValueHours((long)24L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final TimeValue SECURITY_INDEX_WAIT_TIMEOUT = TimeValue.parseTimeValue((String)System.getProperty("es.security.security_index.wait_timeout", null), (TimeValue)TimeValue.ZERO, (String)"system property <es.security.security_index.wait_timeout>");
    private static final Collector<Tuple<String, String>, ?, Map<String, List<String>>> TUPLES_TO_MAP = Collectors.toMap(Tuple::v1, t -> CollectionUtils.newSingletonArrayList((Object)((String)t.v2())), (a, b) -> {
        a.addAll(b);
        return a;
    });
    private static final Logger logger = LogManager.getLogger(NativePrivilegeStore.class);
    private final Settings settings;
    private final Client client;
    private final SecurityIndexManager securityIndexManager;
    private volatile boolean allowExpensiveQueries;
    private final DescriptorsAndApplicationNamesCache descriptorsAndApplicationNamesCache;

    public NativePrivilegeStore(Settings settings, Client client, SecurityIndexManager securityIndexManager, CacheInvalidatorRegistry cacheInvalidatorRegistry, ClusterService clusterService) {
        this.settings = settings;
        this.client = client;
        this.securityIndexManager = securityIndexManager;
        this.allowExpensiveQueries = (Boolean)SearchService.ALLOW_EXPENSIVE_QUERIES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchService.ALLOW_EXPENSIVE_QUERIES, this::setAllowExpensiveQueries);
        TimeValue ttl = (TimeValue)CACHE_TTL_SETTING.get(settings);
        if (ttl.getNanos() > 0L) {
            this.descriptorsAndApplicationNamesCache = new DescriptorsAndApplicationNamesCache(ttl, (Integer)CACHE_MAX_APPLICATIONS_SETTING.get(settings));
            cacheInvalidatorRegistry.registerCacheInvalidator("application_privileges", this.descriptorsAndApplicationNamesCache);
        } else {
            this.descriptorsAndApplicationNamesCache = null;
        }
    }

    public void getPrivileges(Collection<String> applications, Collection<String> names, ActionListener<Collection<ApplicationPrivilegeDescriptor>> listener) {
        boolean waitForAvailableSecurityIndex = false == SECURITY_INDEX_WAIT_TIMEOUT.equals((Object)TimeValue.ZERO);
        this.getPrivileges(applications, names, waitForAvailableSecurityIndex, listener);
    }

    public void getPrivileges(Collection<String> applications, Collection<String> names, boolean waitForAvailableSecurityIndex, ActionListener<Collection<ApplicationPrivilegeDescriptor>> listener) {
        Set<String> concreteApplicationNames;
        if (!NativePrivilegeStore.isEmpty(names) && names.stream().noneMatch(ApplicationPrivilege::isValidPrivilegeName)) {
            logger.debug("no concrete privilege, only action patterns [{}], returning no application privilege descriptors", names);
            listener.onResponse(Collections.emptySet());
            return;
        }
        Set<String> applicationNamesCacheKey = NativePrivilegeStore.isEmpty(applications) || applications.contains("*") ? Set.of("*") : Set.copyOf(applications);
        Set<String> set = concreteApplicationNames = this.descriptorsAndApplicationNamesCache == null ? null : this.descriptorsAndApplicationNamesCache.getConcreteApplicationNames(applicationNamesCacheKey);
        if (concreteApplicationNames != null && concreteApplicationNames.isEmpty()) {
            logger.debug("returning empty application privileges for [{}] as application names result in empty list", applicationNamesCacheKey);
            listener.onResponse(Collections.emptySet());
        } else {
            Set<ApplicationPrivilegeDescriptor> cachedDescriptors = this.cachedDescriptorsForApplicationNames(concreteApplicationNames != null ? concreteApplicationNames : applicationNamesCacheKey);
            if (cachedDescriptors != null) {
                logger.debug("All application privileges for [{}] found in cache", applicationNamesCacheKey);
                listener.onResponse(NativePrivilegeStore.filterDescriptorsForPrivilegeNames(cachedDescriptors, names));
            } else {
                logger.debug("Fetching application privilege documents for: {}", applicationNamesCacheKey);
                long invalidationCount = this.descriptorsAndApplicationNamesCache == null ? -1L : this.descriptorsAndApplicationNamesCache.getInvalidationCount();
                this.innerGetPrivileges(applicationNamesCacheKey, waitForAvailableSecurityIndex, (ActionListener<Collection<ApplicationPrivilegeDescriptor>>)ActionListener.wrap(fetchedDescriptors -> {
                    Map<String, Set<ApplicationPrivilegeDescriptor>> mapOfFetchedDescriptors = fetchedDescriptors.stream().collect(Collectors.groupingBy(ApplicationPrivilegeDescriptor::getApplication, Collectors.toUnmodifiableSet()));
                    if (invalidationCount != -1L) {
                        this.cacheFetchedDescriptors(applicationNamesCacheKey, mapOfFetchedDescriptors, invalidationCount);
                    }
                    listener.onResponse(NativePrivilegeStore.filterDescriptorsForPrivilegeNames(fetchedDescriptors, names));
                }, arg_0 -> listener.onFailure(arg_0)));
            }
        }
    }

    private void innerGetPrivileges(final Collection<String> applications, boolean waitForAvailableSecurityIndex, final ActionListener<Collection<ApplicationPrivilegeDescriptor>> listener) {
        assert (applications != null && applications.size() > 0) : "Application names are required (found " + String.valueOf(applications) + ")";
        final SecurityIndexManager frozenSecurityIndex = this.securityIndexManager.defensiveCopy();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse(Collections.emptyList());
        } else if (!frozenSecurityIndex.isAvailable(SecurityIndexManager.Availability.SEARCH_SHARDS)) {
            ElasticsearchException unavailableReason = frozenSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.SEARCH_SHARDS);
            if (!waitForAvailableSecurityIndex || !(unavailableReason instanceof UnavailableShardsException)) {
                listener.onFailure((Exception)((Object)unavailableReason));
                return;
            }
            this.securityIndexManager.onIndexAvailableForSearch(new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    NativePrivilegeStore.this.innerGetPrivileges(applications, false, (ActionListener<Collection<ApplicationPrivilegeDescriptor>>)listener);
                }

                public void onFailure(Exception e) {
                    logger.warn("Failure while waiting for security index [" + frozenSecurityIndex.getConcreteIndexName() + "]", (Throwable)e);
                    NativePrivilegeStore.this.innerGetPrivileges(applications, false, (ActionListener<Collection<ApplicationPrivilegeDescriptor>>)listener);
                }
            }, SECURITY_INDEX_WAIT_TIMEOUT);
        } else {
            this.securityIndexManager.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                TermQueryBuilder typeQuery = QueryBuilders.termQuery((String)ApplicationPrivilegeDescriptor.Fields.TYPE.getPreferredName(), (String)"application-privilege");
                Tuple<QueryBuilder, Predicate<String>> applicationNameQueryAndPredicate = this.getApplicationNameQueryAndPredicate(applications);
                BoolQueryBuilder query = applicationNameQueryAndPredicate.v1() != null ? QueryBuilders.boolQuery().filter((QueryBuilder)typeQuery).filter((QueryBuilder)applicationNameQueryAndPredicate.v1()) : QueryBuilders.boolQuery().filter((QueryBuilder)typeQuery);
                Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
                try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("security");){
                    SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.settings)).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
                    logger.trace(() -> NativePrivilegeStore.lambda$innerGetPrivileges$3(applications, (QueryBuilder)query));
                    ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, listener), hit -> NativePrivilegeStore.buildPrivilege(hit.getId(), hit.getSourceRef(), (Predicate)applicationNameQueryAndPredicate.v2()));
                }
            });
        }
    }

    public SecurityIndexManager getSecurityIndexManager() {
        return this.securityIndexManager;
    }

    private Tuple<QueryBuilder, Predicate<String>> getApplicationNameQueryAndPredicate(Collection<String> applications) {
        TermsQueryBuilder termsQuery;
        if (applications.contains("*")) {
            return new Tuple((Object)QueryBuilders.existsQuery((String)ApplicationPrivilegeDescriptor.Fields.APPLICATION.getPreferredName()), null);
        }
        ArrayList<String> rawNames = new ArrayList<String>(applications.size());
        ArrayList<String> wildcardNames = new ArrayList<String>(applications.size());
        for (String name : applications) {
            if (name.endsWith("*")) {
                wildcardNames.add(name);
                continue;
            }
            rawNames.add(name);
        }
        assert (!rawNames.isEmpty() || !wildcardNames.isEmpty());
        TermsQueryBuilder termsQueryBuilder = termsQuery = rawNames.isEmpty() ? null : QueryBuilders.termsQuery((String)ApplicationPrivilegeDescriptor.Fields.APPLICATION.getPreferredName(), rawNames);
        if (wildcardNames.isEmpty()) {
            return new Tuple((Object)termsQuery, null);
        }
        if (this.allowExpensiveQueries) {
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            if (termsQuery != null) {
                boolQuery.should((QueryBuilder)termsQuery);
            }
            for (String wildcard : wildcardNames) {
                String prefix = wildcard.substring(0, wildcard.length() - 1);
                boolQuery.should((QueryBuilder)QueryBuilders.prefixQuery((String)ApplicationPrivilegeDescriptor.Fields.APPLICATION.getPreferredName(), (String)prefix));
            }
            boolQuery.minimumShouldMatch(1);
            return new Tuple((Object)boolQuery, null);
        }
        logger.trace("expensive queries are not allowed, switching to filtering application names in memory");
        return new Tuple(null, (Object)StringMatcher.of(applications));
    }

    private void setAllowExpensiveQueries(boolean allowExpensiveQueries) {
        this.allowExpensiveQueries = allowExpensiveQueries;
    }

    private static ApplicationPrivilegeDescriptor buildPrivilege(String docId, BytesReference source, @Nullable Predicate<String> applicationNamePredicate) {
        ApplicationPrivilegeDescriptor applicationPrivilegeDescriptor;
        block12: {
            logger.trace("Building privilege from [{}] [{}]", (Object)docId, (Object)(source == null ? "<<null>>" : source.utf8ToString()));
            if (source == null) {
                return null;
            }
            Tuple<String, String> name = NativePrivilegeStore.nameFromDocId(docId);
            if (applicationNamePredicate != null && !applicationNamePredicate.test((String)name.v1())) {
                return null;
            }
            XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, (BytesReference)source, (XContentType)XContentType.JSON);
            try {
                ApplicationPrivilegeDescriptor privilege = ApplicationPrivilegeDescriptor.parse((XContentParser)parser, null, null, (boolean)true);
                assert (privilege.getApplication().equals(name.v1())) : "Incorrect application name for privilege. Expected [" + (String)name.v1() + "] but was " + privilege.getApplication();
                assert (privilege.getName().equals(name.v2())) : "Incorrect name for application privilege. Expected [" + (String)name.v2() + "] but was " + privilege.getName();
                applicationPrivilegeDescriptor = privilege;
                if (parser == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XContentParseException e) {
                    logger.error(() -> "cannot parse application privilege [" + String.valueOf(name) + "]", e);
                    return null;
                }
            }
            parser.close();
        }
        return applicationPrivilegeDescriptor;
    }

    private Set<ApplicationPrivilegeDescriptor> cachedDescriptorsForApplicationNames(Set<String> applicationNames) {
        if (this.descriptorsAndApplicationNamesCache == null) {
            return null;
        }
        HashSet<ApplicationPrivilegeDescriptor> cachedDescriptors = new HashSet<ApplicationPrivilegeDescriptor>();
        for (String applicationName : applicationNames) {
            if (applicationName.endsWith("*")) {
                return null;
            }
            Set<ApplicationPrivilegeDescriptor> descriptors = this.descriptorsAndApplicationNamesCache.getApplicationDescriptors(applicationName);
            if (descriptors == null) {
                return null;
            }
            cachedDescriptors.addAll(descriptors);
        }
        return Collections.unmodifiableSet(cachedDescriptors);
    }

    private static Collection<ApplicationPrivilegeDescriptor> filterDescriptorsForPrivilegeNames(Collection<ApplicationPrivilegeDescriptor> descriptors, Collection<String> privilegeNames) {
        if (NativePrivilegeStore.isEmpty(privilegeNames)) {
            return descriptors;
        }
        return descriptors.stream().filter(d -> privilegeNames.contains(d.getName())).collect(Collectors.toUnmodifiableSet());
    }

    protected void cacheFetchedDescriptors(Set<String> applicationNamesCacheKey, Map<String, Set<ApplicationPrivilegeDescriptor>> mapOfFetchedDescriptors, long invalidationCount) {
        this.descriptorsAndApplicationNamesCache.putIfNoInvalidationSince(applicationNamesCacheKey, mapOfFetchedDescriptors, invalidationCount);
    }

    public void putPrivileges(Collection<ApplicationPrivilegeDescriptor> privileges, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<Map<String, Map<String, DocWriteResponse.Result>>> listener) {
        if (privileges.isEmpty()) {
            listener.onResponse(Map.of());
            return;
        }
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        bulkRequestBuilder.setRefreshPolicy(refreshPolicy);
        try {
            for (ApplicationPrivilegeDescriptor privilege : privileges) {
                bulkRequestBuilder.add(this.preparePutPrivilege(privilege));
            }
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
        this.securityIndexManager.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)bulkRequestBuilder.request(), (ActionListener)ActionListener.wrap(bulkResponse -> this.handleBulkResponse((BulkResponse)bulkResponse, listener), ex -> {
            logger.warn(org.elasticsearch.common.Strings.format((String)"Failed to write application privileges to %s", (Object[])new Object[]{this.securityIndexManager.aliasName()}), (Throwable)ex);
            listener.onFailure(ex);
        }), (arg_0, arg_1) -> ((Client)this.client).bulk(arg_0, arg_1)));
    }

    private IndexRequest preparePutPrivilege(ApplicationPrivilegeDescriptor privilege) throws IOException {
        try {
            String name = privilege.getName();
            XContentBuilder xContentBuilder = privilege.toXContent(XContentFactory.jsonBuilder(), true);
            return this.client.prepareIndex(".security").setId(NativePrivilegeStore.toDocId(privilege.getApplication(), name)).setSource(xContentBuilder).request();
        }
        catch (IOException e) {
            logger.warn("Failed to build application privilege {} - {}", (Object)org.elasticsearch.common.Strings.toString((ToXContent)privilege), (Object)e.toString());
            throw e;
        }
    }

    private void handleBulkResponse(BulkResponse bulkResponse, ActionListener<Map<String, Map<String, DocWriteResponse.Result>>> listener) {
        ElasticsearchException failure = null;
        HashMap<String, HashMap<String, DocWriteResponse.Result>> privilegeResultByAppName = new HashMap<String, HashMap<String, DocWriteResponse.Result>>();
        for (BulkItemResponse item : bulkResponse.getItems()) {
            if (item.isFailed()) {
                if (failure == null) {
                    failure = new ElasticsearchException("Failed to put application privileges", (Throwable)item.getFailure().getCause(), new Object[0]);
                    continue;
                }
                failure.addSuppressed((Throwable)item.getFailure().getCause());
                continue;
            }
            Tuple<String, String> name = NativePrivilegeStore.nameFromDocId(item.getId());
            String appName = (String)name.v1();
            String privilegeName = (String)name.v2();
            HashMap<String, DocWriteResponse.Result> privileges = (HashMap<String, DocWriteResponse.Result>)privilegeResultByAppName.get(appName);
            if (privileges == null) {
                privileges = new HashMap<String, DocWriteResponse.Result>();
                privilegeResultByAppName.put(appName, privileges);
            }
            privileges.put(privilegeName, item.getResponse().getResult());
        }
        if (failure != null) {
            listener.onFailure(failure);
        } else {
            this.clearCaches(listener, privilegeResultByAppName.keySet(), privilegeResultByAppName);
        }
    }

    public void deletePrivileges(String application, Collection<String> names, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<Map<String, List<String>>> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndexManager.defensiveCopy();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse(Collections.emptyMap());
        } else if (!frozenSecurityIndex.isAvailable(SecurityIndexManager.Availability.PRIMARY_SHARDS)) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.PRIMARY_SHARDS)));
        } else {
            this.securityIndexManager.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                GroupedActionListener groupListener = new GroupedActionListener(names.size(), ActionListener.wrap(responses -> {
                    Map<String, List<String>> deletedNames = responses.stream().filter(r -> r.getResult() == DocWriteResponse.Result.DELETED).map(r -> r.getId()).map(NativePrivilegeStore::nameFromDocId).collect(TUPLES_TO_MAP);
                    this.clearCaches(listener, Collections.singleton(application), deletedNames);
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                for (String name : names) {
                    ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)this.client.prepareDelete(".security", NativePrivilegeStore.toDocId(application, name)).setRefreshPolicy(refreshPolicy).request(), (ActionListener)groupListener, (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1));
                }
            });
        }
    }

    private <T> void clearCaches(final ActionListener<T> listener, Set<String> applicationNames, final T value) {
        ClearPrivilegesCacheRequest request = new ClearPrivilegesCacheRequest().applicationNames((String[])applicationNames.toArray(String[]::new)).clearRolesCache(true);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)ClearPrivilegesCacheAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<ClearPrivilegesCacheResponse>(){

            public void onResponse(ClearPrivilegesCacheResponse nodes) {
                listener.onResponse(value);
            }

            public void onFailure(Exception e) {
                logger.error("unable to clear application privileges and role cache", (Throwable)e);
                listener.onFailure((Exception)((Object)new ElasticsearchException("clearing the application privileges and role cache failed, please clear the caches manually", (Throwable)e, new Object[0])));
            }
        });
    }

    private static Tuple<String, String> nameFromDocId(String docId) {
        String name = docId.substring("application-privilege".length() + 1);
        assert (name != null && name.length() > 0) : "Invalid name '" + name + "'";
        int colon = name.indexOf(58);
        assert (colon > 0) : "Invalid name '" + name + "' (missing colon)";
        return new Tuple((Object)name.substring(0, colon), (Object)name.substring(colon + 1));
    }

    private static String toDocId(String application, String name) {
        return "application-privilege_" + application + ":" + name;
    }

    private static boolean isEmpty(Collection<String> collection) {
        return collection == null || collection.isEmpty();
    }

    DescriptorsAndApplicationNamesCache getDescriptorsAndApplicationNamesCache() {
        return this.descriptorsAndApplicationNamesCache;
    }

    Cache<Set<String>, Set<String>> getApplicationNamesCache() {
        return this.descriptorsAndApplicationNamesCache == null ? null : this.descriptorsAndApplicationNamesCache.applicationNamesCache;
    }

    Cache<String, Set<ApplicationPrivilegeDescriptor>> getDescriptorsCache() {
        return this.descriptorsAndApplicationNamesCache == null ? null : this.descriptorsAndApplicationNamesCache.descriptorsCache;
    }

    long getNumInvalidation() {
        return this.descriptorsAndApplicationNamesCache.getInvalidationCount();
    }

    private static /* synthetic */ Object lambda$innerGetPrivileges$3(Collection applications, QueryBuilder query) {
        return Strings.format((String)"Searching for [%s] privileges with query [%s]", (Object[])new Object[]{applications, org.elasticsearch.common.Strings.toString((ToXContent)query)});
    }

    static final class DescriptorsAndApplicationNamesCache
    implements CacheInvalidatorRegistry.CacheInvalidator {
        private final Cache<String, Set<ApplicationPrivilegeDescriptor>> descriptorsCache;
        private final Cache<Set<String>, Set<String>> applicationNamesCache;
        private final LockingAtomicCounter lockingAtomicCounter;

        DescriptorsAndApplicationNamesCache(TimeValue ttl, int cacheSize) {
            this.descriptorsCache = CacheBuilder.builder().setMaximumWeight((long)cacheSize).weigher((k, v) -> v.size()).setExpireAfterWrite(ttl).build();
            this.applicationNamesCache = CacheBuilder.builder().setMaximumWeight((long)cacheSize).weigher((k, v) -> k.size() + v.size()).setExpireAfterWrite(ttl).build();
            this.lockingAtomicCounter = new LockingAtomicCounter();
        }

        public Set<ApplicationPrivilegeDescriptor> getApplicationDescriptors(String applicationName) {
            return (Set)this.descriptorsCache.get((Object)applicationName);
        }

        public Set<String> getConcreteApplicationNames(Set<String> applicationNames) {
            return (Set)this.applicationNamesCache.get(applicationNames);
        }

        public void putIfNoInvalidationSince(Set<String> applicationNamesCacheKey, Map<String, Set<ApplicationPrivilegeDescriptor>> mapOfFetchedDescriptors, long invalidationCount) {
            this.lockingAtomicCounter.compareAndRun(invalidationCount, () -> {
                Set fetchedApplicationNames = Collections.unmodifiableSet(mapOfFetchedDescriptors.keySet());
                if (!fetchedApplicationNames.equals(applicationNamesCacheKey)) {
                    logger.debug("Caching application names query: {} = {}", (Object)applicationNamesCacheKey, fetchedApplicationNames);
                    this.applicationNamesCache.put((Object)applicationNamesCacheKey, fetchedApplicationNames);
                }
                for (Map.Entry entry : mapOfFetchedDescriptors.entrySet()) {
                    logger.debug("Caching descriptors for application: {}", entry.getKey());
                    this.descriptorsCache.put((Object)((String)entry.getKey()), (Object)((Set)entry.getValue()));
                }
            });
        }

        public long getInvalidationCount() {
            return this.lockingAtomicCounter.get();
        }

        @Override
        public void invalidate(Collection<String> updatedApplicationNames) {
            this.lockingAtomicCounter.increment();
            logger.debug("Invalidating application privileges caches for: {}", updatedApplicationNames);
            Set<String> uniqueNames = Set.copyOf(updatedApplicationNames);
            this.applicationNamesCache.invalidateAll();
            updatedApplicationNames.forEach(arg_0 -> this.descriptorsCache.invalidate(arg_0));
        }

        @Override
        public void invalidateAll() {
            this.lockingAtomicCounter.increment();
            logger.debug("Invalidating all application privileges caches");
            this.applicationNamesCache.invalidateAll();
            this.descriptorsCache.invalidateAll();
        }
    }
}

