/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.helpers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sonarsource.analyzer.commons.regex.ast.AutomatonState;
import org.sonarsource.analyzer.commons.regex.ast.BoundaryTree;
import org.sonarsource.analyzer.commons.regex.ast.CharacterTree;
import org.sonarsource.analyzer.commons.regex.ast.DotTree;
import org.sonarsource.analyzer.commons.regex.ast.EndOfLookaroundState;
import org.sonarsource.analyzer.commons.regex.ast.LookAroundTree;

public class RegexReachabilityChecker {
    private static final int MAX_CACHE_SIZE = 5000;
    private final boolean defaultAnswer;
    private final Map<OrderedStatePair, Boolean> cache = new HashMap<OrderedStatePair, Boolean>();
    private static final List<BoundaryTree.Type> TYPE_ENDINGS = Arrays.asList(BoundaryTree.Type.INPUT_END_FINAL_TERMINATOR, BoundaryTree.Type.LINE_END);

    public RegexReachabilityChecker(boolean defaultAnswer) {
        this.defaultAnswer = defaultAnswer;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public boolean canReach(AutomatonState start, AutomatonState goal) {
        if (start == goal) {
            return true;
        }
        OrderedStatePair pair = new OrderedStatePair(start, goal);
        if (this.cache.containsKey(pair)) {
            return this.cache.get(pair);
        }
        if (this.cache.size() >= 5000) {
            return this.defaultAnswer;
        }
        this.cache.put(pair, false);
        boolean result = false;
        for (AutomatonState automatonState : start.successors()) {
            if (!this.canReach(automatonState, goal)) continue;
            result = true;
            break;
        }
        this.cache.put(pair, result);
        return result;
    }

    public boolean canReachWithConsumingInput(AutomatonState start, AutomatonState goal, Set<AutomatonState> visited) {
        if (start == goal || visited.contains(start)) {
            return false;
        }
        visited.add(start);
        if (start instanceof LookAroundTree) {
            return this.canReachWithConsumingInput(start.continuation(), goal, visited);
        }
        for (AutomatonState automatonState : start.successors()) {
            AutomatonState.TransitionType transition = automatonState.incomingTransitionType();
            if ((transition != AutomatonState.TransitionType.CHARACTER || RegexReachabilityChecker.isLineBreakOrPeriodAfterEndBoundaries(visited, automatonState) || !this.canReach(automatonState, goal)) && (transition == AutomatonState.TransitionType.CHARACTER || !this.canReachWithConsumingInput(automatonState, goal, visited))) continue;
            return true;
        }
        return false;
    }

    public static boolean canReachWithoutConsumingInput(AutomatonState start, AutomatonState goal) {
        return RegexReachabilityChecker.canReachWithoutConsumingInput(start, goal, false, new HashSet<AutomatonState>());
    }

    public static boolean canReachWithoutConsumingInputNorCrossingBoundaries(AutomatonState start, AutomatonState goal) {
        return RegexReachabilityChecker.canReachWithoutConsumingInput(start, goal, true, new HashSet<AutomatonState>());
    }

    private static boolean canReachWithoutConsumingInput(AutomatonState start, AutomatonState goal, boolean stopAtBoundaries, Set<AutomatonState> visited) {
        if (start == goal) {
            return true;
        }
        if (visited.contains(start) || stopAtBoundaries && start instanceof BoundaryTree) {
            return false;
        }
        visited.add(start);
        for (AutomatonState automatonState : start.successors()) {
            AutomatonState.TransitionType transition = automatonState.incomingTransitionType();
            if ((!(automatonState instanceof EndOfLookaroundState) || automatonState != goal) && (transition != AutomatonState.TransitionType.EPSILON && transition != AutomatonState.TransitionType.NEGATION && !RegexReachabilityChecker.isLineBreakOrPeriodAfterEndBoundaries(visited, automatonState) || !RegexReachabilityChecker.canReachWithoutConsumingInput(automatonState, goal, stopAtBoundaries, visited))) continue;
            return true;
        }
        return false;
    }

    private static boolean isLineBreakOrPeriodAfterEndBoundaries(Set<AutomatonState> visited, AutomatonState currentState) {
        block3: {
            block2: {
                if (RegexReachabilityChecker.isEscapeSequence(currentState)) break block2;
                if (!RegexReachabilityChecker.isDotall(currentState)) break block3;
            }
            return visited.stream().filter(BoundaryTree.class::isInstance).map(state -> ((BoundaryTree)state).type()).anyMatch(TYPE_ENDINGS::contains);
        }
        return false;
    }

    private static boolean isEscapeSequence(AutomatonState state) {
        return state instanceof CharacterTree && ((CharacterTree)state).isEscapeSequence();
    }

    private static boolean isDotall(AutomatonState currentState) {
        return currentState instanceof DotTree && currentState.activeFlags().contains(32);
    }

    private static class OrderedStatePair {
        private final AutomatonState source;
        private final AutomatonState target;

        OrderedStatePair(AutomatonState source, AutomatonState target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OrderedStatePair)) {
                return false;
            }
            OrderedStatePair that = (OrderedStatePair)o;
            return this.source == that.source && this.target == that.target;
        }

        public int hashCode() {
            return Objects.hash(this.source, this.target);
        }
    }
}

