/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.phpunit.xml;

public final class TestCase {
    private String className;
    private String name;
    private String error;
    private String failure;
    private String skipped;

    public TestCase(String className, String name, String error, String failure, String skipped) {
        this.className = className;
        this.name = name;
        this.error = error;
        this.failure = failure;
        this.skipped = skipped;
    }

    public TestCase(Status status) {
        if (status == Status.ERROR) {
            this.error = status.toString();
        }
        if (status == Status.FAILURE) {
            this.failure = status.toString();
        }
        if (status == Status.SKIPPED) {
            this.skipped = Status.SKIPPED.toString();
        }
    }

    public Status getStatus() {
        if (this.error != null && !this.error.isBlank()) {
            return Status.ERROR;
        }
        if (this.failure != null && !this.failure.isBlank()) {
            return Status.FAILURE;
        }
        if (this.skipped != null) {
            return Status.SKIPPED;
        }
        return Status.OK;
    }

    public String toString() {
        return "%s@%s[className=%s,name=%s,status=%s]".formatted(new Object[]{this.getClass().getName(), Integer.toHexString(System.identityHashCode(this)), this.className, this.name, this.getStatus()});
    }

    String fullName() {
        if (this.className != null) {
            return this.className + "." + this.name;
        }
        return this.name;
    }

    public static enum Status {
        OK,
        SKIPPED,
        FAILURE,
        ERROR;

    }
}

