/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.phpunit;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.php.reports.phpunit.JUnitLogParserForPhpUnit;
import org.sonar.plugins.php.reports.phpunit.ParseException;
import org.sonar.plugins.php.reports.phpunit.PhpUnitReportImporter;
import org.sonar.plugins.php.reports.phpunit.TestFileReport;
import org.sonar.plugins.php.reports.phpunit.xml.TestSuites;
import org.sonar.plugins.php.warning.AnalysisWarningsWrapper;

public class TestResultImporter
extends PhpUnitReportImporter {
    private static final Logger LOG = LoggerFactory.getLogger(TestResultImporter.class);
    private static final String TEST_REPORT_DOES_NOT_CONTAIN_ANY_RECORD = "PHPUnit test report does not contain any record in file %s.";
    private final JUnitLogParserForPhpUnit parser = new JUnitLogParserForPhpUnit();

    public TestResultImporter(AnalysisWarningsWrapper analysisWarningsWrapper) {
        super(analysisWarningsWrapper);
    }

    @Override
    public void importReport(File report, SensorContext context) throws ParseException, IOException {
        LOG.info("Importing {}", (Object)report);
        TestSuites testSuites = this.parser.parse(report);
        List<TestFileReport> testFileReports = testSuites.arrangeSuitesIntoTestFileReports();
        if (testFileReports.isEmpty()) {
            this.createWarning(TEST_REPORT_DOES_NOT_CONTAIN_ANY_RECORD, report);
        } else {
            this.saveTestReports(context, testFileReports);
        }
    }

    private void saveTestReports(SensorContext context, List<TestFileReport> testFileReports) {
        for (TestFileReport fileReport : testFileReports) {
            fileReport.saveTestMeasures(context, this.fileHandler, x$0 -> this.addUnresolvedInputFile((String)x$0));
        }
    }

    @Override
    public String reportPathKey() {
        return "sonar.php.tests.reportPath";
    }

    @Override
    public String reportName() {
        return "PHPUnit tests";
    }

    @Override
    public Logger logger() {
        return LOG;
    }
}

