/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.phpunit;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.plugins.php.reports.ExternalReportFileHandler;
import org.sonar.plugins.php.reports.phpunit.xml.TestCase;

public class TestFileReport {
    private int errors = 0;
    private int failures = 0;
    private String file;
    private int skipped = 0;
    private int tests = 0;
    private double testDuration = 0.0;

    public TestFileReport(String file, double testDuration) {
        this.file = file;
        this.testDuration = testDuration;
    }

    public void saveTestMeasures(SensorContext context, ExternalReportFileHandler fileHandler, Consumer<String> addUnresolvedInputFiles) {
        this.file = fileHandler.relativePath(this.file);
        InputFile unitTestFile = this.getUnitTestInputFile(context.fileSystem());
        if (unitTestFile != null) {
            context.newMeasure().on((InputComponent)unitTestFile).withValue((Serializable)Integer.valueOf(this.skipped)).forMetric((Metric)CoreMetrics.SKIPPED_TESTS).save();
            context.newMeasure().on((InputComponent)unitTestFile).withValue((Serializable)Long.valueOf((long)this.testDurationMilliseconds())).forMetric((Metric)CoreMetrics.TEST_EXECUTION_TIME).save();
            context.newMeasure().on((InputComponent)unitTestFile).withValue((Serializable)Integer.valueOf((int)this.liveTests())).forMetric((Metric)CoreMetrics.TESTS).save();
            context.newMeasure().on((InputComponent)unitTestFile).withValue((Serializable)Integer.valueOf(this.errors)).forMetric((Metric)CoreMetrics.TEST_ERRORS).save();
            context.newMeasure().on((InputComponent)unitTestFile).withValue((Serializable)Integer.valueOf(this.failures)).forMetric((Metric)CoreMetrics.TEST_FAILURES).save();
        } else {
            addUnresolvedInputFiles.accept(this.file);
        }
    }

    private double liveTests() {
        return (double)this.tests - (double)this.skipped;
    }

    public double testDurationMilliseconds() {
        return this.testDuration * 1000.0;
    }

    private InputFile getUnitTestInputFile(FileSystem fileSystem) {
        FilePredicates predicates = fileSystem.predicates();
        return fileSystem.inputFile(predicates.and(new FilePredicate[]{predicates.hasPath(this.file), predicates.hasType(InputFile.Type.TEST), predicates.hasLanguage("php")}));
    }

    public void addTestCase(TestCase testCase) {
        if (testCase.getStatus() == TestCase.Status.SKIPPED) {
            ++this.skipped;
        } else if (testCase.getStatus() == TestCase.Status.FAILURE) {
            ++this.failures;
        } else if (testCase.getStatus() == TestCase.Status.ERROR) {
            ++this.errors;
        }
        ++this.tests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestFileReport that = (TestFileReport)o;
        return this.errors == that.errors && this.failures == that.failures && this.skipped == that.skipped && this.tests == that.tests && this.testDuration == that.testDuration && Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.failures, this.file, this.skipped, this.tests, this.testDuration);
    }

    public String toString() {
        return "%s@%s[errors=%s,failures=%s,file=%s,skipped=%s,tests=%s,testDuration=%s]".formatted(this.getClass().getName(), Integer.toHexString(System.identityHashCode(this)), this.errors, this.failures, this.file, this.skipped, this.tests, this.testDuration);
    }

    public int getTests() {
        return this.tests;
    }
}

