/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.SonarEdition;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.config.Configuration;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rules.RuleType;
import org.sonar.plugins.php.reports.AbstractExternalRulesDefinition;
import org.sonar.plugins.php.reports.AbstractReportImporter;
import org.sonar.plugins.php.reports.ExternalReportWildcardProvider;
import org.sonar.plugins.php.reports.JsonReportReader;
import org.sonar.plugins.php.warning.AnalysisWarningsWrapper;
import org.sonarsource.analyzer.commons.ExternalRuleLoader;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public abstract class ExternalIssuesSensor
extends AbstractReportImporter
implements Sensor {
    protected static final Long DEFAULT_CONSTANT_DEBT_MINUTES = 5L;
    private static final RuleType DEFAULT_RULE_TYPE = RuleType.CODE_SMELL;
    private static final Severity DEFAULT_RULE_SEVERITY = Severity.MAJOR;
    private static final String READ_ERROR_MSG_FORMAT = "An error occurred when reading report file '%s', no issue will be imported from this report.\n%s";
    private static final String UNRESOLVED_INPUT_FILE_MESSAGE_FORMAT = "Failed to resolve %s file path(s) in %s %s report. No issues imported related to file(s): %s";
    public final String defaultRuleId = this.reportKey() + ".finding";
    protected final ExternalRuleLoader externalRuleLoader;

    protected ExternalIssuesSensor(AbstractExternalRulesDefinition externalRulesDefinition, AnalysisWarningsWrapper analysisWarningsWrapper) {
        super(analysisWarningsWrapper);
        this.externalRuleLoader = externalRulesDefinition.getRuleLoader();
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyWhenConfiguration(this::shouldExecute).onlyOnLanguage("php").name("Import of " + this.reportName() + " issues");
    }

    @Override
    public List<File> getReportFiles(SensorContext context) {
        return ExternalReportWildcardProvider.getReportFiles(context, this.reportPathKey());
    }

    @Override
    public String getUnresolvedInputFileMessageFormat() {
        return UNRESOLVED_INPUT_FILE_MESSAGE_FORMAT;
    }

    @Override
    public String getFileReadErrorMessage(Exception e, File reportPath) {
        Object additionalMsg = e.getClass().getSimpleName() + ": " + e.getMessage() + " at " + e.getStackTrace()[0].toString();
        if (e instanceof ParseException || e instanceof ClassCastException) {
            additionalMsg = "The content of the file probably does not have the expected format.";
        } else if (e instanceof FileNotFoundException) {
            additionalMsg = "The file was not found.";
        }
        return String.format(READ_ERROR_MSG_FORMAT, reportPath, additionalMsg);
    }

    private static boolean isEmpty(@Nullable String str) {
        return str == null || str.trim().length() == 0;
    }

    @CheckForNull
    private InputFile inputFile(SensorContext context, String filePath) {
        String relativePath = this.fileHandler.relativePath(filePath);
        return context.fileSystem().inputFile(context.fileSystem().predicates().hasPath(relativePath));
    }

    protected void saveIssue(SensorContext context, JsonReportReader.Issue issue) {
        boolean isSonarCloud;
        if (ExternalIssuesSensor.isEmpty(issue.filePath) || ExternalIssuesSensor.isEmpty(issue.message)) {
            this.logger().debug("Missing information for filePath:'{}', message:'{}'", (Object)issue.filePath, (Object)issue.message);
            return;
        }
        InputFile inputFile = this.inputFile(context, issue.filePath);
        if (inputFile == null) {
            this.addUnresolvedInputFile(issue.filePath);
            return;
        }
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        RuleType ruleType = ExternalIssuesSensor.toType(issue.type);
        Severity ruleSeverity = ExternalIssuesSensor.toRuleSeverity(issue.severity);
        boolean bl = isSonarCloud = context.runtime().getProduct() == SonarProduct.SONARQUBE && context.runtime().getEdition() == SonarEdition.SONARCLOUD;
        if (!isSonarCloud) {
            newExternalIssue.addImpact(ExternalIssuesSensor.toSoftwareQuality(ruleType), ExternalIssuesSensor.toImpactSeverity(ruleSeverity));
        }
        newExternalIssue.remediationEffortMinutes(DEFAULT_CONSTANT_DEBT_MINUTES).severity(ruleSeverity).type(ruleType);
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(issue.message).on((InputComponent)inputFile);
        ExternalIssuesSensor.refinePrimaryLocation(primaryLocation, issue, inputFile);
        newExternalIssue.at(primaryLocation);
        newExternalIssue.engineId(this.reportKey()).ruleId(this.toRuleId(issue.ruleId));
        newExternalIssue.save();
    }

    private static RuleType toType(@Nullable String type) {
        if (type != null) {
            return switch (type) {
                case "BUG" -> RuleType.BUG;
                case "SECURITY_HOTSPOT" -> RuleType.SECURITY_HOTSPOT;
                case "VULNERABILITY" -> RuleType.VULNERABILITY;
                case "CODE_SMELL" -> RuleType.CODE_SMELL;
                default -> DEFAULT_RULE_TYPE;
            };
        }
        return DEFAULT_RULE_TYPE;
    }

    private static Severity toRuleSeverity(@Nullable String severity) {
        if (severity != null) {
            return switch (severity) {
                case "INFO" -> Severity.INFO;
                case "MINOR" -> Severity.MINOR;
                case "MAJOR" -> Severity.MAJOR;
                case "CRITICAL" -> Severity.CRITICAL;
                case "BLOCKER" -> Severity.BLOCKER;
                default -> DEFAULT_RULE_SEVERITY;
            };
        }
        return DEFAULT_RULE_SEVERITY;
    }

    private static SoftwareQuality toSoftwareQuality(RuleType ruleType) {
        return switch (ruleType) {
            default -> throw new IncompatibleClassChangeError();
            case RuleType.BUG -> SoftwareQuality.RELIABILITY;
            case RuleType.SECURITY_HOTSPOT, RuleType.VULNERABILITY -> SoftwareQuality.SECURITY;
            case RuleType.CODE_SMELL -> SoftwareQuality.MAINTAINABILITY;
        };
    }

    private static org.sonar.api.issue.impact.Severity toImpactSeverity(Severity ruleSeverity) {
        return switch (ruleSeverity) {
            default -> throw new IncompatibleClassChangeError();
            case Severity.INFO, Severity.MINOR -> org.sonar.api.issue.impact.Severity.LOW;
            case Severity.MAJOR -> org.sonar.api.issue.impact.Severity.MEDIUM;
            case Severity.CRITICAL, Severity.BLOCKER -> org.sonar.api.issue.impact.Severity.HIGH;
        };
    }

    private String toRuleId(@Nullable String ruleId) {
        if (ruleId != null && this.externalRuleLoader.ruleKeys().contains(ruleId)) {
            return ruleId;
        }
        return this.defaultRuleId;
    }

    private static void refinePrimaryLocation(NewIssueLocation primaryLocation, JsonReportReader.Issue issue, InputFile inputFile) {
        if (issue.startLine == null) {
            return;
        }
        if (issue.startColumn != null && issue.startColumn < inputFile.selectLine(issue.startLine.intValue()).end().lineOffset()) {
            int endLine = issue.startLine;
            int endColumn = issue.startColumn + 1;
            if (issue.endLine != null && issue.endColumn != null && issue.endColumn <= inputFile.selectLine(issue.endLine.intValue()).end().lineOffset()) {
                endLine = issue.endLine;
                endColumn = issue.endColumn;
            }
            primaryLocation.at(inputFile.newRange(issue.startLine.intValue(), issue.startColumn.intValue(), endLine, endColumn));
        } else {
            primaryLocation.at(inputFile.selectLine(issue.startLine.intValue()));
        }
    }

    protected boolean shouldExecute(Configuration conf) {
        return conf.hasKey(this.reportPathKey());
    }

    protected abstract String reportKey();
}

