/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.api.visitors;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.symbols.UnknownLocationInFile;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.visitors.IssueLocation;
import org.sonar.plugins.php.api.visitors.LocationInFile;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PhpIssue;

public class PreciseIssue
implements PhpIssue {
    private final PHPCheck check;
    private Double cost;
    private final IssueLocation primaryLocation;
    private final List<IssueLocation> secondaryLocations;

    public PreciseIssue(PHPCheck check, IssueLocation primaryLocation) {
        this.check = check;
        this.primaryLocation = primaryLocation;
        this.cost = null;
        this.secondaryLocations = new ArrayList<IssueLocation>();
    }

    public IssueLocation primaryLocation() {
        return this.primaryLocation;
    }

    public List<IssueLocation> secondaryLocations() {
        return this.secondaryLocations;
    }

    public PreciseIssue secondary(Tree tree, @Nullable String message) {
        return this.secondary(new IssueLocation(tree, message));
    }

    public PreciseIssue secondary(Tree startTree, Tree endTree, @Nullable String message) {
        return this.secondary(new IssueLocation(startTree, endTree, message));
    }

    public PreciseIssue secondary(LocationInFile locationInFile, @Nullable String message) {
        if (locationInFile == UnknownLocationInFile.UNKNOWN_LOCATION) {
            return this;
        }
        return this.secondary(new IssueLocation(locationInFile, message));
    }

    public PreciseIssue secondary(IssueLocation issueLocation) {
        this.secondaryLocations.add(issueLocation);
        return this;
    }

    @Override
    public PHPCheck check() {
        return this.check;
    }

    @Override
    @Nullable
    public Double cost() {
        return this.cost;
    }

    @Override
    public PreciseIssue cost(double cost) {
        this.cost = cost;
        return this;
    }
}

