/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.api.cfg;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.utils.Preconditions;
import org.sonar.plugins.php.api.cfg.CfgBlock;
import org.sonar.plugins.php.api.tree.Tree;

class PhpCfgBlock
implements CfgBlock {
    private Set<PhpCfgBlock> predecessors = new HashSet<PhpCfgBlock>();
    private Set<CfgBlock> successors;
    private CfgBlock syntacticSuccessor;
    private LinkedList<Tree> elements = new LinkedList();

    private PhpCfgBlock(Set<PhpCfgBlock> successors, @Nullable PhpCfgBlock syntacticSuccessor) {
        this.successors = Collections.unmodifiableSet(successors);
        this.syntacticSuccessor = syntacticSuccessor;
    }

    PhpCfgBlock(PhpCfgBlock successor, PhpCfgBlock syntacticSuccessor) {
        this(Set.of(successor), syntacticSuccessor);
    }

    PhpCfgBlock(Set<PhpCfgBlock> successors) {
        this(successors, null);
    }

    PhpCfgBlock(PhpCfgBlock successor) {
        this(Set.of(successor));
    }

    PhpCfgBlock() {
    }

    @Override
    public Set<CfgBlock> predecessors() {
        return Collections.unmodifiableSet(this.predecessors);
    }

    @Override
    public Set<CfgBlock> successors() {
        return this.successors;
    }

    @Override
    @Nullable
    public CfgBlock syntacticSuccessor() {
        return this.syntacticSuccessor;
    }

    @Override
    public List<Tree> elements() {
        return Collections.unmodifiableList(this.elements);
    }

    public void addElement(Tree element) {
        Preconditions.checkArgument((element != null ? 1 : 0) != 0, (String)"Cannot add a null element to a block");
        this.elements.addFirst(element);
    }

    void replaceSuccessors(Map<PhpCfgBlock, PhpCfgBlock> replacements) {
        this.successors = this.successors.stream().map(successor -> PhpCfgBlock.replacement(successor, replacements)).collect(Collectors.toSet());
        if (this.syntacticSuccessor != null) {
            this.syntacticSuccessor = PhpCfgBlock.replacement(this.syntacticSuccessor, replacements);
        }
    }

    void replaceSuccessor(PhpCfgBlock oldSucc, PhpCfgBlock newSucc) {
        HashMap<PhpCfgBlock, PhpCfgBlock> map = new HashMap<PhpCfgBlock, PhpCfgBlock>();
        map.put(oldSucc, newSucc);
        this.replaceSuccessors(map);
    }

    static CfgBlock replacement(CfgBlock successor, Map<PhpCfgBlock, PhpCfgBlock> replacements) {
        PhpCfgBlock newSuccessor = replacements.get(successor);
        return newSuccessor == null ? successor : newSuccessor;
    }

    void addPredecessor(PhpCfgBlock predecessor) {
        this.predecessors.add(predecessor);
    }

    PhpCfgBlock skipEmptyBlocks() {
        HashSet<PhpCfgBlock> skippedBlocks = new HashSet<PhpCfgBlock>();
        PhpCfgBlock block = this;
        while (block.successors().size() == 1 && block.elements().isEmpty()) {
            PhpCfgBlock next = (PhpCfgBlock)block.successors().iterator().next();
            skippedBlocks.add(block);
            if (!skippedBlocks.contains(next)) {
                block = next;
                continue;
            }
            return block;
        }
        return block;
    }

    public String toString() {
        if (this.elements.isEmpty()) {
            return "empty";
        }
        Tree firstElement = this.elements.get(0);
        if (firstElement.is(Tree.Kind.LABEL)) {
            firstElement = this.elements.get(1);
        }
        return firstElement.toString();
    }
}

