/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.api.cfg;

import com.sonar.sslr.api.RecognitionException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.utils.Preconditions;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.utils.LiteralUtils;
import org.sonar.php.utils.collections.ListUtils;
import org.sonar.plugins.php.api.cfg.CfgBlock;
import org.sonar.plugins.php.api.cfg.ControlFlowGraph;
import org.sonar.plugins.php.api.cfg.PhpCfgBlock;
import org.sonar.plugins.php.api.cfg.PhpCfgBranchingBlock;
import org.sonar.plugins.php.api.cfg.PhpCfgEndBlock;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.php.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.php.api.tree.statement.DeclareStatementTree;
import org.sonar.plugins.php.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.GotoStatementTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.LabelTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchCaseClauseTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.php.api.tree.statement.TryStatementTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;

class ControlFlowGraphBuilder {
    private final Set<PhpCfgBlock> blocks = new HashSet<PhpCfgBlock>();
    private final PhpCfgEndBlock end = new PhpCfgEndBlock();
    private final LinkedList<Breakable> breakables = new LinkedList();
    private final Deque<PhpCfgBlock> throwTargets = new ArrayDeque<PhpCfgBlock>();
    private final Deque<TryBodyEnd> exitTargets = new LinkedList<TryBodyEnd>();
    private final Map<String, PhpCfgBlock> labelledBlocks = new HashMap<String, PhpCfgBlock>();
    private final Map<String, List<PhpCfgBlock>> gotosWithoutTarget = new HashMap<String, List<PhpCfgBlock>>();
    private PhpCfgBlock start;

    ControlFlowGraphBuilder(List<? extends Tree> items) {
        this.throwTargets.push(this.end);
        this.exitTargets.push(new TryBodyEnd(this.end, this.end));
        this.start = this.build(items, this.createSimpleBlock(this.end));
        this.removeEmptyBlocks();
        this.blocks.add(this.end);
        this.computePredecessors();
    }

    ControlFlowGraph getGraph() {
        return new ControlFlowGraph(new HashSet<CfgBlock>(this.blocks), this.start, this.end);
    }

    private void computePredecessors() {
        for (PhpCfgBlock block : this.blocks) {
            for (CfgBlock successor : block.successors()) {
                ((PhpCfgBlock)successor).addPredecessor(block);
            }
        }
    }

    private void removeEmptyBlocks() {
        HashMap<PhpCfgBlock, PhpCfgBlock> emptyBlockReplacements = new HashMap<PhpCfgBlock, PhpCfgBlock>();
        for (PhpCfgBlock block : this.blocks) {
            if (!block.elements().isEmpty() || block.successors().size() != 1) continue;
            PhpCfgBlock firstNonEmptySuccessor = block.skipEmptyBlocks();
            emptyBlockReplacements.put(block, firstNonEmptySuccessor);
        }
        this.blocks.removeAll(emptyBlockReplacements.keySet());
        for (PhpCfgBlock block : this.blocks) {
            block.replaceSuccessors(emptyBlockReplacements);
        }
        this.start = emptyBlockReplacements.getOrDefault(this.start, this.start);
    }

    private PhpCfgBlock build(List<? extends Tree> trees, PhpCfgBlock successor) {
        PhpCfgBlock currentBlock = successor;
        for (Tree tree : ListUtils.reverse(trees)) {
            currentBlock = this.build(tree, currentBlock);
        }
        return currentBlock;
    }

    private PhpCfgBlock build(Tree tree, PhpCfgBlock currentBlock) {
        return switch (tree.getKind()) {
            case Tree.Kind.TRY_STATEMENT -> this.buildTryStatement((TryStatementTree)tree, currentBlock);
            case Tree.Kind.THROW_STATEMENT -> this.buildThrowStatement((ThrowStatementTree)tree, currentBlock);
            case Tree.Kind.RETURN_STATEMENT -> this.buildReturnStatement((ReturnStatementTree)tree, currentBlock);
            case Tree.Kind.BREAK_STATEMENT -> this.buildBreakStatement((BreakStatementTree)tree, currentBlock);
            case Tree.Kind.CONTINUE_STATEMENT -> this.buildContinueStatement((ContinueStatementTree)tree, currentBlock);
            case Tree.Kind.GOTO_STATEMENT -> this.buildGotoStatement((GotoStatementTree)tree, currentBlock);
            case Tree.Kind.DO_WHILE_STATEMENT -> this.buildDoWhileStatement((DoWhileStatementTree)tree, currentBlock);
            case Tree.Kind.WHILE_STATEMENT, Tree.Kind.ALTERNATIVE_WHILE_STATEMENT -> this.buildWhileStatement((WhileStatementTree)tree, currentBlock);
            case Tree.Kind.IF_STATEMENT, Tree.Kind.ALTERNATIVE_IF_STATEMENT -> this.buildIfStatement((IfStatementTree)tree, currentBlock);
            case Tree.Kind.FOR_STATEMENT, Tree.Kind.ALTERNATIVE_FOR_STATEMENT -> this.buildForStatement((ForStatementTree)tree, currentBlock);
            case Tree.Kind.FOREACH_STATEMENT, Tree.Kind.ALTERNATIVE_FOREACH_STATEMENT -> this.buildForEachStatement((ForEachStatementTree)tree, currentBlock);
            case Tree.Kind.BLOCK -> this.buildBlock((BlockTree)tree, currentBlock);
            case Tree.Kind.SWITCH_STATEMENT, Tree.Kind.ALTERNATIVE_SWITCH_STATEMENT -> this.buildSwitchStatement((SwitchStatementTree)tree, currentBlock);
            case Tree.Kind.LABEL -> this.createLabelBlock((LabelTree)tree, currentBlock);
            case Tree.Kind.DECLARE_STATEMENT -> this.buildDeclareStatement((DeclareStatementTree)tree, currentBlock);
            case Tree.Kind.GLOBAL_STATEMENT, Tree.Kind.STATIC_STATEMENT, Tree.Kind.UNSET_VARIABLE_STATEMENT, Tree.Kind.EXPRESSION_LIST_STATEMENT, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.USE_STATEMENT, Tree.Kind.GROUP_USE_STATEMENT, Tree.Kind.CONSTANT_DECLARATION, Tree.Kind.NAMESPACE_STATEMENT, Tree.Kind.INLINE_HTML, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.ECHO_TAG_STATEMENT -> {
                currentBlock.addElement(tree);
                yield currentBlock;
            }
            case Tree.Kind.TRAIT_DECLARATION, Tree.Kind.INTERFACE_DECLARATION, Tree.Kind.CLASS_DECLARATION, Tree.Kind.EMPTY_STATEMENT, Tree.Kind.ENUM_DECLARATION -> currentBlock;
            default -> throw new UnsupportedOperationException("Not supported tree kind " + String.valueOf(tree.getKind()));
        };
    }

    private PhpCfgBlock buildDeclareStatement(DeclareStatementTree declare, PhpCfgBlock successor) {
        List<StatementTree> statements = declare.statements();
        if (statements.isEmpty()) {
            successor.addElement(declare);
            return successor;
        }
        return this.build(statements, successor);
    }

    private PhpCfgBlock buildSwitchStatement(SwitchStatementTree tree, PhpCfgBlock successor) {
        ForwardingBlock defaultBlock = this.createForwardingBlock();
        defaultBlock.setSuccessor(successor);
        PhpCfgBlock nextCase = defaultBlock;
        PhpCfgBlock caseBody = successor;
        this.addBreakable(successor, successor);
        for (SwitchCaseClauseTree caseTree : ListUtils.reverse(tree.cases())) {
            caseBody = this.buildSubFlow(caseTree.statements(), caseBody);
            if (caseTree.is(Tree.Kind.CASE_CLAUSE)) {
                PhpCfgBranchingBlock caseBranch = this.createBranchingBlock(caseTree, caseBody, nextCase);
                caseBranch.addElement(((CaseClauseTree)caseTree).expression());
                nextCase = caseBranch;
                continue;
            }
            defaultBlock.setSuccessor(caseBody);
        }
        this.removeBreakable();
        PhpCfgBlock block = this.createSimpleBlock(nextCase);
        block.addElement(tree.expression());
        return block;
    }

    private PhpCfgBlock buildTryStatement(TryStatementTree tree, PhpCfgBlock successor) {
        PhpCfgBlock exitBlock = this.exitTargets.peek().exitBlock;
        PhpCfgBlock finallyBlockEnd = this.createMultiSuccessorBlock(Set.of(successor, exitBlock));
        PhpCfgBlock finallyBlock = tree.finallyBlock() != null ? this.build(tree.finallyBlock().statements(), finallyBlockEnd) : finallyBlockEnd;
        List<PhpCfgBlock> catchBlocks = tree.catchBlocks().stream().map(catchBlockTree -> this.buildSubFlow(catchBlockTree.block().statements(), finallyBlock)).toList();
        if (catchBlocks.isEmpty()) {
            this.throwTargets.push(finallyBlock);
        } else {
            this.throwTargets.push(catchBlocks.get(0));
        }
        HashSet<PhpCfgBlock> bodySuccessors = new HashSet<PhpCfgBlock>(catchBlocks);
        bodySuccessors.add(finallyBlock);
        PhpCfgBlock tryBodySuccessors = this.createMultiSuccessorBlock(bodySuccessors);
        this.addBreakable(tryBodySuccessors, tryBodySuccessors);
        this.exitTargets.push(new TryBodyEnd(tryBodySuccessors, finallyBlock));
        PhpCfgBlock tryBodyStartingBlock = this.build(tree.block().statements(), tryBodySuccessors);
        this.throwTargets.pop();
        this.exitTargets.pop();
        this.removeBreakable();
        return tryBodyStartingBlock;
    }

    private PhpCfgBlock buildThrowStatement(ThrowStatementTree tree, PhpCfgBlock successor) {
        PhpCfgBlock simpleBlock = this.createBlockWithSyntacticSuccessor(this.throwTargets.peek(), successor);
        simpleBlock.addElement(tree);
        return simpleBlock;
    }

    private PhpCfgBlock buildReturnStatement(ReturnStatementTree tree, PhpCfgBlock successor) {
        PhpCfgBlock simpleBlock = this.createBlockWithSyntacticSuccessor(this.exitTargets.peek().catchAndFinally, successor);
        simpleBlock.addElement(tree);
        return simpleBlock;
    }

    private PhpCfgBlock createLabelBlock(LabelTree tree, PhpCfgBlock currentBlock) {
        String label = tree.label().text();
        this.labelledBlocks.put(label, currentBlock);
        currentBlock.addElement(tree);
        List<PhpCfgBlock> gotoBlocks = this.gotosWithoutTarget.get(label);
        if (gotoBlocks != null) {
            gotoBlocks.forEach(gotoBlock -> gotoBlock.replaceSuccessor(this.end, currentBlock));
            this.gotosWithoutTarget.remove(label);
        }
        return this.createSimpleBlock(currentBlock);
    }

    private PhpCfgBlock buildGotoStatement(GotoStatementTree tree, PhpCfgBlock successor) {
        PhpCfgBlock newBlock;
        String label = tree.identifier().text();
        PhpCfgBlock gotoTarget = this.labelledBlocks.get(label);
        if (gotoTarget == null) {
            newBlock = this.createBlockWithSyntacticSuccessor(this.end, successor);
            List gotosList = this.gotosWithoutTarget.computeIfAbsent(label, k -> new LinkedList());
            gotosList.add(newBlock);
        } else {
            newBlock = this.createBlockWithSyntacticSuccessor(gotoTarget, successor);
        }
        newBlock.addElement(tree);
        return newBlock;
    }

    private PhpCfgBlock buildBreakStatement(BreakStatementTree tree, PhpCfgBlock successor) {
        PhpCfgBlock newBlock = this.createBlockWithSyntacticSuccessor(this.getBreakable((ExpressionTree)tree.argument(), (StatementTree)tree).breakTarget, successor);
        newBlock.addElement(tree);
        return newBlock;
    }

    private PhpCfgBlock buildContinueStatement(ContinueStatementTree tree, PhpCfgBlock successor) {
        PhpCfgBlock newBlock = this.createBlockWithSyntacticSuccessor(this.getBreakable((ExpressionTree)tree.argument(), (StatementTree)tree).continueTarget, successor);
        newBlock.addElement(tree);
        return newBlock;
    }

    private Breakable getBreakable(@Nullable ExpressionTree argument, StatementTree jumpStmp) {
        try {
            int breakLevels = ControlFlowGraphBuilder.getBreakLevels(argument);
            return this.breakables.get(breakLevels - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw ControlFlowGraphBuilder.exception(jumpStmp, e);
        }
    }

    private static int getBreakLevels(@Nullable ExpressionTree argument) {
        if (argument == null) {
            return 1;
        }
        ExpressionTree levelsExpression = argument;
        if (levelsExpression.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            levelsExpression = ((ParenthesisedExpressionTree)levelsExpression).expression();
        }
        if (!levelsExpression.is(Tree.Kind.NUMERIC_LITERAL)) {
            throw ControlFlowGraphBuilder.exception(argument);
        }
        try {
            int breakLevels = (int)LiteralUtils.longLiteralValue(((LiteralTree)levelsExpression).value());
            if (breakLevels == 0) {
                return 1;
            }
            return breakLevels;
        }
        catch (NumberFormatException e) {
            throw ControlFlowGraphBuilder.exception(argument, e);
        }
    }

    private static RecognitionException exception(Tree tree) {
        return new RecognitionException(((PHPTree)tree).getLine(), "Failed to build CFG");
    }

    private static RecognitionException exception(Tree tree, Throwable cause) {
        return new RecognitionException(((PHPTree)tree).getLine(), "Failed to build CFG", cause);
    }

    private PhpCfgBlock buildForEachStatement(ForEachStatementTree tree, PhpCfgBlock successor) {
        ForwardingBlock linkToCondition = this.createForwardingBlock();
        this.addBreakable(successor, linkToCondition);
        PhpCfgBlock loopBodyBlock = this.buildSubFlow(tree.statements(), linkToCondition);
        this.removeBreakable();
        PhpCfgBranchingBlock conditionBlock = this.createBranchingBlock(tree, loopBodyBlock, successor);
        conditionBlock.addElement(tree.expression());
        linkToCondition.setSuccessor(conditionBlock);
        return this.createSimpleBlock(conditionBlock);
    }

    private PhpCfgBlock buildForStatement(ForStatementTree tree, PhpCfgBlock successor) {
        ForwardingBlock linkToCondition = this.createForwardingBlock();
        PhpCfgBlock updateBlock = this.createSimpleBlock(linkToCondition);
        ListUtils.reverse(tree.update()).forEach(updateBlock::addElement);
        this.addBreakable(successor, updateBlock);
        PhpCfgBlock loopBodyBlock = this.buildSubFlow(tree.statements(), updateBlock);
        this.removeBreakable();
        PhpCfgBranchingBlock conditionBlock = this.createBranchingBlock(tree, loopBodyBlock, successor);
        ListUtils.reverse(tree.condition()).forEach(conditionBlock::addElement);
        linkToCondition.setSuccessor(conditionBlock);
        PhpCfgBlock beforeFor = this.createSimpleBlock(conditionBlock);
        ListUtils.reverse(tree.init()).forEach(beforeFor::addElement);
        return beforeFor;
    }

    private PhpCfgBlock buildDoWhileStatement(DoWhileStatementTree tree, PhpCfgBlock successor) {
        ForwardingBlock linkToBody = this.createForwardingBlock();
        PhpCfgBranchingBlock conditionBlock = this.createBranchingBlock(tree, linkToBody, successor);
        conditionBlock.addElement(tree.condition().expression());
        this.addBreakable(successor, conditionBlock);
        PhpCfgBlock loopBodyBlock = this.buildSubFlow(Collections.singletonList(tree.statement()), conditionBlock);
        this.removeBreakable();
        linkToBody.setSuccessor(loopBodyBlock);
        return this.createSimpleBlock(loopBodyBlock);
    }

    private PhpCfgBlock buildWhileStatement(WhileStatementTree tree, PhpCfgBlock successor) {
        ForwardingBlock linkToCondition = this.createForwardingBlock();
        this.addBreakable(successor, linkToCondition);
        PhpCfgBlock loopBodyBlock = this.buildSubFlow(tree.statements(), linkToCondition);
        this.removeBreakable();
        PhpCfgBranchingBlock conditionBlock = this.createBranchingBlock(tree, loopBodyBlock, successor);
        conditionBlock.addElement(tree.condition().expression());
        linkToCondition.setSuccessor(conditionBlock);
        return this.createSimpleBlock(conditionBlock);
    }

    private void removeBreakable() {
        this.breakables.pop();
    }

    private void addBreakable(PhpCfgBlock breakTarget, PhpCfgBlock continueTarget) {
        this.breakables.push(new Breakable(breakTarget, continueTarget));
    }

    private ForwardingBlock createForwardingBlock() {
        ForwardingBlock block = new ForwardingBlock();
        this.blocks.add(block);
        return block;
    }

    private PhpCfgBlock buildBlock(BlockTree block, PhpCfgBlock successor) {
        return this.build(block.statements(), successor);
    }

    private PhpCfgBlock buildIfStatement(IfStatementTree tree, PhpCfgBlock successor) {
        PhpCfgBlock falseBlock = successor;
        if (tree.elseClause() != null) {
            falseBlock = this.buildSubFlow(tree.elseClause().statements(), successor);
        }
        if (!tree.elseifClauses().isEmpty()) {
            for (ElseifClauseTree elseifClause : ListUtils.reverse(tree.elseifClauses())) {
                falseBlock = this.buildElseIfStatement(elseifClause, successor, falseBlock);
            }
        }
        PhpCfgBlock trueBlock = this.buildSubFlow(tree.statements(), successor);
        PhpCfgBranchingBlock conditionBlock = this.createBranchingBlock(tree, trueBlock, falseBlock);
        conditionBlock.addElement(tree.condition().expression());
        return conditionBlock;
    }

    private PhpCfgBlock buildElseIfStatement(ElseifClauseTree tree, PhpCfgBlock ifSuccessor, PhpCfgBlock nextCondition) {
        PhpCfgBlock thenBlock = this.buildSubFlow(tree.statements(), ifSuccessor);
        PhpCfgBranchingBlock conditionBlock = this.createBranchingBlock(tree, thenBlock, nextCondition);
        conditionBlock.addElement(tree.condition().expression());
        return conditionBlock;
    }

    private PhpCfgBlock buildSubFlow(List<StatementTree> subFlowTree, PhpCfgBlock successor) {
        return this.build(subFlowTree, this.createSimpleBlock(successor));
    }

    private PhpCfgBranchingBlock createBranchingBlock(Tree branchingTree, PhpCfgBlock trueSuccessor, PhpCfgBlock falseSuccessor) {
        PhpCfgBranchingBlock block = new PhpCfgBranchingBlock(branchingTree, trueSuccessor, falseSuccessor);
        this.blocks.add(block);
        return block;
    }

    private PhpCfgBlock createMultiSuccessorBlock(Set<PhpCfgBlock> successors) {
        PhpCfgBlock block = new PhpCfgBlock(successors);
        this.blocks.add(block);
        return block;
    }

    private PhpCfgBlock createSimpleBlock(PhpCfgBlock successor) {
        PhpCfgBlock block = new PhpCfgBlock(successor);
        this.blocks.add(block);
        return block;
    }

    private PhpCfgBlock createBlockWithSyntacticSuccessor(PhpCfgBlock successor, PhpCfgBlock syntacticSuccessor) {
        PhpCfgBlock block = new PhpCfgBlock(successor, syntacticSuccessor);
        this.blocks.add(block);
        return block;
    }

    static class TryBodyEnd {
        final PhpCfgBlock catchAndFinally;
        final PhpCfgBlock exitBlock;

        TryBodyEnd(PhpCfgBlock catchAndFinally, PhpCfgBlock exitBlock) {
            this.catchAndFinally = catchAndFinally;
            this.exitBlock = exitBlock;
        }
    }

    private static class ForwardingBlock
    extends PhpCfgBlock {
        private PhpCfgBlock successor;

        private ForwardingBlock() {
        }

        @Override
        public Set<CfgBlock> successors() {
            Preconditions.checkState((this.successor != null ? 1 : 0) != 0, (String)"No successor was set on %s", (Object[])new Object[]{this});
            return Set.of(this.successor);
        }

        @Override
        public void addElement(Tree element) {
            throw new UnsupportedOperationException("Cannot add an element to a forwarding block");
        }

        void setSuccessor(PhpCfgBlock successor) {
            this.successor = successor;
        }

        @Override
        public void replaceSuccessors(Map<PhpCfgBlock, PhpCfgBlock> replacements) {
            throw new UnsupportedOperationException("Cannot replace successors for a forwarding block");
        }
    }

    private static class Breakable {
        PhpCfgBlock breakTarget;
        PhpCfgBlock continueTarget;

        Breakable(PhpCfgBlock breakTarget, PhpCfgBlock continueTarget) {
            this.breakTarget = breakTarget;
            this.continueTarget = continueTarget;
        }
    }
}

