/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.api.cfg;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.utils.Throwables;
import org.sonar.plugins.php.api.cfg.CfgBlock;
import org.sonar.plugins.php.api.cfg.ControlFlowGraphBuilder;
import org.sonar.plugins.php.api.cfg.PhpCfgEndBlock;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.visitors.CheckContext;

public class ControlFlowGraph {
    private static final Logger LOG = LoggerFactory.getLogger(ControlFlowGraph.class);
    public static final Set<Tree.Kind> KINDS_WITH_CONTROL_FLOW = EnumSet.of(Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.METHOD_DECLARATION, Tree.Kind.SCRIPT);
    private final CfgBlock start;
    private final PhpCfgEndBlock end;
    private final Set<CfgBlock> blocks;
    private static Set<Tree> failedTrees = Collections.newSetFromMap(new WeakHashMap());

    ControlFlowGraph(Set<CfgBlock> blocks, CfgBlock start, PhpCfgEndBlock end) {
        this.start = start;
        this.end = end;
        this.blocks = blocks;
    }

    public static ControlFlowGraph build(BlockTree body) {
        return new ControlFlowGraphBuilder(body.statements()).getGraph();
    }

    static ControlFlowGraph build(ScriptTree scriptTree) {
        return new ControlFlowGraphBuilder(scriptTree.statements()).getGraph();
    }

    static ControlFlowGraph build(ForEachStatementTree statementTree) {
        return new ControlFlowGraphBuilder(statementTree.statements()).getGraph();
    }

    @CheckForNull
    public static ControlFlowGraph build(Tree tree, CheckContext context) {
        if (failedTrees.contains(tree)) {
            return null;
        }
        try {
            switch (tree.getKind()) {
                case FUNCTION_DECLARATION: {
                    return ControlFlowGraph.build(((FunctionDeclarationTree)tree).body());
                }
                case FUNCTION_EXPRESSION: {
                    return ControlFlowGraph.build(((FunctionExpressionTree)tree).body());
                }
                case METHOD_DECLARATION: {
                    Tree body = ((MethodDeclarationTree)tree).body();
                    if (body.is(Tree.Kind.BLOCK)) {
                        return ControlFlowGraph.build((BlockTree)body);
                    }
                    return null;
                }
                case SCRIPT: {
                    return ControlFlowGraph.build((ScriptTree)tree);
                }
                case FOREACH_STATEMENT: {
                    return ControlFlowGraph.build((ForEachStatementTree)tree);
                }
                case CATCH_BLOCK: {
                    return ControlFlowGraph.build(((CatchBlockTree)tree).block());
                }
            }
            throw new IllegalStateException("Unexpected tree kind " + String.valueOf(tree.getKind()));
        }
        catch (Exception e) {
            LOG.warn("Failed to build control flow graph for file [{}] at line {} (activate debug logs for more details)", (Object)context.getPhpFile(), (Object)((PHPTree)tree).getLine());
            LOG.debug(Throwables.getStackTraceAsString(e));
            failedTrees.add(tree);
            return null;
        }
    }

    public CfgBlock start() {
        return this.start;
    }

    public CfgBlock end() {
        return this.end;
    }

    public Set<CfgBlock> blocks() {
        return this.blocks;
    }
}

