/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.api;

import java.util.ArrayList;
import java.util.Locale;
import org.sonar.api.config.Configuration;
import org.sonar.api.resources.AbstractLanguage;

public final class Php
extends AbstractLanguage {
    public static final String NAME = "PHP";
    public static final String KEY = "php";
    public static final String DEFAULT_FILE_SUFFIXES = "php,php3,php4,php5,phtml,inc";
    private Configuration settings;

    public Php(Configuration settings) {
        super(KEY, NAME);
        this.settings = settings;
    }

    public String[] getFileSuffixes() {
        String[] suffixes = Php.filterEmptyStrings(this.settings.getStringArray("sonar.php.file.suffixes"));
        if (suffixes.length == 0) {
            suffixes = DEFAULT_FILE_SUFFIXES.split(",");
        }
        return suffixes;
    }

    private static String[] filterEmptyStrings(String[] stringArray) {
        ArrayList<String> nonEmptyStrings = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.isBlank()) continue;
            nonEmptyStrings.add(string.trim());
        }
        return nonEmptyStrings.toArray(new String[nonEmptyStrings.size()]);
    }

    public boolean hasValidSuffixes(String fileName) {
        String pathLowerCase = fileName.toLowerCase(Locale.ROOT);
        for (String suffix : this.getFileSuffixes()) {
            if (!pathLowerCase.endsWith("." + suffix.toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }
}

