/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import org.sonar.api.Plugin;
import org.sonar.api.SonarProduct;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.plugins.php.PHPProfileDefinition;
import org.sonar.plugins.php.PHPRulesDefinition;
import org.sonar.plugins.php.PHPSensor;
import org.sonar.plugins.php.PhpExclusionsFileFilter;
import org.sonar.plugins.php.PhpIniSensor;
import org.sonar.plugins.php.api.Php;
import org.sonar.plugins.php.reports.phpstan.PhpStanRulesDefinition;
import org.sonar.plugins.php.reports.phpstan.PhpStanSensor;
import org.sonar.plugins.php.reports.phpunit.PhpUnitSensor;
import org.sonar.plugins.php.reports.psalm.PsalmRulesDefinition;
import org.sonar.plugins.php.reports.psalm.PsalmSensor;
import org.sonar.plugins.php.warning.DefaultAnalysisWarningsWrapper;

public class PhpPlugin
implements Plugin {
    public static final String FILE_SUFFIXES_KEY = "sonar.php.file.suffixes";
    public static final String PHP_EXCLUSIONS_KEY = "sonar.php.exclusions";
    public static final String PHP_EXCLUSIONS_DEFAULT_VALUE = "**/vendor/**";
    public static final String PHP_FRAMEWORK_DETECTION = "sonar.php.frameworkDetection";
    public static final String PHP_FRAMEWORK_DETECTION_DEFAULT_VALUE = "true";
    public static final String PHP_CATEGORY = "PHP";
    public static final String GENERAL_SUBCATEGORY = "General";
    public static final String PHPUNIT_SUBCATEGORY = "PHPUnit";
    private static final String EXTERNAL_ANALYZERS_SUBCATEGORY = "External Analyzers";

    public void define(Plugin.Context context) {
        context.addExtensions(Php.class, PHPSensor.class, new Object[]{PhpIniSensor.class, PHPRulesDefinition.class, PHPProfileDefinition.class, PhpExclusionsFileFilter.class, PropertyDefinition.builder((String)FILE_SUFFIXES_KEY).defaultValue("php,php3,php4,php5,phtml,inc").name("File Suffixes").description("List of suffixes of PHP files to analyze.").onQualifiers("TRK", new String[0]).category(PHP_CATEGORY).multiValues(true).subCategory(GENERAL_SUBCATEGORY).build(), PropertyDefinition.builder((String)PHP_EXCLUSIONS_KEY).defaultValue(PHP_EXCLUSIONS_DEFAULT_VALUE).name("PHP Exclusions").description("List of file path patterns to be excluded from analysis of PHP files.").onQualifiers("TRK", new String[0]).category(PHP_CATEGORY).subCategory(GENERAL_SUBCATEGORY).multiValues(true).build(), PropertyDefinition.builder((String)PHP_FRAMEWORK_DETECTION).defaultValue(PHP_FRAMEWORK_DETECTION_DEFAULT_VALUE).name("PHP Framework detection").description("Enable the detection of PHP framework in analyzed file, which adapt some rules behavior.").onQualifiers("TRK", new String[0]).category(PHP_CATEGORY).subCategory(GENERAL_SUBCATEGORY).build()});
        if (context.getRuntime().getProduct() != SonarProduct.SONARLINT) {
            PhpPlugin.addPhpUnitExtensions(context);
            PhpPlugin.addPhpStanExtensions(context);
            PhpPlugin.addPsalmExtensions(context);
        }
        context.addExtension(DefaultAnalysisWarningsWrapper.class);
    }

    private static void addPhpUnitExtensions(Plugin.Context context) {
        context.addExtensions(PhpUnitSensor.class, (Object)PropertyDefinition.builder((String)"sonar.php.tests.reportPath").name("Unit Test Report").description("Comma-separated list of paths to PHPUnit unit test execution report files. Paths may be either absolute or relative to the project base directory.").onQualifiers("TRK", new String[0]).category(PHP_CATEGORY).multiValues(true).subCategory(PHPUNIT_SUBCATEGORY).build(), new Object[]{PropertyDefinition.builder((String)"sonar.php.coverage.reportPaths").name("Coverage Reports").description("List of PHPUnit code coverage report files. Each path can be either absolute or relative.").onQualifiers("TRK", new String[0]).category(PHP_CATEGORY).multiValues(true).subCategory(PHPUNIT_SUBCATEGORY).build()});
    }

    private static void addPhpStanExtensions(Plugin.Context context) {
        context.addExtensions(PhpStanRulesDefinition.class, PhpStanSensor.class, new Object[]{PropertyDefinition.builder((String)"sonar.php.phpstan.reportPaths").name("PHPStan Report Files").description("Paths (absolute or relative) to report files with PHPStan issues.").category(EXTERNAL_ANALYZERS_SUBCATEGORY).subCategory(PHP_CATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build()});
    }

    private static void addPsalmExtensions(Plugin.Context context) {
        context.addExtensions(PsalmRulesDefinition.class, PsalmSensor.class, new Object[]{PropertyDefinition.builder((String)"sonar.php.psalm.reportPaths").name("Psalm Report Files").description("Paths (absolute or relative) to report files with Psalm issues.").category(EXTERNAL_ANALYZERS_SUBCATEGORY).subCategory(PHP_CATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build()});
    }
}

