/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.plugins.php.AnalysisException;

public class PhpExclusionsFileFilter
implements InputFileFilter {
    private final String[] excludedPatterns;
    private static final Logger LOG = LoggerFactory.getLogger(PhpExclusionsFileFilter.class);
    private static final int DEFAULT_AVERAGE_LINE_LENGTH_THRESHOLD = 220;

    public PhpExclusionsFileFilter(Configuration configuration) {
        this.excludedPatterns = configuration.getStringArray("sonar.php.exclusions");
    }

    public boolean accept(InputFile inputFile) {
        if (!"php".equals(inputFile.language())) {
            return true;
        }
        URI fileUri = inputFile.uri();
        String relativePath = fileUri.toString();
        if (WildcardPattern.match((WildcardPattern[])WildcardPattern.create((String[])this.excludedPatterns), (String)relativePath)) {
            LOG.debug("File [{}] is excluded by '{}' property and will not be analyzed", (Object)fileUri, (Object)"sonar.php.exclusions");
            return false;
        }
        if (new AverageLineLengthCalculator(inputFile).getAverageLineLength() > 220) {
            LOG.debug("File [{}] is excluded because it is considered generated (average line length is too big).", (Object)fileUri);
            return false;
        }
        return true;
    }

    private static class AverageLineLengthCalculator {
        private static final Pattern PHP_OPEN_TAG = Pattern.compile("(?i)<\\?(?:php|=|)");
        private InputFile file;
        private boolean isAtFirstLine = true;
        private boolean isInHeaderComment = false;
        private boolean isClike = false;

        public AverageLineLengthCalculator(InputFile file) {
            this.file = file;
        }

        public int getAverageLineLength() {
            long nbLines = 0L;
            long nbCharacters = 0L;
            List<String> lines = AverageLineLengthCalculator.fileLines(this.file);
            for (String line : lines) {
                if (this.ignoreLine(line)) continue;
                ++nbLines;
                nbCharacters += (long)line.length();
            }
            return nbLines > 0L ? (int)(nbCharacters / nbLines) : 0;
        }

        private static List<String> fileLines(InputFile inputFile) {
            ArrayList<String> lines = new ArrayList<String>();
            try (Scanner scanner = new Scanner(inputFile.inputStream(), inputFile.charset());){
                while (scanner.hasNextLine()) {
                    lines.add(scanner.nextLine());
                }
            }
            catch (IOException e) {
                throw new AnalysisException(String.format("Unable to read file '%s'", inputFile), e);
            }
            return lines;
        }

        private boolean ignoreLine(String line) {
            String trimmedLine = line.trim();
            if (this.isAtFirstLine) {
                if (trimmedLine.isEmpty()) {
                    return true;
                }
                if (PHP_OPEN_TAG.matcher(trimmedLine).find()) {
                    return false;
                }
                this.isAtFirstLine = false;
                return this.isFirstLineInHeaderComment(trimmedLine);
            }
            if (this.isInHeaderComment) {
                return this.isSubsequentLineInHeaderComment(trimmedLine);
            }
            return false;
        }

        private boolean isFirstLineInHeaderComment(String line) {
            if (line.startsWith("/*")) {
                this.isClike = true;
                this.isInHeaderComment = !line.endsWith("*/");
                return true;
            }
            if (line.startsWith("//")) {
                this.isClike = false;
                this.isInHeaderComment = true;
                return true;
            }
            return false;
        }

        private boolean isSubsequentLineInHeaderComment(String line) {
            if (this.isClike) {
                if (line.endsWith("*/")) {
                    this.isInHeaderComment = false;
                } else if (line.contains("*/")) {
                    this.isInHeaderComment = false;
                    return false;
                }
                return true;
            }
            if (line.startsWith("//")) {
                return true;
            }
            this.isInHeaderComment = false;
            return false;
        }
    }
}

