/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.DurationStatistics;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.php.cache.CacheContextImpl;
import org.sonar.php.checks.CheckList;
import org.sonar.php.symbols.ProjectSymbolData;
import org.sonar.plugins.php.AnalysisScanner;
import org.sonar.plugins.php.CancellationException;
import org.sonar.plugins.php.PHPChecks;
import org.sonar.plugins.php.SymbolScanner;
import org.sonar.plugins.php.api.visitors.PHPCustomRuleRepository;

public class PHPSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(PHPSensor.class);
    private final FileLinesContextFactory fileLinesContextFactory;
    private final PHPChecks checks;
    private final NoSonarFilter noSonarFilter;

    public PHPSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, null);
    }

    public PHPSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, @Nullable PHPCustomRuleRepository[] customRuleRepositories) {
        this(fileLinesContextFactory, PHPChecks.createPHPCheck(checkFactory).addChecks("php", CheckList.getPhpChecks()).addCustomChecks(customRuleRepositories), noSonarFilter);
    }

    PHPSensor(FileLinesContextFactory fileLinesContextFactory, PHPChecks checks, NoSonarFilter noSonarFilter) {
        this.checks = checks;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("php").name("PHP sensor");
    }

    public void execute(SensorContext context) {
        DurationStatistics statistics = new DurationStatistics(context.config());
        List<InputFile> inputFiles = PHPSensor.getInputFiles(context);
        CacheContextImpl cacheContext = CacheContextImpl.of(context);
        SymbolScanner symbolScanner = SymbolScanner.create(context, statistics, cacheContext);
        try {
            symbolScanner.execute(inputFiles);
            ProjectSymbolData projectSymbolData = symbolScanner.getProjectSymbolData();
            AnalysisScanner analysisScanner = new AnalysisScanner(context, this.checks, this.fileLinesContextFactory, this.noSonarFilter, projectSymbolData, statistics, cacheContext);
            analysisScanner.execute(inputFiles);
        }
        catch (CancellationException e) {
            LOG.info(e.getMessage());
        }
        statistics.log();
    }

    private static List<InputFile> getInputFiles(SensorContext context) {
        FileSystem fileSystem = context.fileSystem();
        FilePredicate phpFilePredicate = fileSystem.predicates().hasLanguage("php");
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>();
        fileSystem.inputFiles(phpFilePredicate).forEach(inputFiles::add);
        return inputFiles;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

