/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonarsource.analyzer.commons.BuiltInQualityProfileJsonLoader;

public final class PHPProfileDefinition
implements BuiltInQualityProfilesDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(PHPProfileDefinition.class);
    public static final String SONAR_WAY_PROFILE = "Sonar way";
    public static final String SONAR_WAY_PATH = "org/sonar/l10n/php/rules/php/Sonar_way_profile.json";
    public static final String SECURITY_RULES_CLASS = "com.sonar.plugins.security.api.PhpRules";
    public static final String RULES_KEYS_METHOD_NAME = "getRuleKeys";
    public static final String REPOSITORY_KEYS_METHOD_NAME = "getRepositoryKey";

    public void define(BuiltInQualityProfilesDefinition.Context context) {
        BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile sonarWay = context.createBuiltInQualityProfile(SONAR_WAY_PROFILE, "php");
        BuiltInQualityProfileJsonLoader.load(sonarWay, "php", SONAR_WAY_PATH);
        PHPProfileDefinition.getSecurityRuleKeys(SECURITY_RULES_CLASS, RULES_KEYS_METHOD_NAME, REPOSITORY_KEYS_METHOD_NAME).forEach(key -> sonarWay.activateRule(key.repository(), key.rule()));
        sonarWay.done();
    }

    static Set<RuleKey> getSecurityRuleKeys(String rulesClassName, String ruleKeyMethodName, String repositoryKeyMethodName) {
        try {
            Class<?> phpRulesClass = Class.forName(rulesClassName);
            Method getRuleKeysMethod = phpRulesClass.getMethod(ruleKeyMethodName, new Class[0]);
            Set ruleKeys = (Set)getRuleKeysMethod.invoke(null, new Object[0]);
            Method getRepositoryKeyMethod = phpRulesClass.getMethod(repositoryKeyMethodName, new Class[0]);
            String repositoryKey = (String)getRepositoryKeyMethod.invoke(null, new Object[0]);
            return ruleKeys.stream().map(k -> RuleKey.of((String)repositoryKey, (String)k)).collect(Collectors.toSet());
        }
        catch (ClassNotFoundException e) {
            LOG.debug("com.sonar.plugins.security.api.PhpRules is not found, {}", (Object)PHPProfileDefinition.securityRuleMessage(e));
        }
        catch (NoSuchMethodException e) {
            LOG.debug("Method not found on com.sonar.plugins.security.api.PhpRules, {}", (Object)PHPProfileDefinition.securityRuleMessage(e));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.debug("[{}] {}", (Object)e.getClass().getSimpleName(), (Object)PHPProfileDefinition.securityRuleMessage(e));
        }
        return new HashSet<RuleKey>();
    }

    private static String securityRuleMessage(Exception e) {
        return "no security rules added to Sonar way PHP profile: " + e.getMessage();
    }
}

