/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.DurationStatistics;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonar.php.PHPAnalyzer;
import org.sonar.php.cache.Cache;
import org.sonar.php.checks.ParsingErrorCheck;
import org.sonar.php.checks.UncatchableExceptionCheck;
import org.sonar.php.checks.utils.PhpUnitCheck;
import org.sonar.php.compat.PhpFileImpl;
import org.sonar.php.filters.SuppressWarningFilter;
import org.sonar.php.highlighter.SymbolHighlighter;
import org.sonar.php.highlighter.SyntaxHighlighterVisitor;
import org.sonar.php.metrics.CpdVisitor;
import org.sonar.php.metrics.FileMeasures;
import org.sonar.php.symbols.ProjectSymbolData;
import org.sonar.php.utils.Throwables;
import org.sonar.plugins.php.AnalysisException;
import org.sonar.plugins.php.PHPChecks;
import org.sonar.plugins.php.Scanner;
import org.sonar.plugins.php.api.cache.CacheContext;
import org.sonar.plugins.php.api.visitors.FileIssue;
import org.sonar.plugins.php.api.visitors.IssueLocation;
import org.sonar.plugins.php.api.visitors.LineIssue;
import org.sonar.plugins.php.api.visitors.PHPCheck;
import org.sonar.plugins.php.api.visitors.PhpFile;
import org.sonar.plugins.php.api.visitors.PhpInputFileContext;
import org.sonar.plugins.php.api.visitors.PhpIssue;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

class AnalysisScanner
extends Scanner {
    private static final Logger LOG = LoggerFactory.getLogger(AnalysisScanner.class);
    private final PHPChecks checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private final RuleKey parsingErrorRuleKey;
    private final boolean hasTestFileChecks;
    private final CacheContext cacheContext;
    private final PHPAnalyzer phpAnalyzer;
    private final SuppressWarningFilter suppressWarningFilter = new SuppressWarningFilter();
    private int numScannedWithoutParsing = 0;

    public AnalysisScanner(SensorContext context, PHPChecks checks, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, ProjectSymbolData projectSymbolData, DurationStatistics statistics, CacheContext cacheContext) {
        super(context, statistics, new Cache(cacheContext));
        this.checks = checks;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.parsingErrorRuleKey = this.getParsingErrorRuleKey();
        this.cacheContext = cacheContext;
        List<PHPCheck> mainFileChecks = this.getMainFileChecks();
        List<PHPCheck> testFileChecks = this.getTestFileChecks();
        this.hasTestFileChecks = !testFileChecks.isEmpty();
        File workingDir = context.fileSystem().workDir();
        boolean frameworkDetectionEnabled = "true".equalsIgnoreCase(context.config().get("sonar.php.frameworkDetection").orElse(""));
        this.phpAnalyzer = new PHPAnalyzer(mainFileChecks, testFileChecks, workingDir, projectSymbolData, statistics, cacheContext, this.suppressWarningFilter, frameworkDetectionEnabled);
    }

    @Override
    void execute(List<InputFile> files) {
        super.execute(files);
        AnalysisScanner.reportStatistics(this.numScannedWithoutParsing, files.size());
    }

    private static void reportStatistics(int numSkippedFiles, int numTotalFiles) {
        LOG.info("The PHP analyzer was able to leverage cached data from previous analyses for {} out of {} files. These files were not parsed.", (Object)numSkippedFiles, (Object)numTotalFiles);
    }

    private List<PHPCheck> getMainFileChecks() {
        List<PHPCheck> applicableChecks = this.checks.all();
        if (AnalysisScanner.inSonarLint(this.context)) {
            applicableChecks = applicableChecks.stream().filter(e -> !(e instanceof UncatchableExceptionCheck)).toList();
        }
        return applicableChecks;
    }

    private List<PHPCheck> getTestFileChecks() {
        return this.checks.all().stream().filter(PhpUnitCheck.class::isInstance).toList();
    }

    private boolean scanFileWithoutParsing(InputFile inputFile, CpdVisitor cpdVisitor) {
        PhpFile pythonFile = PhpFileImpl.create(inputFile);
        PhpInputFileContext inputFileContext = new PhpInputFileContext(pythonFile, this.context.fileSystem().workDir(), this.cacheContext);
        for (PHPCheck check : this.checks.all()) {
            if (check.scanWithoutParsing(inputFileContext)) continue;
            return false;
        }
        return cpdVisitor.scanWithoutParsing(inputFileContext);
    }

    @Override
    String name() {
        return "PHP rules";
    }

    @Override
    void scanFile(InputFile inputFile) {
        CpdVisitor cpdVisitor = new CpdVisitor();
        if (this.fileCanBeSkipped(inputFile) && this.scanFileWithoutParsing(inputFile, cpdVisitor)) {
            this.saveCpdData(inputFile, cpdVisitor.getCpdTokens());
            ++this.numScannedWithoutParsing;
            return;
        }
        try {
            this.phpAnalyzer.nextFile(inputFile);
        }
        catch (RecognitionException e) {
            AnalysisScanner.checkInterrupted(e);
            LOG.warn("Unable to parse file [{}] at line {}", (Object)inputFile.uri(), (Object)e.getLine());
            LOG.warn(e.getMessage());
            this.saveParsingIssue(this.context, e, inputFile);
            return;
        }
        this.computeMeasuresAndSaveCpdData(inputFile, cpdVisitor);
        this.noSonarFilter.noSonarInFile(inputFile, this.phpAnalyzer.computeNoSonarLines());
        List<PhpIssue> issues = inputFile.type() == InputFile.Type.MAIN ? this.phpAnalyzer.analyze() : this.phpAnalyzer.analyzeTest();
        issues = this.filterIssuesByWarningSuppressor(inputFile, issues);
        this.saveIssues(this.context, issues, inputFile);
    }

    private void computeMeasuresAndSaveCpdData(InputFile inputFile, CpdVisitor cpdVisitor) {
        if (!AnalysisScanner.inSonarLint(this.context)) {
            this.saveSyntaxHighlighting(inputFile);
            this.saveSymbolHighlighting(inputFile);
            if (inputFile.type() == InputFile.Type.MAIN) {
                AnalysisScanner.saveNewFileMeasures(this.context, this.phpAnalyzer.computeMeasures(this.fileLinesContextFactory.createFor(inputFile)), inputFile);
                PhpFile phpFile = PhpFileImpl.create(inputFile);
                List<CpdVisitor.CpdToken> cpdTokens = cpdVisitor.computeCpdTokens(phpFile, this.phpAnalyzer.currentFileTree(), this.phpAnalyzer.currentFileSymbolTable(), this.cacheContext);
                this.saveCpdData(inputFile, cpdTokens);
            }
        }
    }

    private void saveSyntaxHighlighting(InputFile inputFile) {
        NewHighlighting highlighting = this.context.newHighlighting().onFile(inputFile);
        SyntaxHighlighterVisitor.highlight(this.phpAnalyzer.currentFileTree(), highlighting);
        highlighting.save();
    }

    private void saveSymbolHighlighting(InputFile inputFile) {
        NewSymbolTable symbolTable = this.context.newSymbolTable().onFile(inputFile);
        SymbolHighlighter.highlight(this.phpAnalyzer.currentFileSymbolTable(), symbolTable);
        symbolTable.save();
    }

    private void saveCpdData(InputFile inputFile, List<CpdVisitor.CpdToken> cpdTokens) {
        NewCpdTokens newCpdTokens = this.context.newCpdTokens().onFile(inputFile);
        cpdTokens.forEach(cpdToken -> newCpdTokens.addToken(cpdToken.line(), cpdToken.column(), cpdToken.endLine(), cpdToken.endColumn(), cpdToken.text()));
        newCpdTokens.save();
    }

    @Override
    protected boolean fileCanBeSkipped(InputFile file) {
        return super.fileCanBeSkipped(file) || file.type() == InputFile.Type.TEST && !this.hasTestFileChecks;
    }

    private List<PhpIssue> filterIssuesByWarningSuppressor(InputFile inputFile, List<PhpIssue> issues) {
        return issues.stream().filter(issue -> this.isIncluded(inputFile, (PhpIssue)issue)).toList();
    }

    private boolean isIncluded(InputFile inputFile, PhpIssue issue) {
        RuleKey ruleKey = this.checks.ruleKeyFor(issue.check());
        if (ruleKey != null) {
            if (issue instanceof LineIssue) {
                LineIssue lineIssue = (LineIssue)issue;
                return this.suppressWarningFilter.accept(inputFile.uri().toString(), ruleKey.toString(), lineIssue.line());
            }
            if (issue instanceof PreciseIssue) {
                PreciseIssue preciseIssue = (PreciseIssue)issue;
                return this.suppressWarningFilter.accept(inputFile.uri().toString(), ruleKey.toString(), preciseIssue.primaryLocation().startLine());
            }
        }
        return true;
    }

    private void saveIssues(SensorContext context, List<PhpIssue> issues, InputFile inputFile) {
        for (PhpIssue issue : issues) {
            RuleKey ruleKey = this.checks.ruleKeyFor(issue.check());
            NewIssue newIssue = context.newIssue().forRule(ruleKey).gap(issue.cost());
            if (issue instanceof LineIssue) {
                LineIssue lineIssue = (LineIssue)issue;
                location = newIssue.newLocation().message(lineIssue.message()).on((InputComponent)inputFile).at(inputFile.selectLine(lineIssue.line()));
                newIssue.at(location);
            } else if (issue instanceof FileIssue) {
                FileIssue fileIssue = (FileIssue)issue;
                location = newIssue.newLocation().message(fileIssue.message()).on((InputComponent)inputFile);
                newIssue.at(location);
            } else {
                PreciseIssue preciseIssue = (PreciseIssue)issue;
                newIssue.at(AnalysisScanner.newLocation(inputFile, newIssue, preciseIssue.primaryLocation()));
                preciseIssue.secondaryLocations().forEach(secondary -> AnalysisScanner.addSecondaryLocation(context, inputFile, newIssue, secondary));
            }
            newIssue.save();
        }
    }

    private void saveParsingIssue(SensorContext context, RecognitionException e, InputFile inputFile) {
        if (this.parsingErrorRuleKey != null) {
            NewIssue issue = context.newIssue();
            NewIssueLocation location = issue.newLocation().message("A parsing error occurred in this file.").on((InputComponent)inputFile).at(inputFile.selectLine(e.getLine()));
            issue.forRule(this.parsingErrorRuleKey).at(location).save();
        }
        context.newAnalysisError().onFile(inputFile).at(inputFile.newPointer(e.getLine(), 0)).message(e.getMessage()).save();
    }

    @Override
    void logException(Exception e, InputFile file) {
        LOG.warn("Could not analyse {}", (Object)file, (Object)e);
    }

    @Override
    void onEnd() {
        this.phpAnalyzer.terminate();
    }

    private static void saveNewFileMeasures(SensorContext context, FileMeasures fileMeasures, InputFile inputFile) {
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getLinesOfCodeNumber())).forMetric((Metric)CoreMetrics.NCLOC).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getCommentLinesNumber())).forMetric((Metric)CoreMetrics.COMMENT_LINES).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getClassNumber())).forMetric((Metric)CoreMetrics.CLASSES).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getFunctionNumber())).forMetric((Metric)CoreMetrics.FUNCTIONS).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getStatementNumber())).forMetric((Metric)CoreMetrics.STATEMENTS).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getFileCognitiveComplexity())).forMetric((Metric)CoreMetrics.COGNITIVE_COMPLEXITY).save();
        context.newMeasure().on((InputComponent)inputFile).withValue((Serializable)Integer.valueOf(fileMeasures.getFileComplexity())).forMetric((Metric)CoreMetrics.COMPLEXITY).save();
    }

    private static void addSecondaryLocation(SensorContext context, InputFile inputFile, NewIssue newIssue, IssueLocation secondary) {
        InputFile file = inputFile;
        String filePath = secondary.filePath();
        if (filePath != null) {
            file = context.fileSystem().inputFile(context.fileSystem().predicates().is(new File(filePath)));
        }
        if (file != null) {
            newIssue.addLocation(AnalysisScanner.newLocation(file, newIssue, secondary));
        }
    }

    private static NewIssueLocation newLocation(InputFile inputFile, NewIssue issue, IssueLocation location) {
        TextRange range = inputFile.newRange(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset());
        NewIssueLocation newLocation = issue.newLocation().on((InputComponent)inputFile).at(range);
        if (location.message() != null) {
            newLocation.message(location.message());
        }
        return newLocation;
    }

    private static void checkInterrupted(Exception e) {
        Throwable cause = Throwables.getRootCause(e);
        if (cause instanceof InterruptedException || cause instanceof InterruptedIOException) {
            throw new AnalysisException("Analysis cancelled", e);
        }
    }

    private RuleKey getParsingErrorRuleKey() {
        List<RuleKey> keys = this.checks.all().stream().filter(ParsingErrorCheck.class::isInstance).map(this.checks::ruleKeyFor).toList();
        return keys.isEmpty() ? null : keys.get(0);
    }
}

