/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.visitors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.sonar.php.tree.TreeUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;

public final class WordPressImportDetector {
    private static final Set<String> WORDPRESS_FILES = new HashSet<String>(Arrays.asList("wp-load.php", "wp-config.php", "wp-settings.php", "wp-blog-header.php", "wp-includes/wp-load.php", "wp-includes/wp-config.php", "wp-includes/functions.php", "wp-includes/load.php", "wp-includes/plugin.php", "wp-admin/admin.php", "wp-admin/includes/admin.php"));
    private static final Set<String> IMPORT_FUNCTIONS = new HashSet<String>(Arrays.asList("require", "require_once", "include", "include_once"));

    WordPressImportDetector() {
    }

    public static boolean isWordPressImport(FunctionCallTree tree) {
        String functionName = TreeUtils.functionName(tree);
        if (functionName == null || !WordPressImportDetector.isIncludeFunction(functionName)) {
            return false;
        }
        Optional<String> filePath = WordPressImportDetector.extractFilePath(tree);
        return filePath.isPresent() && WordPressImportDetector.isWordPressFile(filePath.get());
    }

    private static boolean isIncludeFunction(String functionName) {
        return IMPORT_FUNCTIONS.contains(functionName.toLowerCase(Locale.ROOT));
    }

    private static Optional<String> extractFilePath(FunctionCallTree tree) {
        return TreeUtils.argument(tree, "", 0).map(CallArgumentTree::value).map(WordPressImportDetector::extractPathFromExpression);
    }

    private static String extractPathFromExpression(ExpressionTree expression) {
        if (expression.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            expression = ((ParenthesisedExpressionTree)expression).expression();
        }
        if (expression.is(Tree.Kind.CONCATENATION)) {
            BinaryExpressionTree concat = (BinaryExpressionTree)expression;
            ExpressionTree right = concat.rightOperand();
            if (right.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
                return TreeUtils.trimQuotes((LiteralTree)right);
            }
            ExpressionTree left = concat.leftOperand();
            if (left.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
                String leftPath = TreeUtils.trimQuotes((LiteralTree)left);
                String rightPath = WordPressImportDetector.extractPathFromExpression(right);
                if (rightPath != null) {
                    return leftPath + rightPath;
                }
            }
        }
        if (expression.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            return TreeUtils.trimQuotes((LiteralTree)expression);
        }
        return null;
    }

    private static boolean isWordPressFile(String path) {
        if (path.isEmpty()) {
            return false;
        }
        String lowerPath = path.toLowerCase(Locale.ROOT);
        for (String wpFile : WORDPRESS_FILES) {
            if (!lowerPath.contains(wpFile)) continue;
            return true;
        }
        return false;
    }
}

