/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.visitors;

import org.sonar.php.tree.visitors.WordPressImportDetector;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.statement.UseClauseTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class FrameworkDetectionVisitor
extends PHPVisitorCheck {
    private SymbolTable.Framework framework = SymbolTable.Framework.EMPTY;

    @Override
    public void visitUseClause(UseClauseTree tree) {
        String nameSpaceName = tree.namespaceName().qualifiedName();
        if (nameSpaceName.startsWith("Drupal")) {
            this.framework = SymbolTable.Framework.DRUPAL;
        } else if (nameSpaceName.startsWith("Yii")) {
            this.framework = SymbolTable.Framework.YII;
        } else if (nameSpaceName.startsWith("Illuminate")) {
            this.framework = SymbolTable.Framework.LARAVEL;
        }
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        if (WordPressImportDetector.isWordPressImport(tree)) {
            this.framework = SymbolTable.Framework.WORDPRESS;
        }
    }

    public SymbolTable.Framework getFramework() {
        return this.framework;
    }
}

