/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.symbols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.php.symbols.ClassSymbolData;
import org.sonar.php.symbols.FunctionSymbolData;
import org.sonar.php.symbols.ProjectSymbolData;
import org.sonar.php.tree.symbols.DeclarationVisitor;
import org.sonar.php.tree.symbols.MemberSymbolImpl;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.php.tree.symbols.SymbolImpl;
import org.sonar.php.tree.symbols.SymbolQualifiedName;
import org.sonar.php.tree.symbols.SymbolUsageVisitor;
import org.sonar.php.tree.symbols.SymbolVisitor;
import org.sonar.php.tree.symbols.TypeSymbolImpl;
import org.sonar.php.tree.symbols.UndeclaredSymbol;
import org.sonar.php.tree.visitors.AssignmentExpressionVisitor;
import org.sonar.php.tree.visitors.FrameworkDetectionVisitor;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.symbols.TypeSymbol;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.visitors.PhpFile;

public class SymbolTableImpl
implements SymbolTable {
    private final List<Symbol> symbols = new ArrayList<Symbol>();
    private final Map<Tree, Scope> scopes = new HashMap<Tree, Scope>();
    private final Map<Tree, Symbol> symbolsByTree = new HashMap<Tree, Symbol>();
    private final Map<QualifiedName, Symbol> symbolByQualifiedName = new HashMap<QualifiedName, Symbol>();
    private Collection<ClassSymbolData> classSymbolData;
    private Collection<FunctionSymbolData> functionSymbolData;
    private SymbolTable.Framework framework = SymbolTable.Framework.EMPTY;

    private SymbolTableImpl() {
    }

    public static SymbolTableImpl create(CompilationUnitTree compilationUnit) {
        return SymbolTableImpl.create(compilationUnit, new ProjectSymbolData(), null);
    }

    public static SymbolTableImpl create(CompilationUnitTree compilationUnit, ProjectSymbolData projectSymbolData, @Nullable PhpFile file) {
        return SymbolTableImpl.create(compilationUnit, projectSymbolData, file, true);
    }

    public static SymbolTableImpl create(CompilationUnitTree compilationUnit, ProjectSymbolData projectSymbolData, @Nullable PhpFile file, boolean frameworkDetectionEnabled) {
        SymbolTableImpl symbolModel = new SymbolTableImpl();
        DeclarationVisitor declarationVisitor = new DeclarationVisitor(symbolModel, projectSymbolData, file);
        declarationVisitor.visitCompilationUnit(compilationUnit);
        symbolModel.classSymbolData = declarationVisitor.classSymbolData();
        symbolModel.functionSymbolData = declarationVisitor.functionSymbolData();
        new SymbolVisitor(symbolModel).visitCompilationUnit(compilationUnit);
        new SymbolUsageVisitor(symbolModel, declarationVisitor.classSymbolIndex(), declarationVisitor.functionSymbolIndex()).visitCompilationUnit(compilationUnit);
        compilationUnit.accept(new AssignmentExpressionVisitor());
        if (frameworkDetectionEnabled) {
            FrameworkDetectionVisitor frameworkDetectionVisitor = new FrameworkDetectionVisitor();
            compilationUnit.accept(frameworkDetectionVisitor);
            symbolModel.framework = frameworkDetectionVisitor.getFramework();
        }
        return symbolModel;
    }

    public static SymbolTableImpl create(Collection<ClassSymbolData> classSymbolData, Collection<FunctionSymbolData> functionSymbolData) {
        SymbolTableImpl symbolTable = new SymbolTableImpl();
        symbolTable.classSymbolData = classSymbolData;
        symbolTable.functionSymbolData = functionSymbolData;
        return symbolTable;
    }

    Scope addScope(Scope scope) {
        return this.scopes.computeIfAbsent(scope.tree(), t -> scope);
    }

    @Override
    public Set<Scope> getScopes() {
        return new HashSet<Scope>(this.scopes.values());
    }

    @Override
    @Nullable
    public Scope getScopeFor(Tree tree) {
        return this.scopes.get(tree);
    }

    @Override
    public SymbolTable.Framework getFramework() {
        return this.framework;
    }

    SymbolImpl declareSymbol(IdentifierTree name, Symbol.Kind kind, Scope scope, SymbolQualifiedName namespace) {
        SymbolImpl symbol;
        if (kind.hasQualifiedName()) {
            SymbolQualifiedName qualifiedName = namespace.resolve(name.text());
            symbol = new SymbolImpl(name, kind, scope, qualifiedName);
            this.symbolByQualifiedName.put(qualifiedName, symbol);
        } else {
            symbol = new SymbolImpl(name, kind, scope);
        }
        this.addSymbol(name, scope, symbol);
        return symbol;
    }

    private void addSymbol(IdentifierTree name, Scope scope, Symbol symbol) {
        this.symbols.add(symbol);
        scope.addSymbol(symbol);
        this.associateSymbol(name, symbol);
    }

    TypeSymbolImpl declareTypeSymbol(IdentifierTree name, Scope scope, SymbolQualifiedName qualifiedName) {
        TypeSymbolImpl symbol = new TypeSymbolImpl(name, scope, qualifiedName);
        this.symbolByQualifiedName.put(qualifiedName, symbol);
        this.addSymbol(name, scope, symbol);
        return symbol;
    }

    MemberSymbolImpl declareMemberSymbol(IdentifierTree name, Symbol.Kind kind, Scope scope, TypeSymbol owner) {
        MemberSymbolImpl memberSymbol = new MemberSymbolImpl(name, kind, scope, owner);
        this.symbolByQualifiedName.put(memberSymbol.qualifiedName(), memberSymbol);
        this.addSymbol(name, scope, memberSymbol);
        return memberSymbol;
    }

    SymbolImpl createUndeclaredSymbol(QualifiedName fullyQualifiedName, Symbol.Kind kind) {
        UndeclaredSymbol undeclaredSymbol = new UndeclaredSymbol(fullyQualifiedName, kind);
        this.symbolByQualifiedName.put(fullyQualifiedName, undeclaredSymbol);
        return undeclaredSymbol;
    }

    public List<Symbol> getSymbols() {
        return Collections.unmodifiableList(this.symbols);
    }

    @Override
    public List<Symbol> getSymbols(Symbol.Kind kind) {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (Symbol symbol : this.getSymbols()) {
            if (kind != symbol.kind()) continue;
            result.add(symbol);
        }
        return result;
    }

    public List<Symbol> getSymbols(String name) {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        for (Symbol symbol : this.getSymbols()) {
            if (!symbol.called(name)) continue;
            result.add(symbol);
        }
        return result;
    }

    Symbol getSymbol(QualifiedName qualifiedName) {
        return this.symbolByQualifiedName.get(qualifiedName);
    }

    Symbol getSymbol(String qualifiedName) {
        return this.getSymbol(SymbolQualifiedName.qualifiedName(qualifiedName));
    }

    void associateSymbol(Tree identifier, Symbol symbol) {
        this.symbolsByTree.putIfAbsent(identifier, symbol);
    }

    @Override
    @CheckForNull
    public Symbol getSymbol(Tree tree) {
        return this.symbolsByTree.get(tree);
    }

    public Collection<ClassSymbolData> classSymbolDatas() {
        return this.classSymbolData;
    }

    public Collection<FunctionSymbolData> functionSymbolDatas() {
        return this.functionSymbolData;
    }
}

