/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.symbols;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonar.php.utils.collections.ListUtils;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;

public class SymbolQualifiedName
implements QualifiedName {
    static final SymbolQualifiedName GLOBAL_NAMESPACE = new SymbolQualifiedName(Collections.emptyList());
    private final List<String> nameElements;

    private SymbolQualifiedName(List<String> parentNamespaces, String name) {
        this(ListUtils.concat(parentNamespaces, Collections.singletonList(name)));
    }

    private SymbolQualifiedName(List<String> nameElements) {
        this.nameElements = nameElements.stream().map(name -> name.toLowerCase(Locale.ROOT)).toList();
    }

    public static SymbolQualifiedName qualifiedName(String qualifiedNameString) {
        String qn = qualifiedNameString.startsWith("\\") ? qualifiedNameString.substring(1) : qualifiedNameString;
        return SymbolQualifiedName.create(qn.split("\\\\"));
    }

    public static SymbolQualifiedName create(String ... names) {
        int length = names.length;
        if (length == 0) {
            throw new IllegalStateException("Cannot create an empty qualified name");
        }
        return new SymbolQualifiedName(Arrays.asList(names));
    }

    public static SymbolQualifiedName create(NamespaceNameTree nameTree) {
        List<String> namespaces = nameTree.namespaces().stream().map(NameIdentifierTree::text).toList();
        return new SymbolQualifiedName(namespaces, nameTree.name().text());
    }

    SymbolQualifiedName resolve(SymbolQualifiedName nameInNamespace) {
        List<String> newName = ListUtils.concat(this.nameElements, nameInNamespace.nameElements);
        return new SymbolQualifiedName(newName);
    }

    SymbolQualifiedName resolveAliasedName(NamespaceNameTree namespaceNameTree) {
        if (namespaceNameTree.namespaces().isEmpty()) {
            throw new IllegalStateException("Unable to resolve " + String.valueOf(namespaceNameTree) + " which has only aliased name");
        }
        ArrayList<String> nameElements = new ArrayList<String>(this.nameElements);
        namespaceNameTree.namespaces().stream().skip(1L).map(NameIdentifierTree::text).forEach(nameElements::add);
        nameElements.add(namespaceNameTree.name().text());
        return new SymbolQualifiedName(nameElements);
    }

    SymbolQualifiedName resolve(String name) {
        return new SymbolQualifiedName(this.nameElements, name);
    }

    @Override
    public String simpleName() {
        return ListUtils.getLast(this.nameElements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        SymbolQualifiedName that = (SymbolQualifiedName)o;
        return Objects.equals(this.nameElements, that.nameElements);
    }

    public int hashCode() {
        return Objects.hash(this.nameElements);
    }

    public String toString() {
        return this.nameElements.stream().collect(Collectors.joining("\\"));
    }
}

