/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.statement;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.SeparatedListImpl;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.DeclareStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class DeclareStatementTreeImpl
extends PHPTree
implements DeclareStatementTree {
    private static final Tree.Kind KIND = Tree.Kind.DECLARE_STATEMENT;
    private final DeclareStatementHead declareStatementHead;
    private final SyntaxToken colonToken;
    private final List<StatementTree> statements;
    private final SyntaxToken endDeclareToken;
    private final SyntaxToken eosToken;

    public DeclareStatementTreeImpl(DeclareStatementHead declareStatementHead, InternalSyntaxToken eosToken) {
        this.declareStatementHead = declareStatementHead;
        this.colonToken = null;
        this.statements = Collections.emptyList();
        this.endDeclareToken = null;
        this.eosToken = eosToken;
    }

    public DeclareStatementTreeImpl(DeclareStatementHead declareStatementHead, StatementTree statement) {
        this.declareStatementHead = declareStatementHead;
        this.statements = Collections.singletonList(statement);
        this.colonToken = null;
        this.endDeclareToken = null;
        this.eosToken = null;
    }

    public DeclareStatementTreeImpl(DeclareStatementHead declareStatementHead, InternalSyntaxToken colonToken, List<StatementTree> statements, InternalSyntaxToken enddeclareToken, InternalSyntaxToken eosToken) {
        this.declareStatementHead = declareStatementHead;
        this.colonToken = colonToken;
        this.statements = statements;
        this.endDeclareToken = enddeclareToken;
        this.eosToken = eosToken;
    }

    @Override
    public SyntaxToken declareToken() {
        return this.declareStatementHead.declareToken();
    }

    @Override
    public SyntaxToken openParenthesisToken() {
        return this.declareStatementHead.openParenthesisToken();
    }

    public SeparatedListImpl<VariableDeclarationTree> directives() {
        return this.declareStatementHead.directives();
    }

    @Override
    public SyntaxToken closeParenthesisToken() {
        return this.declareStatementHead.closeParenthesisToken();
    }

    @Override
    @Nullable
    public SyntaxToken colonToken() {
        return this.colonToken;
    }

    @Override
    public List<StatementTree> statements() {
        return this.statements;
    }

    @Override
    @Nullable
    public SyntaxToken endDeclareToken() {
        return this.endDeclareToken;
    }

    @Override
    @Nullable
    public SyntaxToken eosToken() {
        return this.eosToken;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.concat(IteratorUtils.iteratorOf(this.declareStatementHead.declareToken(), this.declareStatementHead.openParenthesisToken()), this.declareStatementHead.directives().elementsAndSeparators(), IteratorUtils.iteratorOf(this.declareStatementHead.closeParenthesisToken(), this.colonToken), this.statements.iterator(), IteratorUtils.iteratorOf(this.endDeclareToken, this.eosToken));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitDeclareStatement(this);
    }

    public static class DeclareStatementHead {
        private final SyntaxToken declareToken;
        private final SyntaxToken openParenthesisToken;
        private final SeparatedListImpl<VariableDeclarationTree> directives;
        private final SyntaxToken closeParenthesisToken;

        public DeclareStatementHead(SyntaxToken declareToken, SyntaxToken openParenthesisToken, SeparatedListImpl<VariableDeclarationTree> directives, SyntaxToken closeParenthesisToken) {
            this.declareToken = declareToken;
            this.openParenthesisToken = openParenthesisToken;
            this.directives = directives;
            this.closeParenthesisToken = closeParenthesisToken;
        }

        public SyntaxToken declareToken() {
            return this.declareToken;
        }

        public SyntaxToken openParenthesisToken() {
            return this.openParenthesisToken;
        }

        public SeparatedListImpl<VariableDeclarationTree> directives() {
            return this.directives;
        }

        public SyntaxToken closeParenthesisToken() {
            return this.closeParenthesisToken;
        }
    }
}

