/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.declaration;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.declaration.CombinedTypeTreeImpl;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.AttributeGroupTree;
import org.sonar.plugins.php.api.tree.declaration.DeclaredTypeTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.declaration.PropertyHookListTree;
import org.sonar.plugins.php.api.tree.declaration.TypeTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class ParameterTreeImpl
extends PHPTree
implements ParameterTree {
    private static final Tree.Kind KIND = Tree.Kind.PARAMETER;
    private final List<AttributeGroupTree> attributeGroups;
    private final List<SyntaxToken> promotionModifiers;
    private final DeclaredTypeTree type;
    private final InternalSyntaxToken referenceToken;
    private final InternalSyntaxToken ellipsisToken;
    private final VariableIdentifierTree variableIdentifier;
    private final InternalSyntaxToken equalToken;
    private final ExpressionTree initValue;
    @Nullable
    private final PropertyHookListTree propertyHookList;
    private SyntaxToken readonlyToken;
    private SyntaxToken visibility;
    private SyntaxToken finalToken;

    public ParameterTreeImpl(List<AttributeGroupTree> attributeGroups, List<SyntaxToken> promotionModifiers, @Nullable DeclaredTypeTree type, @Nullable InternalSyntaxToken referenceToken, @Nullable InternalSyntaxToken ellipsisToken, VariableIdentifierTree variableIdentifier, @Nullable InternalSyntaxToken equalToken, @Nullable ExpressionTree initValue, @Nullable PropertyHookListTree propertyHookList) {
        this.attributeGroups = attributeGroups;
        this.promotionModifiers = promotionModifiers;
        for (SyntaxToken token : promotionModifiers) {
            if ("readonly".equals(token.text())) {
                this.readonlyToken = token;
                continue;
            }
            if ("final".equals(token.text())) {
                this.finalToken = token;
                continue;
            }
            this.visibility = token;
        }
        this.type = type;
        this.referenceToken = referenceToken;
        this.ellipsisToken = ellipsisToken;
        this.variableIdentifier = variableIdentifier;
        this.equalToken = equalToken;
        this.initValue = initValue;
        this.propertyHookList = propertyHookList;
    }

    @Override
    public List<AttributeGroupTree> attributeGroups() {
        return this.attributeGroups;
    }

    @Override
    @Nullable
    public SyntaxToken visibility() {
        return this.visibility;
    }

    @Override
    @Nullable
    @Deprecated
    public TypeTree type() {
        if (this.type == null) {
            return null;
        }
        if (this.type.is(Tree.Kind.TYPE)) {
            return (TypeTree)this.type;
        }
        return (TypeTree)((CombinedTypeTreeImpl)((Object)this.type)).types().get(0);
    }

    @Override
    public DeclaredTypeTree declaredType() {
        return this.type;
    }

    @Override
    @Nullable
    public SyntaxToken referenceToken() {
        return this.referenceToken;
    }

    @Override
    @Nullable
    public SyntaxToken ellipsisToken() {
        return this.ellipsisToken;
    }

    @Override
    public VariableIdentifierTree variableIdentifier() {
        return this.variableIdentifier;
    }

    @Override
    @Nullable
    public SyntaxToken equalToken() {
        return this.equalToken;
    }

    @Override
    @Nullable
    public ExpressionTree initValue() {
        return this.initValue;
    }

    @Override
    @Nullable
    public PropertyHookListTree propertyHookList() {
        return this.propertyHookList;
    }

    @Override
    @Nullable
    public SyntaxToken readonlyToken() {
        return this.readonlyToken;
    }

    @Override
    @Nullable
    public SyntaxToken finalToken() {
        return this.finalToken;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.concat(this.attributeGroups.iterator(), this.promotionModifiers.iterator(), IteratorUtils.iteratorOf(this.type, this.referenceToken, this.ellipsisToken, this.variableIdentifier, this.equalToken, this.initValue), IteratorUtils.nullableIterator(this.propertyHookList));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitParameter(this);
    }
}

