/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.utils.collections.ListUtils;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.AttributeGroupTree;
import org.sonar.plugins.php.api.tree.declaration.AttributeTree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;

public class TreeUtils {
    private TreeUtils() {
    }

    public static boolean isDescendant(Tree tree, Tree potentialParent) {
        Tree parent;
        for (parent = tree; parent != null && !potentialParent.equals(parent); parent = parent.getParent()) {
        }
        return potentialParent.equals(parent);
    }

    @CheckForNull
    public static Tree findAncestorWithKind(Tree tree, Collection<Tree.Kind> kinds) {
        Tree parent;
        for (parent = tree; parent != null && !kinds.contains(parent.getKind()); parent = parent.getParent()) {
        }
        return parent;
    }

    @CheckForNull
    public static Tree findAncestorWithKind(Tree tree, Tree.Kind ... kinds) {
        return TreeUtils.findAncestorWithKind(tree, Arrays.asList(kinds));
    }

    public static Stream<Tree> descendants(@Nullable Tree root) {
        if (root == null || ((PHPTree)root).isLeaf()) {
            return Stream.empty();
        }
        Spliterator<Tree> spliterator = Spliterators.spliteratorUnknownSize(((PHPTree)root).childrenIterator(), 16);
        Stream<Tree> stream = StreamSupport.stream(spliterator, false);
        return stream.flatMap(tree -> Stream.concat(Stream.of(tree), TreeUtils.descendants(tree)));
    }

    public static <T extends Tree> Stream<T> descendants(@Nullable Tree root, Class<T> clazz) {
        return TreeUtils.descendants(root).filter(clazz::isInstance).map(clazz::cast);
    }

    public static Optional<Tree> firstDescendant(@Nullable Tree root, Predicate<Tree> predicate) {
        return TreeUtils.descendants(root).filter(predicate).findFirst();
    }

    public static <T extends Tree> Optional<T> firstDescendant(Tree root, Class<T> clazz) {
        return TreeUtils.firstDescendant(root, clazz::isInstance);
    }

    public static boolean hasAnnotationOrAttribute(MethodDeclarationTree tree, String name) {
        if (TreeUtils.hasAnnotation(tree, name)) {
            return true;
        }
        String lowerCaseName = name.toLowerCase(Locale.ROOT);
        for (AttributeGroupTree attributeGroup : tree.attributeGroups()) {
            for (AttributeTree attribute : attributeGroup.attributes()) {
                String attributeName = attribute.name().fullyQualifiedName();
                String simpleName = attributeName.substring(attributeName.lastIndexOf(92) + 1);
                if (!simpleName.toLowerCase(Locale.ROOT).equals(lowerCaseName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAnnotation(Tree declaration, String annotation) {
        List<SyntaxTrivia> trivias;
        if (!((String)annotation).startsWith("@")) {
            annotation = "@" + (String)annotation;
        }
        if (!(trivias = ((PHPTree)declaration).getFirstToken().trivias()).isEmpty()) {
            return ListUtils.getLast(trivias).text().toLowerCase(Locale.ROOT).contains(((String)annotation).toLowerCase(Locale.ROOT));
        }
        return false;
    }

    @Nullable
    public static String functionName(FunctionCallTree functionCall) {
        ExpressionTree callee = functionCall.callee();
        if (callee.is(Tree.Kind.CLASS_MEMBER_ACCESS) || callee.is(Tree.Kind.OBJECT_MEMBER_ACCESS)) {
            return TreeUtils.nameOf(((MemberAccessTree)callee).member());
        }
        return TreeUtils.nameOf(callee);
    }

    @Nullable
    public static String nameOf(Tree tree) {
        ClassDeclarationTree classDeclaration;
        VariableIdentifierTree variableIdentifier;
        if (tree.is(Tree.Kind.NAMESPACE_NAME)) {
            return ((NamespaceNameTree)tree).qualifiedName();
        }
        if (tree.is(Tree.Kind.NAME_IDENTIFIER)) {
            return ((NameIdentifierTree)tree).text();
        }
        if (tree.is(Tree.Kind.CLASS_MEMBER_ACCESS) || tree.is(Tree.Kind.OBJECT_MEMBER_ACCESS)) {
            MemberAccessTree memberAccess = (MemberAccessTree)tree;
            String className = TreeUtils.nameOf(memberAccess.object());
            String memberName = TreeUtils.nameOf(memberAccess.member());
            if (className != null && memberName != null) {
                return className + "::" + memberName;
            }
        } else if (tree.is(Tree.Kind.VARIABLE_IDENTIFIER) && "$this".equals((variableIdentifier = (VariableIdentifierTree)tree).text()) && (classDeclaration = (ClassDeclarationTree)TreeUtils.findAncestorWithKind(tree, EnumSet.of(Tree.Kind.CLASS_DECLARATION, Tree.Kind.TRAIT_DECLARATION))) != null) {
            return TreeUtils.nameOf(classDeclaration.name());
        }
        return null;
    }

    public static Optional<CallArgumentTree> argument(FunctionCallTree call, String name, int position) {
        SeparatedList<CallArgumentTree> callArguments = call.callArguments();
        CallArgumentTree argument = callArguments.stream().filter(a -> a.name() != null).filter(a -> a.name().text().equalsIgnoreCase(name)).findFirst().orElse(null);
        if (argument != null) {
            return Optional.of(argument);
        }
        if (callArguments.size() >= position + 1 && ((CallArgumentTree)callArguments.get(position)).name() == null) {
            return Optional.of((CallArgumentTree)callArguments.get(position));
        }
        return Optional.empty();
    }

    public static String trimQuotes(LiteralTree literalTree) {
        if (literalTree.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            String value = literalTree.value();
            return value.substring(1, value.length() - 1);
        }
        throw new IllegalArgumentException("Cannot trim quotes from non-string literal");
    }
}

