/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.symbols;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.php.symbols.FunctionSymbol;
import org.sonar.php.symbols.FunctionSymbolData;
import org.sonar.php.symbols.Parameter;
import org.sonar.php.symbols.ProjectSymbolData;
import org.sonar.php.symbols.UnknownFunctionSymbol;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.symbols.ReturnType;
import org.sonar.plugins.php.api.visitors.LocationInFile;

public class FunctionSymbolIndex {
    private final Map<QualifiedName, FunctionSymbol> symbolsByQualifiedName = new HashMap<QualifiedName, FunctionSymbol>();
    private final Map<FunctionSymbolData, FunctionSymbol> symbolsByData = new HashMap<FunctionSymbolData, FunctionSymbol>();
    private final ProjectSymbolData projectSymbolData;

    public FunctionSymbolIndex(ProjectSymbolData projectSymbolData) {
        this.projectSymbolData = projectSymbolData;
    }

    public static FunctionSymbolIndex create(List<FunctionSymbolData> fileDeclarations, ProjectSymbolData projectSymbolData) {
        FunctionSymbolIndex index = new FunctionSymbolIndex(projectSymbolData);
        index.init(fileDeclarations);
        return index;
    }

    private void init(List<FunctionSymbolData> fileDeclarations) {
        for (FunctionSymbolData data : fileDeclarations) {
            FunctionSymbolImpl symbol = new FunctionSymbolImpl(data);
            this.symbolsByQualifiedName.put(symbol.qualifiedName(), symbol);
            this.symbolsByData.put(data, symbol);
        }
    }

    public FunctionSymbol get(QualifiedName qualifiedName) {
        return this.symbolsByQualifiedName.computeIfAbsent(qualifiedName, qn -> {
            List<FunctionSymbolData> all = this.projectSymbolData.functionSymbolData((QualifiedName)qn);
            if (all.size() == 1) {
                return new FunctionSymbolImpl(all.get(0));
            }
            return new UnknownFunctionSymbol(qualifiedName);
        });
    }

    public FunctionSymbol get(FunctionSymbolData symbolData) {
        return this.symbolsByData.get(symbolData);
    }

    protected static class FunctionSymbolImpl
    implements FunctionSymbol {
        private final FunctionSymbolData data;

        protected FunctionSymbolImpl(FunctionSymbolData data) {
            this.data = data;
        }

        @Override
        public LocationInFile location() {
            return this.data.location();
        }

        @Override
        public QualifiedName qualifiedName() {
            return this.data.qualifiedName();
        }

        @Override
        public boolean hasReturn() {
            return this.data.hasReturn();
        }

        @Override
        public boolean hasFuncGetArgs() {
            return this.data.hasFuncGetArgs();
        }

        @Override
        public List<Parameter> parameters() {
            return this.data.parameters();
        }

        @Override
        public ReturnType returnType() {
            return this.data.returnType();
        }

        @Override
        public boolean isUnknownSymbol() {
            return false;
        }
    }
}

