/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.symbols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.php.symbols.AbstractClassSymbol;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.ClassSymbolData;
import org.sonar.php.symbols.MethodSymbol;
import org.sonar.php.symbols.MethodSymbolData;
import org.sonar.php.symbols.MethodSymbolImpl;
import org.sonar.php.symbols.ProjectSymbolData;
import org.sonar.php.symbols.UnknownClassSymbol;
import org.sonar.php.symbols.UnknownMethodSymbol;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.visitors.LocationInFile;

public class ClassSymbolIndex {
    private final Map<QualifiedName, ClassSymbol> symbolsByQualifiedName = new HashMap<QualifiedName, ClassSymbol>();
    private final Map<ClassSymbolData, ClassSymbolImpl> symbolsByData = new HashMap<ClassSymbolData, ClassSymbolImpl>();
    private final ProjectSymbolData projectSymbolData;

    private ClassSymbolIndex(ProjectSymbolData projectSymbolData) {
        this.projectSymbolData = projectSymbolData;
    }

    public static ClassSymbolIndex create(List<ClassSymbolData> fileDeclarations, ProjectSymbolData projectSymbolData) {
        ClassSymbolIndex index = new ClassSymbolIndex(projectSymbolData);
        index.init(fileDeclarations);
        return index;
    }

    public ClassSymbol get(QualifiedName qualifiedName) {
        return this.symbolsByQualifiedName.computeIfAbsent(qualifiedName, qn -> this.projectSymbolData.classSymbolData((QualifiedName)qn).map(x$0 -> new ClassSymbolImpl((ClassSymbolData)x$0)).orElse(new UnknownClassSymbol(qualifiedName)));
    }

    public ClassSymbol get(ClassSymbolData classSymbolData) {
        return this.symbolsByData.get(classSymbolData);
    }

    private void init(List<ClassSymbolData> fileDeclarations) {
        for (ClassSymbolData data : fileDeclarations) {
            ClassSymbolImpl symbol = new ClassSymbolImpl(data);
            this.symbolsByQualifiedName.put(symbol.qualifiedName(), symbol);
            this.symbolsByData.put(data, symbol);
        }
    }

    private class ClassSymbolImpl
    extends AbstractClassSymbol {
        private final ClassSymbolData data;
        private final Map<String, MethodSymbol> methods;
        private ClassSymbol superClass;

        private ClassSymbolImpl(ClassSymbolData data) {
            this.data = data;
            this.methods = data.methods().stream().map(d -> new MethodSymbolImpl((MethodSymbolData)d, this)).collect(Collectors.toMap(m -> m.name().toLowerCase(Locale.ROOT), Function.identity(), (a, b) -> a));
        }

        @Override
        public LocationInFile location() {
            return this.data.location();
        }

        @Override
        public QualifiedName qualifiedName() {
            return this.data.qualifiedName();
        }

        @Override
        public Optional<ClassSymbol> superClass() {
            if (this.superClass == null) {
                this.data.superClass().ifPresent(name -> {
                    this.superClass = ClassSymbolIndex.this.get((QualifiedName)name);
                });
            }
            return Optional.ofNullable(this.superClass);
        }

        @Override
        public List<ClassSymbol> implementedInterfaces() {
            return this.data.implementedInterfaces().stream().map(ClassSymbolIndex.this::get).toList();
        }

        @Override
        public boolean is(ClassSymbol.Kind kind) {
            return kind == this.data.kind();
        }

        @Override
        public List<MethodSymbol> declaredMethods() {
            return new ArrayList<MethodSymbol>(this.methods.values());
        }

        @Override
        public MethodSymbol getDeclaredMethod(String name) {
            return this.methods.getOrDefault(name.toLowerCase(Locale.ROOT), new UnknownMethodSymbol(String.valueOf(this.qualifiedName()) + "::" + name));
        }

        @Override
        public boolean isUnknownSymbol() {
            return false;
        }
    }
}

