/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.php.metrics.MetricsVisitor;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

public class CounterVisitor
extends PHPSubscriptionCheck {
    private int functionCounter = 0;
    private int statementCounter = 0;
    private int classCounter = 0;
    private static final Tree.Kind[] STATEMENT_NODES = new Tree.Kind[]{Tree.Kind.USE_STATEMENT, Tree.Kind.NAMESPACE_STATEMENT, Tree.Kind.CONSTANT_DECLARATION, Tree.Kind.IF_STATEMENT, Tree.Kind.ALTERNATIVE_IF_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.FOREACH_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.BREAK_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.TRY_STATEMENT, Tree.Kind.EMPTY_STATEMENT, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.UNSET_VARIABLE_STATEMENT, Tree.Kind.LABEL, Tree.Kind.GOTO_STATEMENT, Tree.Kind.DECLARE_STATEMENT, Tree.Kind.STATIC_STATEMENT, Tree.Kind.GLOBAL_STATEMENT, Tree.Kind.CLASS_CONSTANT_PROPERTY_DECLARATION, Tree.Kind.CLASS_PROPERTY_DECLARATION, Tree.Kind.USE_TRAIT_DECLARATION};

    public CounterVisitor(Tree tree) {
        this.scanTree(tree);
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> result = new ArrayList<Tree.Kind>(Arrays.asList(MetricsVisitor.getFunctionNodes()));
        result.addAll(Arrays.asList(STATEMENT_NODES));
        result.addAll(Arrays.asList(MetricsVisitor.getClassNodes()));
        return result;
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(MetricsVisitor.getFunctionNodes())) {
            ++this.functionCounter;
        } else if (tree.is(STATEMENT_NODES)) {
            ++this.statementCounter;
        } else if (tree.is(MetricsVisitor.getClassNodes())) {
            ++this.classCounter;
        }
    }

    public int getFunctionNumber() {
        return this.functionCounter;
    }

    public int getStatementNumber() {
        return this.statementCounter;
    }

    public int getClassNumber() {
        return this.classCounter;
    }
}

