/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.metrics;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.ArrowFunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.php.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.php.api.tree.statement.ContinueStatementTree;
import org.sonar.plugins.php.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.GotoStatementTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public class CognitiveComplexityVisitor
extends PHPVisitorCheck {
    private CognitiveComplexity complexity = new CognitiveComplexity();
    private Set<IfStatementTree> ifStatementWithoutNesting = new HashSet<IfStatementTree>();
    private Set<ExpressionTree> nestedLogicalExpressions = new HashSet<ExpressionTree>();

    public static CognitiveComplexity complexity(FunctionTree functionTree) {
        CognitiveComplexityVisitor cognitiveComplexityVisitor = new CognitiveComplexityVisitor();
        cognitiveComplexityVisitor.scan(functionTree);
        return cognitiveComplexityVisitor.complexity;
    }

    public static int complexity(CompilationUnitTree cut) {
        class CompilationUnitVisitor
        extends CognitiveComplexityVisitor {
            private int functionsComplexity = 0;

            CompilationUnitVisitor() {
            }

            @Override
            public void visitMethodDeclaration(MethodDeclarationTree tree) {
                this.sumComplexity(tree);
            }

            @Override
            public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
                this.sumComplexity(tree);
            }

            @Override
            public void visitFunctionExpression(FunctionExpressionTree tree) {
                this.sumComplexity(tree);
            }

            @Override
            public void visitArrowFunctionExpression(ArrowFunctionExpressionTree tree) {
                this.sumComplexity(tree);
            }

            private void sumComplexity(FunctionTree tree) {
                this.functionsComplexity += CompilationUnitVisitor.complexity(tree).getValue();
            }

            private int complexityWithFunctionsAndRestOfSript() {
                int scriptComplexity = this.complexity.value;
                return this.functionsComplexity + scriptComplexity;
            }
        }
        CompilationUnitVisitor compilationUnitVisitor = new CompilationUnitVisitor();
        cut.accept(compilationUnitVisitor);
        return compilationUnitVisitor.complexityWithFunctionsAndRestOfSript();
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        if (this.ifStatementWithoutNesting.contains(tree)) {
            this.complexity.addComplexityWithoutNesting(tree.ifToken());
        } else {
            this.complexity.addComplexityWithNesting(tree.ifToken());
        }
        this.visit(tree.condition());
        this.visitWithNesting(tree.statements());
        tree.elseifClauses().forEach(this::visit);
        this.visit(tree.elseClause());
    }

    @Override
    public void visitElseifClause(ElseifClauseTree tree) {
        this.complexity.addComplexityWithoutNesting(tree.elseifToken());
        this.visit(tree.condition());
        this.visitWithNesting(tree.statements());
    }

    @Override
    public void visitElseClause(ElseClauseTree tree) {
        if (tree.is(Tree.Kind.ELSE_CLAUSE) && tree.statements().get(0).is(Tree.Kind.IF_STATEMENT)) {
            this.ifStatementWithoutNesting.add((IfStatementTree)tree.statements().get(0));
        } else {
            this.complexity.addComplexityWithoutNesting(tree.elseToken());
        }
        this.visitWithNesting(tree.statements());
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.complexity.addComplexityWithNesting(tree.switchToken());
        this.visitWithNesting(() -> super.visitSwitchStatement(tree));
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.complexity.addComplexityWithNesting(tree.whileToken());
        this.visit(tree.condition());
        this.visitWithNesting(tree.statements());
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.complexity.addComplexityWithNesting(tree.doToken());
        this.visitWithNesting(tree.statement());
        this.visit(tree.condition());
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.complexity.addComplexityWithNesting(tree.forToken());
        tree.init().forEach(this::visit);
        tree.condition().forEach(this::visit);
        tree.update().forEach(this::visit);
        this.visitWithNesting(tree.statements());
    }

    @Override
    public void visitForEachStatement(ForEachStatementTree tree) {
        this.complexity.addComplexityWithNesting(tree.foreachToken());
        this.visit(tree.expression());
        this.visit(tree.key());
        this.visit(tree.value());
        this.visitWithNesting(tree.statements());
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        this.complexity.addComplexityWithNesting(tree.catchToken());
        this.visitWithNesting(() -> super.visitCatchBlock(tree));
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.visitWithNesting(() -> super.visitFunctionDeclaration(tree));
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        this.visitWithNesting(() -> super.visitFunctionExpression(tree));
    }

    @Override
    public void visitArrowFunctionExpression(ArrowFunctionExpressionTree tree) {
        this.visitWithNesting(() -> super.visitArrowFunctionExpression(tree));
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        this.visitWithNesting(() -> super.visitMethodDeclaration(tree));
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        this.complexity.addComplexityWithNesting(tree.queryToken());
        this.visit(tree.condition());
        this.visitWithNesting(tree.trueExpression());
        this.visitWithNesting(tree.falseExpression());
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
        if (tree.argument() != null) {
            this.complexity.addComplexityWithoutNesting(tree.breakToken());
        }
        super.visitBreakStatement(tree);
    }

    @Override
    public void visitContinueStatement(ContinueStatementTree tree) {
        if (tree.argument() != null) {
            this.complexity.addComplexityWithoutNesting(tree.continueToken());
        }
        super.visitContinueStatement(tree);
    }

    @Override
    public void visitGotoStatement(GotoStatementTree tree) {
        this.complexity.addComplexityWithoutNesting(tree.gotoToken());
        super.visitGotoStatement(tree);
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.PIPE) && !this.nestedLogicalExpressions.contains(tree)) {
            ArrayList<SyntaxToken> flatOperators = new ArrayList<SyntaxToken>();
            this.flattenLogicalExpression(0, flatOperators, tree);
            if (tree.is(Tree.Kind.PIPE)) {
                this.handlePipeOpBinaryExpression(flatOperators);
            } else {
                this.handleAndOrBinaryExpression(flatOperators);
            }
        }
        super.visitBinaryExpression(tree);
    }

    private void handlePipeOpBinaryExpression(List<SyntaxToken> flatOperators) {
        this.complexity.addComplexityWithNesting(flatOperators.get(0));
        for (int i = 1; i < flatOperators.size(); ++i) {
            if (!flatOperators.get(i).text().equals(flatOperators.get(i - 1).text())) continue;
            this.complexity.addComplexityWithNesting(flatOperators.get(i));
        }
    }

    private void handleAndOrBinaryExpression(List<SyntaxToken> flatOperators) {
        this.complexity.addComplexityWithoutNesting(flatOperators.get(0));
        for (int i = 1; i < flatOperators.size(); ++i) {
            if (flatOperators.get(i).text().equals(flatOperators.get(i - 1).text())) continue;
            this.complexity.addComplexityWithoutNesting(flatOperators.get(i));
        }
    }

    private void flattenLogicalExpression(int i, List<SyntaxToken> operators, ExpressionTree expression) {
        if (expression.is(Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.PIPE)) {
            this.nestedLogicalExpressions.add(expression);
            BinaryExpressionTree binaryExpression = (BinaryExpressionTree)expression;
            operators.add(i, binaryExpression.operator());
            ExpressionTree leftChild = CognitiveComplexityVisitor.removeParenthesis(binaryExpression.leftOperand());
            ExpressionTree rightChild = CognitiveComplexityVisitor.removeParenthesis(binaryExpression.rightOperand());
            this.flattenLogicalExpression(i + 1, operators, rightChild);
            this.flattenLogicalExpression(i, operators, leftChild);
        }
    }

    private void visitWithNesting(@Nullable Tree tree) {
        if (tree != null) {
            this.visitWithNesting(() -> tree.accept(this));
        }
    }

    private void visitWithNesting(List<StatementTree> statements) {
        this.visitWithNesting(() -> statements.forEach(statementTree -> statementTree.accept(this)));
    }

    private void visitWithNesting(Runnable action) {
        this.complexity.incNesting();
        action.run();
        this.complexity.decNesting();
    }

    private void visit(@Nullable Tree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    private static ExpressionTree removeParenthesis(ExpressionTree expressionTree) {
        if (expressionTree.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            return CognitiveComplexityVisitor.removeParenthesis(((ParenthesisedExpressionTree)expressionTree).expression());
        }
        return expressionTree;
    }

    public static class CognitiveComplexity {
        private List<ComplexityComponent> complexityComponents = new ArrayList<ComplexityComponent>();
        private int value = 0;
        private int level = 0;

        public List<ComplexityComponent> getComplexityComponents() {
            return this.complexityComponents;
        }

        public int getValue() {
            return this.value;
        }

        private void incNesting() {
            ++this.level;
        }

        private void decNesting() {
            --this.level;
        }

        private void addComplexityWithNesting(SyntaxToken secondaryLocationToken) {
            this.addComplexityWithoutNesting(secondaryLocationToken, this.level + 1);
        }

        private void addComplexityWithoutNesting(SyntaxToken secondaryLocationToken) {
            this.addComplexityWithoutNesting(secondaryLocationToken, 1);
        }

        private void addComplexityWithoutNesting(SyntaxToken secondaryLocationToken, int addedComplexity) {
            this.value += addedComplexity;
            this.complexityComponents.add(new ComplexityComponent(secondaryLocationToken, addedComplexity));
        }
    }

    public static class ComplexityComponent {
        private Tree tree;
        private int addedComplexity;

        private ComplexityComponent(Tree tree, int addedComplexity) {
            this.tree = tree;
            this.addedComplexity = addedComplexity;
        }

        public Tree tree() {
            return this.tree;
        }

        public int addedComplexity() {
            return this.addedComplexity;
        }
    }
}

