/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.Symbols;
import org.sonar.php.tree.TreeUtils;
import org.sonar.php.tree.impl.VariableIdentifierTreeImpl;
import org.sonar.php.tree.symbols.SymbolImpl;
import org.sonar.php.utils.collections.MapBuilder;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.ArrayInitializerTree;
import org.sonar.plugins.php.api.tree.expression.ArrayPairTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.InlineHTMLTree;
import org.sonar.plugins.php.api.visitors.PhpFile;

public final class CheckUtils {
    private static final Tree.Kind[] FUNCTION_KINDS_ARRAY = new Tree.Kind[]{Tree.Kind.METHOD_DECLARATION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.ARROW_FUNCTION_EXPRESSION};
    static final List<Tree.Kind> FUNCTION_KINDS = Arrays.asList(FUNCTION_KINDS_ARRAY);
    static final Map<String, String> SUPERGLOBALS_BY_OLD_NAME = MapBuilder.builder().put("$HTTP_SERVER_VARS", "$_SERVER").put("$HTTP_GET_VARS", "$_GET").put("$HTTP_POST_VARS", "$_POST").put("$HTTP_POST_FILES", "$_FILES").put("$HTTP_SESSION_VARS", "$_SESSION").put("$HTTP_ENV_VARS", "$_ENV").put("$HTTP_COOKIE_VARS", "$_COOKIE").build();
    public static final Set<String> SUPERGLOBALS = Set.of("$GLOBALS", "$_SERVER", "$_GET", "$_POST", "$_FILES", "$_COOKIE", "$_SESSION", "$_REQUEST", "$_ENV");
    public static final Set<String> MAGIC_METHODS = Set.of("__construct", "__destruct", "__call", "__callStatic", "__get", "__set", "__isset", "__unset", "__sleep", "__wakeup", "__toString", "__invoke", "__set_state", "__clone", "__debugInfo", "__serialize", "__unserialize");

    private CheckUtils() {
    }

    public static Map<String, String> getSuperGlobalsByOldName() {
        return SUPERGLOBALS_BY_OLD_NAME;
    }

    public static List<Tree.Kind> getFunctionKinds() {
        return FUNCTION_KINDS;
    }

    public static boolean isFunction(Tree tree) {
        return tree.is(FUNCTION_KINDS_ARRAY);
    }

    public static String getFunctionName(FunctionTree functionDec) {
        if (functionDec.is(Tree.Kind.FUNCTION_DECLARATION)) {
            return "\"" + ((FunctionDeclarationTree)functionDec).name().text() + "\"";
        }
        if (functionDec.is(Tree.Kind.METHOD_DECLARATION)) {
            return "\"" + ((MethodDeclarationTree)functionDec).name().text() + "\"";
        }
        return "expression";
    }

    @Nullable
    public static String getFunctionName(FunctionCallTree functionCall) {
        return CheckUtils.nameOf(functionCall.callee());
    }

    @Nullable
    public static String getLowerCaseFunctionName(FunctionCallTree functionCall) {
        String name = CheckUtils.getFunctionName(functionCall);
        return name != null ? name.toLowerCase(Locale.ROOT) : null;
    }

    @Nullable
    public static String functionName(FunctionCallTree functionCall) {
        return TreeUtils.functionName(functionCall);
    }

    @Nullable
    public static String lowerCaseFunctionName(FunctionCallTree functionCall) {
        String name = CheckUtils.functionName(functionCall);
        return name != null ? name.toLowerCase(Locale.ROOT) : null;
    }

    public static Set<String> lowerCaseSet(String ... names) {
        return Arrays.stream(names).map(name -> name.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
    }

    public static String getClassName(ClassDeclarationTree classDeclaration) {
        return Objects.requireNonNull(CheckUtils.nameOf(classDeclaration.name()));
    }

    public static String getLowerCaseClassName(ClassDeclarationTree classDeclarationTree) {
        return CheckUtils.getClassName(classDeclarationTree).toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static String nameOf(Tree tree) {
        return TreeUtils.nameOf(tree);
    }

    public static boolean isExitExpression(FunctionCallTree functionCallTree) {
        String callee = functionCallTree.callee().toString();
        return "die".equalsIgnoreCase(callee) || "exit".equalsIgnoreCase(callee);
    }

    public static boolean hasModifier(ClassMemberTree tree, String toFind) {
        if (tree.is(Tree.Kind.METHOD_DECLARATION)) {
            return CheckUtils.hasModifier(((MethodDeclarationTree)tree).modifiers(), toFind);
        }
        if (tree.is(Tree.Kind.CLASS_PROPERTY_DECLARATION)) {
            return CheckUtils.hasModifier(((ClassPropertyDeclarationTree)tree).modifierTokens(), toFind);
        }
        return false;
    }

    public static boolean hasModifier(List<SyntaxToken> modifiers, String toFind) {
        for (SyntaxToken modifier : modifiers) {
            if (!modifier.text().equalsIgnoreCase(toFind)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClosingTag(SyntaxToken token) {
        if (token.is(Tree.Kind.INLINE_HTML_TOKEN)) {
            String text = token.text().trim();
            return "?>".equals(text) || "%>".equals(text);
        }
        return false;
    }

    public static boolean isClosingTag(Tree tree) {
        if (tree.is(Tree.Kind.INLINE_HTML)) {
            return CheckUtils.isClosingTag(((InlineHTMLTree)tree).inlineHTMLToken());
        }
        return false;
    }

    public static Stream<String> lines(PhpFile file) {
        return new BufferedReader(new StringReader(file.contents())).lines();
    }

    public static ExpressionTree skipParenthesis(ExpressionTree expr) {
        if (expr.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            return CheckUtils.skipParenthesis(((ParenthesisedExpressionTree)expr).expression());
        }
        return expr;
    }

    @Nullable
    public static ExpressionTree getForCondition(ForStatementTree tree) {
        if (tree.condition().isEmpty()) {
            return null;
        }
        return (ExpressionTree)tree.condition().get(tree.condition().size() - 1);
    }

    public static String trimQuotes(String value) {
        if (value.length() > 1 && (value.startsWith("'") || value.startsWith("\""))) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static String trimQuotes(LiteralTree literalTree) {
        return TreeUtils.trimQuotes(literalTree);
    }

    public static boolean isFalseValue(ExpressionTree tree) {
        if (tree.is(Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.NUMERIC_LITERAL)) {
            String value = ((LiteralTree)tree).value();
            return "false".equalsIgnoreCase(value) || "0".equals(value) || "0.0".equals(value);
        }
        if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            String value = CheckUtils.trimQuotes(((LiteralTree)tree).value());
            return value == null || value.isEmpty() || "0".equals(value);
        }
        return tree.is(Tree.Kind.NULL_LITERAL);
    }

    public static boolean isTrueValue(ExpressionTree tree) {
        return tree.is(Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.REGULAR_STRING_LITERAL, Tree.Kind.NULL_LITERAL) && !CheckUtils.isFalseValue(tree);
    }

    public static boolean isStringLiteralWithValue(@Nullable Tree tree, String s) {
        return tree != null && tree.is(Tree.Kind.REGULAR_STRING_LITERAL) && s.equalsIgnoreCase(CheckUtils.trimQuotes((LiteralTree)tree));
    }

    public static boolean argumentIsStringLiteralWithValue(CallArgumentTree argument, String s) {
        return CheckUtils.isStringLiteralWithValue(CheckUtils.assignedValue(argument.value()), s);
    }

    public static boolean isNullOrEmptyString(ExpressionTree tree) {
        if (tree.is(Tree.Kind.NULL_LITERAL)) {
            return true;
        }
        if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
            String value = CheckUtils.trimQuotes(((LiteralTree)tree).value());
            return value.trim().isEmpty();
        }
        return false;
    }

    public static boolean isPublic(ClassMemberTree tree) {
        return !tree.is(Tree.Kind.USE_TRAIT_DECLARATION) && !CheckUtils.hasModifier(tree, "private") && !CheckUtils.hasModifier(tree, "protected");
    }

    public static boolean isStatic(ClassMemberTree tree) {
        return CheckUtils.hasModifier(tree, "static");
    }

    public static Optional<CallArgumentTree> argument(FunctionCallTree call, String name, int position) {
        return TreeUtils.argument(call, name, position);
    }

    public static Optional<LiteralTree> resolvedArgumentLiteral(FunctionCallTree call, String name, int position) {
        return CheckUtils.argumentValue(call, name, position).map(CheckUtils::assignedValue).filter(LiteralTree.class::isInstance).map(LiteralTree.class::cast);
    }

    public static Optional<ExpressionTree> argumentValue(FunctionCallTree call, String name, int position) {
        return CheckUtils.argument(call, name, position).map(CallArgumentTree::value);
    }

    public static List<ExpressionTree> argumentsOfKind(FunctionCallTree call, Tree.Kind kind) {
        return call.callArguments().stream().map(CallArgumentTree::value).filter(arg -> arg.is(kind)).toList();
    }

    public static boolean hasNamedArgument(FunctionCallTree call) {
        return call.callArguments().stream().anyMatch(arg -> arg.name() != null);
    }

    public static ExpressionTree assignedValue(ExpressionTree tree) {
        if (tree.is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            return CheckUtils.uniqueAssignedValue((VariableIdentifierTree)tree).orElse(tree);
        }
        return tree;
    }

    public static Optional<ExpressionTree> uniqueAssignedValue(VariableIdentifierTree tree) {
        SymbolImpl symbol = ((VariableIdentifierTreeImpl)tree).symbol();
        if (symbol != null) {
            return symbol.uniqueAssignedValue();
        }
        return Optional.empty();
    }

    public static Optional<String> resolveReceiver(MemberAccessTree tree) {
        ExpressionTree receiver = CheckUtils.skipParenthesis(CheckUtils.assignedValue(tree.object()));
        if (receiver.is(Tree.Kind.NEW_EXPRESSION)) {
            ExpressionTree newExpression = ((NewExpressionTree)receiver).expression();
            return Optional.ofNullable(newExpression.is(Tree.Kind.FUNCTION_CALL) ? CheckUtils.functionName((FunctionCallTree)newExpression) : CheckUtils.nameOf(newExpression));
        }
        return Optional.empty();
    }

    public static Optional<ExpressionTree> arrayValue(ArrayInitializerTree array, String searchKey) {
        return CheckUtils.arrayValue(array.arrayPairs(), searchKey);
    }

    public static Optional<ExpressionTree> arrayValue(List<ArrayPairTree> arrayPairs, String searchKey) {
        for (ArrayPairTree arrayPair : arrayPairs) {
            ExpressionTree key = arrayPair.key();
            if (key == null || !key.is(Tree.Kind.REGULAR_STRING_LITERAL) || !searchKey.equals(CheckUtils.trimQuotes((LiteralTree)key))) continue;
            return Optional.of(arrayPair.value());
        }
        return Optional.empty();
    }

    public static boolean isMethodInheritedFromClassOrInterface(QualifiedName qualifiedName, MethodDeclarationTree methodDeclarationTree) {
        ClassDeclarationTree classTree = (ClassDeclarationTree)TreeUtils.findAncestorWithKind((Tree)methodDeclarationTree, Collections.singletonList(Tree.Kind.CLASS_DECLARATION));
        if (classTree != null) {
            return Symbols.get(classTree).isSubTypeOf(qualifiedName).isTrue();
        }
        return false;
    }

    public static boolean isSubClassOfTestCase(ClassDeclarationTree tree) {
        ClassSymbol symbol = Symbols.get(tree);
        return symbol.isSubTypeOf(QualifiedName.qualifiedName("PHPUnit\\Framework\\TestCase")).isTrue() || symbol.isSubTypeOf(QualifiedName.qualifiedName("PHPUnit_Framework_TestCase")).isTrue();
    }

    public static boolean isEmptyArrayConstructor(ExpressionTree arg) {
        return arg.is(Tree.Kind.ARRAY_INITIALIZER_FUNCTION, Tree.Kind.ARRAY_INITIALIZER_BRACKET) && ((ArrayInitializerTree)arg).arrayPairs().isEmpty();
    }
}

