/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2612")
public class POSIXFilePermissionsCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Make sure this permission is safe.";

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        String functionName = CheckUtils.lowerCaseFunctionName(tree);
        if (tree.callee().is(Tree.Kind.OBJECT_MEMBER_ACCESS)) {
            if ("chmod".equals(functionName)) {
                this.chmodSymfonyAndLaravelCheck(tree);
            }
        } else if ("chmod".equals(functionName)) {
            this.chmodCoreCheck(tree);
        } else if ("umask".equals(functionName)) {
            this.umaskCheck(tree);
        }
        super.visitFunctionCall(tree);
    }

    private void chmodCoreCheck(FunctionCallTree tree) {
        int mode;
        Optional<CallArgumentTree> permissionsArgument = CheckUtils.argument(tree, "permissions", 1);
        int n = mode = permissionsArgument.isPresent() ? this.resolveArgument(permissionsArgument.get(), 0) : 0;
        if (mode % 8 != 0) {
            this.context().newIssue(this, tree, MESSAGE);
        }
    }

    private void chmodSymfonyAndLaravelCheck(FunctionCallTree tree) {
        int umask;
        Optional<CallArgumentTree> modeArgument = CheckUtils.argument(tree, "mode", 1);
        Optional<CallArgumentTree> umaskArgument = CheckUtils.argument(tree, "umask", 2);
        int mode = modeArgument.isPresent() ? this.resolveArgument(modeArgument.get(), 0) : 0;
        int n = umask = umaskArgument.isPresent() ? this.resolveArgument(umaskArgument.get(), 0) : 0;
        if ((mode & ~umask) % 8 != 0) {
            this.context().newIssue(this, tree, MESSAGE);
        }
    }

    private void umaskCheck(FunctionCallTree tree) {
        int mask;
        Optional<CallArgumentTree> maskArgument = CheckUtils.argument(tree, "mask", 0);
        int n = mask = maskArgument.isPresent() ? this.resolveArgument(maskArgument.get(), 7) : 7;
        if (mask % 8 != 7) {
            this.context().newIssue(this, tree, MESSAGE);
        }
    }

    private int resolveArgument(CallArgumentTree argument, int defaultValue) {
        ExpressionTree argumentExpressionTree = CheckUtils.assignedValue(argument.value());
        if (argumentExpressionTree.is(Tree.Kind.REGULAR_STRING_LITERAL, Tree.Kind.NUMERIC_LITERAL)) {
            String literal = ((LiteralTree)argumentExpressionTree).value();
            return POSIXFilePermissionsCheck.getDecimalRepresentation(literal, defaultValue);
        }
        return defaultValue;
    }

    private static int getDecimalRepresentation(String argument, int defaultValue) {
        if (argument.matches("\"[0-9]*\"")) {
            return Integer.valueOf(CheckUtils.trimQuotes(argument));
        }
        if (argument.matches("^0[0-7]*$")) {
            return Integer.parseInt(argument, 8);
        }
        try {
            return Integer.parseInt(argument);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

