/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.regex;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.php.checks.regex.AbstractRegexCheck;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.CapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;

@Rule(key="S6328")
public class GroupReplacementCheck
extends AbstractRegexCheck {
    private static final String MESSAGE = "Referencing non-existing group%s: %s.";
    private static final String NUMBER_PATTERN = "0(?!\\d)|[1-9]\\d*+";
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("\\$(0(?!\\d)|[1-9]\\d*+)|\\$\\{(0(?!\\d)|[1-9]\\d*+)}|\\\\(0(?!\\d)|[1-9]\\d*+)");

    @Override
    protected Set<String> lookedUpFunctionNames() {
        return Set.of("preg_replace");
    }

    @Override
    public void checkRegex(RegexParseResult regexParseResult, FunctionCallTree regexFunctionCall) {
        if (regexParseResult.hasSyntaxErrors()) {
            return;
        }
        GroupFinder groupFinder = new GroupFinder();
        groupFinder.visit(regexParseResult);
        this.checkReplacement(regexFunctionCall, groupFinder.groups);
    }

    private void checkReplacement(FunctionCallTree tree, Set<CapturingGroupTree> groups) {
        CheckUtils.resolvedArgumentLiteral(tree, "replacement", 1).ifPresent(replacement -> {
            List<Integer> references = GroupReplacementCheck.collectReferences(replacement.value());
            references.removeIf(reference -> groups.stream().anyMatch(group -> group.getGroupNumber() == reference.intValue()));
            if (!references.isEmpty()) {
                List<String> stringReferences = references.stream().map(String::valueOf).toList();
                this.newIssue((Tree)replacement, String.format(MESSAGE, references.size() == 1 ? "" : "s", String.join((CharSequence)", ", stringReferences)));
            }
        });
    }

    private static List<Integer> collectReferences(String replacement) {
        Matcher match = REFERENCE_PATTERN.matcher(replacement);
        ArrayList<Integer> references = new ArrayList<Integer>();
        while (match.find()) {
            for (int i = 1; i <= 3; ++i) {
                Optional.ofNullable(match.group(i)).map(Integer::valueOf).filter(ref -> ref != 0).ifPresent(references::add);
            }
        }
        return references;
    }

    static class GroupFinder
    extends RegexBaseVisitor {
        private final Set<CapturingGroupTree> groups = new HashSet<CapturingGroupTree>();

        GroupFinder() {
        }

        @Override
        public void visitCapturingGroup(CapturingGroupTree group) {
            this.groups.add(group);
            super.visitCapturingGroup(group);
        }
    }
}

