/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.phpunit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.PhpUnitCheck;
import org.sonar.php.tree.TreeUtils;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2699")
public class NoAssertionInTestCheck
extends PhpUnitCheck {
    private static final String MESSAGE = "Add at least one assertion to this test case.";
    private static final Pattern ASSERTION_METHODS_PATTERN = Pattern.compile("(assert|verify|fail|pass|should|will|check|expect|validate|.*test).*");
    private static final List<String> TEST_CONTROL_FUNCTIONS = Arrays.asList("addtoassertioncount", "marktestskipped", "marktestincomplete");
    private final Map<MethodDeclarationTree, Boolean> assertionInMethod = new HashMap<MethodDeclarationTree, Boolean>();

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.assertionInMethod.clear();
        super.visitCompilationUnit(tree);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (!this.isTestCaseMethod(tree)) {
            return;
        }
        if (TreeUtils.hasAnnotationOrAttribute(tree, "expectedException") || TreeUtils.hasAnnotationOrAttribute(tree, "doesNotPerformAssertions") || TreeUtils.hasAnnotationOrAttribute(tree, "expectedDeprecation")) {
            return;
        }
        AssertionsFindVisitor assertionsFindVisitor = new AssertionsFindVisitor(this.context().symbolTable());
        tree.accept(assertionsFindVisitor);
        if (!assertionsFindVisitor.hasFoundAssertion) {
            this.newIssue(tree.name(), MESSAGE);
        }
    }

    private class AssertionsFindVisitor
    extends PHPVisitorCheck {
        private boolean hasFoundAssertion = false;
        private final SymbolTable symbolTable;

        private AssertionsFindVisitor(SymbolTable symbolTable) {
            this.symbolTable = symbolTable;
        }

        @Override
        public void visitFunctionCall(FunctionCallTree tree) {
            String functionName = CheckUtils.lowerCaseFunctionName(tree);
            if (PhpUnitCheck.isAssertion(tree) || this.functionNameCountsAsAssertion(functionName) || this.isDynamicFunctionCall(tree) || this.isLocalMethodWithAssertion(tree)) {
                this.hasFoundAssertion = true;
            }
            super.visitFunctionCall(tree);
        }

        private boolean functionNameCountsAsAssertion(@Nullable String functionName) {
            if (functionName == null) {
                return false;
            }
            return ASSERTION_METHODS_PATTERN.matcher(functionName).matches() || TEST_CONTROL_FUNCTIONS.contains(functionName);
        }

        private boolean isDynamicFunctionCall(FunctionCallTree tree) {
            Tree functionNameTree = tree.callee();
            if (functionNameTree.is(Tree.Kind.CLASS_MEMBER_ACCESS, Tree.Kind.OBJECT_MEMBER_ACCESS)) {
                functionNameTree = ((MemberAccessTree)functionNameTree).member();
            }
            return !functionNameTree.is(Tree.Kind.NAMESPACE_NAME, Tree.Kind.NAME_IDENTIFIER);
        }

        private boolean isLocalMethodWithAssertion(FunctionCallTree tree) {
            Optional<MethodDeclarationTree> optionalMethodDeclaration = this.getMethodDeclarationTree(tree);
            if (!optionalMethodDeclaration.isPresent()) {
                return false;
            }
            MethodDeclarationTree methodDeclaration = optionalMethodDeclaration.get();
            if (!NoAssertionInTestCheck.this.assertionInMethod.containsKey(methodDeclaration)) {
                NoAssertionInTestCheck.this.assertionInMethod.put(methodDeclaration, false);
                AssertionsFindVisitor v = new AssertionsFindVisitor(this.symbolTable);
                methodDeclaration.accept(v);
                NoAssertionInTestCheck.this.assertionInMethod.put(methodDeclaration, v.hasFoundAssertion);
            }
            return NoAssertionInTestCheck.this.assertionInMethod.get(methodDeclaration);
        }

        private Optional<MethodDeclarationTree> getMethodDeclarationTree(FunctionCallTree tree) {
            ExpressionTree callee = tree.callee();
            if (!callee.is(Tree.Kind.CLASS_MEMBER_ACCESS, Tree.Kind.OBJECT_MEMBER_ACCESS)) {
                return Optional.empty();
            }
            Symbol symbol = this.symbolTable.getSymbol(((MemberAccessTree)callee).member());
            if (symbol != null && symbol.is(Symbol.Kind.FUNCTION)) {
                return Optional.ofNullable((MethodDeclarationTree)TreeUtils.findAncestorWithKind((Tree)symbol.declaration(), Tree.Kind.METHOD_DECLARATION));
            }
            return Optional.empty();
        }
    }
}

